/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.item;

import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ArmorMaterialUtil {
    public static ArmorMaterial of(String name, int[] baseDurability, int durabilityMul, int[] protection, int enchantAbility, SoundEvent equipSound, float toughness, float knockBackResistance, ItemLike ... repairIngredients) {
        return ArmorMaterialUtil.of(name, (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, baseDurability[3]);
            map.put(ArmorItem.Type.CHESTPLATE, baseDurability[2]);
            map.put(ArmorItem.Type.LEGGINGS, baseDurability[1]);
            map.put(ArmorItem.Type.BOOTS, baseDurability[0]);
        }), durabilityMul, (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, protection[3]);
            map.put(ArmorItem.Type.CHESTPLATE, protection[2]);
            map.put(ArmorItem.Type.LEGGINGS, protection[1]);
            map.put(ArmorItem.Type.BOOTS, protection[0]);
        }), enchantAbility, equipSound, toughness, knockBackResistance, repairIngredients);
    }

    public static ArmorMaterial of(final String name, final EnumMap<ArmorItem.Type, Integer> baseDurability, final int durabilityMul, final EnumMap<ArmorItem.Type, Integer> protection, final int enchantAbility, SoundEvent equipSound, final float toughness, final float knockBackResistance, final ItemLike ... repairIngredients) {
        if (equipSound == null) {
            equipSound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(""));
        }
        final SoundEvent finalEquipSound = equipSound;
        return new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type slot) {
                return (Integer)baseDurability.get(slot) * durabilityMul;
            }

            public int m_7366_(ArmorItem.Type slot) {
                return (Integer)protection.get(slot);
            }

            public int m_6646_() {
                return enchantAbility;
            }

            public SoundEvent m_7344_() {
                return finalEquipSound;
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43929_((ItemLike[])repairIngredients);
            }

            public String m_6082_() {
                return name;
            }

            public float m_6651_() {
                return toughness;
            }

            public float m_6649_() {
                return knockBackResistance;
            }
        };
    }
}

