/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object;

import com.iafenvoy.uranus.object.VecUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class SoundUtil {
    public static void playSound(Level world, double x, double y, double z, ResourceLocation soundId, float volume, float pitch) {
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundId);
        if (soundEvent == null) {
            return;
        }
        if (world.m_5776_()) {
            world.m_7785_(x, y, z, soundEvent, SoundSource.NEUTRAL, volume, pitch, false);
        } else {
            world.m_5594_(null, VecUtil.createBlockPos(x, y, z), soundEvent, SoundSource.NEUTRAL, volume, pitch);
        }
    }

    public static void playPlayerSound(Level world, double x, double y, double z, ResourceLocation soundId, float volume, float pitch) {
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundId);
        if (soundEvent == null) {
            return;
        }
        if (world.m_5776_()) {
            world.m_7785_(x, y, z, soundEvent, SoundSource.PLAYERS, volume, pitch, false);
        } else {
            world.m_5594_(null, VecUtil.createBlockPos(x, y, z), soundEvent, SoundSource.PLAYERS, volume, pitch);
        }
    }

    public static void stopSound(Level world, ResourceLocation soundId) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ClientboundStopSoundPacket stopSoundPacket = new ClientboundStopSoundPacket(soundId, SoundSource.NEUTRAL);
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                serverPlayer.f_8906_.m_9829_((Packet)stopSoundPacket);
            }
        }
    }
}

