/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.mixin;

import com.iafenvoy.uranus.event.LivingEntityEvents;
import com.iafenvoy.uranus.object.entity.IUranusDataEntity;
import com.iafenvoy.uranus.object.item.ISwingable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IUranusDataEntity {
    @Unique
    private static final EntityDataAccessor<CompoundTag> URANUS_DATA = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);

    protected LivingEntityMixin(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"initDataTracker"})
    private void registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(URANUS_DATA, (Object)new CompoundTag());
    }

    @Inject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt"})
    private void writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        CompoundTag data = this.getUranusEntityData();
        if (data != null) {
            compoundNBT.m_128365_("UranusData", (Tag)data);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt"})
    private void readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        if (compoundNBT.m_128441_("UranusData")) {
            this.setUranusEntityData(compoundNBT.m_128469_("UranusData"));
        }
    }

    @Override
    public CompoundTag getUranusEntityData() {
        return (CompoundTag)this.f_19804_.m_135370_(URANUS_DATA);
    }

    @Override
    public void setUranusEntityData(CompoundTag nbt) {
        this.f_19804_.m_135381_(URANUS_DATA, (Object)nbt);
    }

    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    @Inject(method={"swingHand(Lnet/minecraft/util/Hand;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSwingHand(InteractionHand hand, boolean fromServerPlayer, CallbackInfo ci) {
        ISwingable iSwingable;
        ItemStack stack = this.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof ISwingable && (iSwingable = (ISwingable)item).onEntitySwing(stack, this)) {
            ci.cancel();
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")})
    public void onEntityFall(float fallDistance, float multiplier, DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityEvents.FALL.invoker().onFall((LivingEntity)this, fallDistance, multiplier, source);
    }
}

