/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.mixin;

import com.iafenvoy.uranus.client.render.armor.IArmorRendererBase;
import com.iafenvoy.uranus.client.render.armor.IArmorTextureProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={HumanoidArmorLayer.class})
public abstract class ArmorFeatureRendererMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public ArmorFeatureRendererMixin(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(method={"getArmorTexture"}, at={@At(value="TAIL")}, cancellable=true)
    private void pushTexture(ArmorItem item, boolean secondLayer, String overlay, CallbackInfoReturnable<ResourceLocation> cir) {
        if (item instanceof IArmorTextureProvider) {
            IArmorTextureProvider provider = (IArmorTextureProvider)item;
            cir.setReturnValue((Object)provider.getArmorTexture(item.m_7968_(), null, item.m_40402_(), overlay));
        }
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArmor(PoseStack matrices, MultiBufferSource vertexConsumers, T entity, EquipmentSlot armorSlot, int light, A model, CallbackInfo ci) {
        ItemStack stack = entity.m_6844_(armorSlot);
        IArmorRendererBase<? extends LivingEntity> renderer = IArmorRendererBase.RENDERERS.get(stack.m_41720_());
        if (renderer != null) {
            renderer.render(matrices, vertexConsumers, (LivingEntity)entity, armorSlot, light, stack, (HumanoidModel<? extends LivingEntity>)((HumanoidModel)this.m_117386_()));
            ci.cancel();
        }
    }
}

