/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.forge.component;

import com.iafenvoy.uranus.forge.component.ITickableCapability;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilitySyncHelper {
    public static final ResourceLocation CAPABILITY_SYNC = new ResourceLocation("uranus", "capability_sync");
    private static final List<LivingCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability>> LIVINGS = new ArrayList<LivingCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability>>();
    private static final List<PlayerCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability>> PLAYERS = new ArrayList<PlayerCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability>>();

    public static <P extends ICapabilityProvider, S extends ITickableCapability> void registerForLiving(ResourceLocation id, Capability<S> capability, Function<LivingEntity, P> constructor) {
        LIVINGS.add(new LivingCapabilityHolder<P, S>(id, capability, constructor));
    }

    public static <P extends ICapabilityProvider, S extends ITickableCapability> void registerForPlayer(ResourceLocation id, Capability<S> capability, Function<Player, P> constructor) {
        CapabilitySyncHelper.registerForPlayer(id, capability, constructor, CopyPolicy.KEEP_INVENTORY);
    }

    public static <P extends ICapabilityProvider, S extends ITickableCapability> void registerForPlayer(ResourceLocation id, Capability<S> capability, Function<Player, P> constructor, CopyPolicy copyPolicy) {
        PLAYERS.add(new PlayerCapabilityHolder<P, S>(id, capability, constructor, copyPolicy));
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Iterator<Object> iterator = event.getObject();
        if (iterator instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)iterator;
            iterator = LIVINGS.iterator();
            while (iterator.hasNext()) {
                LivingCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability> livingCapabilityHolder = iterator.next();
                if (living.getCapability(livingCapabilityHolder.capability).isPresent()) continue;
                event.addCapability(livingCapabilityHolder.id, (ICapabilityProvider)livingCapabilityHolder.constructor.apply(living));
            }
        }
        if ((iterator = event.getObject()) instanceof Player) {
            Player player = (Player)iterator;
            for (PlayerCapabilityHolder playerCapabilityHolder : PLAYERS) {
                if (player.getCapability(playerCapabilityHolder.capability).isPresent()) continue;
                event.addCapability(playerCapabilityHolder.id, (ICapabilityProvider)playerCapabilityHolder.constructor.apply(player));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (PlayerCapabilityHolder playerCapabilityHolder : PLAYERS) {
                serverPlayer.getCapability(playerCapabilityHolder.capability).resolve().ifPresent(storage -> NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)CAPABILITY_SYNC, (FriendlyByteBuf)PacketBufferUtils.create().m_130085_(holder.id).m_130079_((CompoundTag)storage.serializeNBT())));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        for (LivingCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability> holder : LIVINGS) {
            Optional optional = living.getCapability(holder.capability).resolve();
            if (optional.isEmpty()) continue;
            ITickableCapability capability = (ITickableCapability)optional.get();
            capability.tick();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        for (PlayerCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability> holder : PLAYERS) {
            Optional optional = player.getCapability(holder.capability).resolve();
            if (optional.isEmpty()) continue;
            ITickableCapability capability = (ITickableCapability)optional.get();
            capability.tick();
            if (!capability.isDirty() || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)CAPABILITY_SYNC, (FriendlyByteBuf)PacketBufferUtils.create().m_130085_(holder.id).m_130079_((CompoundTag)capability.serializeNBT()));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player origin = event.getOriginal();
        Player player = event.getEntity();
        for (PlayerCapabilityHolder<? extends ICapabilityProvider, ? extends ITickableCapability> holder : PLAYERS) {
            if (event.isWasDeath() && !holder.copyPolicy.shouldCopyOnDeath(player.m_20193_())) continue;
            Optional originalCapability = origin.getCapability(holder.capability).resolve();
            Optional newCapability = player.getCapability(holder.capability).resolve();
            if (originalCapability.isEmpty() || newCapability.isEmpty()) continue;
            ((ITickableCapability)newCapability.get()).deserializeNBT((Tag)((CompoundTag)((ITickableCapability)originalCapability.get()).serializeNBT()));
        }
    }

    public static class LivingCapabilityHolder<P extends ICapabilityProvider, S extends ITickableCapability> {
        private final ResourceLocation id;
        private final Capability<S> capability;
        private final Function<LivingEntity, P> constructor;

        public LivingCapabilityHolder(ResourceLocation id, Capability<S> capability, Function<LivingEntity, P> constructor) {
            this.id = id;
            this.capability = capability;
            this.constructor = constructor;
        }
    }

    public static enum CopyPolicy {
        ALWAYS,
        KEEP_INVENTORY,
        NEVER;


        public boolean shouldCopyOnDeath(Level world) {
            if (world.m_46469_().m_46207_(GameRules.f_46133_)) {
                return this != NEVER;
            }
            return this == ALWAYS;
        }
    }

    public static class PlayerCapabilityHolder<P extends ICapabilityProvider, S extends ITickableCapability> {
        private final ResourceLocation id;
        private final Capability<S> capability;
        private final Function<Player, P> constructor;
        private final CopyPolicy copyPolicy;

        public PlayerCapabilityHolder(ResourceLocation id, Capability<S> capability, Function<Player, P> constructor, CopyPolicy copyPolicy) {
            this.id = id;
            this.capability = capability;
            this.constructor = constructor;
            this.copyPolicy = copyPolicy;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void init(FMLClientSetupEvent event) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CAPABILITY_SYNC, (buf, context) -> {
                ResourceLocation id = buf.m_130281_();
                CompoundTag compound = buf.m_130260_();
                PLAYERS.stream().filter(x -> x.id.equals((Object)id)).findFirst().ifPresent(holder -> context.queue(() -> {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (player != null) {
                        player.getCapability(holder.capability).resolve().ifPresent(x -> x.deserializeNBT((Tag)compound));
                    }
                }));
            });
        }
    }
}

