/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.render;

import com.iafenvoy.uranus.client.render.Stage;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntityRendererBase<T extends Mob>
extends HumanoidMobRenderer<T, HumanoidModel<T>> {
    private final Stage.StagedEntityTextureProvider textureId;

    public EntityRendererBase(EntityRendererProvider.Context context, Stage.StagedEntityTextureProvider textureId, final @Nullable ResourceLocation eyeTextureId) {
        super(context, new HumanoidModel(context.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.textureId = textureId;
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        if (eyeTextureId != null) {
            this.m_115326_((RenderLayer)new EyesLayer<T, HumanoidModel<T>>((RenderLayerParent)this){

                public RenderType m_5708_() {
                    return RenderType.m_110488_((ResourceLocation)eyeTextureId);
                }
            });
        }
    }

    public ResourceLocation getTexture(T entity) {
        if (entity instanceof Stage.StagedEntity) {
            Stage.StagedEntity stagedEntity = (Stage.StagedEntity)entity;
            return this.textureId.getTexture(stagedEntity.getStage());
        }
        return this.textureId.getTexture();
    }
}

