/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix.core;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.network.SPacketSyncAffixData;

public abstract class BasicAffix
implements IAffix {
    private final String id;
    private final AffixCategory category;

    public BasicAffix(String id, AffixCategory category) {
        this(id, category, false);
    }

    public BasicAffix(String id, AffixCategory category, boolean hasSubscriptions) {
        this.id = id;
        this.category = category;
        if (hasSubscriptions) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public AffixCategory getCategory() {
        return this.category;
    }

    @Override
    public void sync(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        CompoundTag tag = this.writeSyncTag(champion);
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)new SPacketSyncAffixData(livingEntity.m_19879_(), this.getIdentifier(), tag));
    }

    public static boolean canTarget(LivingEntity livingEntity, LivingEntity target, boolean sightCheck) {
        if (target == null || !target.m_6084_() || target instanceof ArmorStand || sightCheck && !BasicAffix.hasLineOfSight(livingEntity, target)) {
            return false;
        }
        AttributeInstance attributeInstance = livingEntity.m_21051_(Attributes.f_22277_);
        double range = attributeInstance == null ? 16.0 : attributeInstance.m_22135_();
        range = ChampionsConfig.affixTargetRange == 0.0 ? range : Math.min(range, ChampionsConfig.affixTargetRange);
        return (double)livingEntity.m_20270_((Entity)target) <= range;
    }

    private static boolean hasLineOfSight(LivingEntity livingEntity, LivingEntity target) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            return mob.m_21574_().m_148306_((Entity)target);
        }
        return livingEntity.m_142582_((Entity)target);
    }
}

