/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.utils;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a#\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00020\u00020\b*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0018\u0010\u000b\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00020\u00020\b*\u00020\n\u001a\u0015\u0010\f\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u000e\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u00a8\u0006\u000f"}, d2={"enchantmentLevel", "", "Lnet/minecraft/world/item/ItemStack;", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "isItemEnchanted", "", "getItemFromEnchantment", "Lkotlin/sequences/Sequence;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/entity/player/Player;", "getAllEnchantmentItems", "getAllArmorsEnchantmentsTotalLevel", "Lnet/minecraft/world/entity/LivingEntity;", "armorHasEnchantment", "SoManyEnchantments-1.20.1"})
@SourceDebugExtension(value={"SMAP\nEnchantmentsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantmentsUtils.kt\norg/error1015/somanyenchantments/utils/EnchantmentsUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,37:1\n1317#2,2:38\n1251#2,2:40\n*S KotlinDebug\n*F\n+ 1 EnchantmentsUtils.kt\norg/error1015/somanyenchantments/utils/EnchantmentsUtilsKt\n*L\n33#1:38,2\n37#1:40,2\n*E\n"})
public final class EnchantmentsUtilsKt {
    public static final int enchantmentLevel(@NotNull ItemStack $this$enchantmentLevel, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$enchantmentLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Integer n = (Integer)$this$enchantmentLevel.getAllEnchantments().get(enchantment);
        return n != null ? n : 0;
    }

    public static final boolean isItemEnchanted(@NotNull ItemStack $this$isItemEnchanted, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$isItemEnchanted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Map map = $this$isItemEnchanted.getAllEnchantments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllEnchantments(...)");
        return map.containsKey(enchantment);
    }

    @NotNull
    public static final Sequence<ItemStack> getItemFromEnchantment(@NotNull Player $this$getItemFromEnchantment, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getItemFromEnchantment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        NonNullList nonNullList = $this$getItemFromEnchantment.m_150109_().f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)nonNullList)), arg_0 -> EnchantmentsUtilsKt.getItemFromEnchantment$lambda$0(enchantment, arg_0));
    }

    @NotNull
    public static final Sequence<ItemStack> getAllEnchantmentItems(@NotNull Player $this$getAllEnchantmentItems) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllEnchantmentItems, (String)"<this>");
        NonNullList nonNullList = $this$getAllEnchantmentItems.m_150109_().f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)nonNullList)), EnchantmentsUtilsKt::getAllEnchantmentItems$lambda$1);
    }

    public static final int getAllArmorsEnchantmentsTotalLevel(@NotNull LivingEntity $this$getAllArmorsEnchantmentsTotalLevel, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllArmorsEnchantmentsTotalLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        int level = 0;
        Iterable iterable = $this$getAllArmorsEnchantmentsTotalLevel.m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)iterable), arg_0 -> EnchantmentsUtilsKt.getAllArmorsEnchantmentsTotalLevel$lambda$2(enchantment, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            level += EnchantmentsUtilsKt.enchantmentLevel(it, enchantment);
        }
        return level;
    }

    public static final boolean armorHasEnchantment(@NotNull LivingEntity $this$armorHasEnchantment, @NotNull Enchantment enchantment) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$armorHasEnchantment, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
            Iterable iterable = $this$armorHasEnchantment.m_6168_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
            Sequence $this$any$iv = CollectionsKt.asSequence((Iterable)iterable);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!EnchantmentsUtilsKt.isItemEnchanted(it, enchantment)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean getItemFromEnchantment$lambda$0(Enchantment $enchantment, ItemStack it) {
        Intrinsics.checkNotNull((Object)it);
        return EnchantmentsUtilsKt.isItemEnchanted(it, $enchantment);
    }

    private static final boolean getAllEnchantmentItems$lambda$1(ItemStack it) {
        return it.m_41793_();
    }

    private static final boolean getAllArmorsEnchantmentsTotalLevel$lambda$2(Enchantment $enchantment, ItemStack it) {
        Intrinsics.checkNotNull((Object)it);
        return EnchantmentsUtilsKt.isItemEnchanted(it, $enchantment);
    }
}

