/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.mixin;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.error1015.somanyenchantments.enchantments.RegisterEnchantments;
import org.error1015.somanyenchantments.utils.EnchantmentsUtilsKt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Inject(method={"getFishingLuckBonus"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getFishingLuckBonus(ItemStack pStack, CallbackInfoReturnable<Integer> cir) {
        if (EnchantmentsUtilsKt.isItemEnchanted(pStack, (Enchantment)RegisterEnchantments.BETTER_FISH_LUCK.get())) {
            int enchantmentLevel = EnchantmentsUtilsKt.enchantmentLevel(pStack, (Enchantment)RegisterEnchantments.BETTER_FISH_LUCK.get());
            cir.setReturnValue((Object)(enchantmentLevel * 3));
        }
    }

    @Inject(method={"getFishingSpeedBonus"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getFishingSpeedBonus(ItemStack pStack, CallbackInfoReturnable<Integer> cir) {
        if (EnchantmentsUtilsKt.isItemEnchanted(pStack, (Enchantment)RegisterEnchantments.BETTER_LURE.get())) {
            int betterLureLevel = EnchantmentsUtilsKt.enchantmentLevel(pStack, (Enchantment)RegisterEnchantments.BETTER_LURE.get());
            cir.setReturnValue((Object)Math.min(betterLureLevel, 5));
        }
    }
}

