/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.events;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.error1015.somanyenchantments.enchantments.weather.ClearSkyLoveSongEnchantment;
import org.error1015.somanyenchantments.enchantments.weather.RainBlessingEnchantment;
import org.error1015.somanyenchantments.utils.EnchantmentsUtilsKt;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lorg/error1015/somanyenchantments/events/WeatherEnchantmentEventHandler;", "", "<init>", "()V", "doClearLoveEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doRainBlessingEvent", "SoManyEnchantments-1.20.1"})
public final class WeatherEnchantmentEventHandler {
    @NotNull
    public static final WeatherEnchantmentEventHandler INSTANCE = new WeatherEnchantmentEventHandler();

    private WeatherEnchantmentEventHandler() {
    }

    @SubscribeEvent
    public final void doClearLoveEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            int level = EnchantmentsUtilsKt.enchantmentLevel(itemStack, ClearSkyLoveSongEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            if (!attacker.m_9236_().m_45527_(attacker.m_20183_())) {
                return;
            }
            if (!event.getEntity().m_9236_().m_46471_() && !event.getEntity().m_9236_().m_46470_()) {
                event.setAmount(event.getAmount() + (0.5f + 0.75f * (float)level));
            } else {
                event.setAmount(event.getAmount() - 0.6f * (float)level);
                if (Math.random() < (double)((float)level * 0.03f)) {
                    Level level2 = attacker.m_9236_();
                    Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ((ServerLevel)level2).m_8606_(1600, 0, false, false);
                }
            }
        }
    }

    @SubscribeEvent
    public final void doRainBlessingEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            int level = EnchantmentsUtilsKt.enchantmentLevel(itemStack, RainBlessingEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            if (!attacker.m_9236_().m_45527_(attacker.m_20183_())) {
                return;
            }
            if (attacker.m_9236_().m_46471_()) {
                event.setAmount(event.getAmount() + (0.8f * (float)level + 0.2f));
            } else {
                event.setAmount(event.getAmount() - (0.3f * (float)level + 0.2f));
                if (Math.random() < (double)((float)level * 0.03f)) {
                    Level level2 = attacker.m_9236_();
                    Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ((ServerLevel)level2).m_8606_(0, 600, true, false);
                }
            }
        }
    }
}

