/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.events;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.error1015.somanyenchantments.Config;
import org.error1015.somanyenchantments.enchantments.weapon.AntidoteEnchantment;
import org.error1015.somanyenchantments.enchantments.weapon.BlessSwordEnchantment;
import org.error1015.somanyenchantments.enchantments.weapon.BreakMagicEnchantment;
import org.error1015.somanyenchantments.enchantments.weapon.LifeStealEnchantment;
import org.error1015.somanyenchantments.enchantments.weapon.MagicBlessEnchantment;
import org.error1015.somanyenchantments.enchantments.weapon.SpeedIsUnbreakableEnchantment;
import org.error1015.somanyenchantments.utils.EffectUtilsKt;
import org.error1015.somanyenchantments.utils.EnchantmentsUtilsKt;
import org.error1015.somanyenchantments.utils.UUIDUtilsKt;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0007R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/error1015/somanyenchantments/events/WeaponEnchantmentsHandler;", "", "<init>", "()V", "debuffs", "", "Lnet/minecraft/world/effect/MobEffect;", "kotlin.jvm.PlatformType", "getDebuffs", "()Ljava/util/List;", "doLifeStealEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doBlessSwordEvent", "doBreakMagicEvent", "doSpeedIsUnbreakableEvent", "doAddAttackSpeedEvent", "Lnet/minecraftforge/event/ItemAttributeModifierEvent;", "doMagicBlessEvent", "doAntidoteEvent", "Lnet/minecraftforge/event/entity/living/LivingAttackEvent;", "SoManyEnchantments-1.20.1"})
public final class WeaponEnchantmentsHandler {
    @NotNull
    public static final WeaponEnchantmentsHandler INSTANCE = new WeaponEnchantmentsHandler();
    @NotNull
    private static final List<MobEffect> debuffs;

    private WeaponEnchantmentsHandler() {
    }

    @NotNull
    public final List<MobEffect> getDebuffs() {
        return debuffs;
    }

    @SubscribeEvent
    public final void doLifeStealEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            ItemStack itemStack = player.m_6844_(EquipmentSlot.MAINHAND);
            if (itemStack == null) {
                return;
            }
            ItemStack mainHandItem = itemStack;
            if (EnchantmentsUtilsKt.isItemEnchanted(mainHandItem, LifeStealEnchantment.INSTANCE)) {
                float f;
                int level = EnchantmentsUtilsKt.enchantmentLevel(mainHandItem, LifeStealEnchantment.INSTANCE);
                if (level == 0) {
                    return;
                }
                if (level == 1) {
                    f = event.getAmount() * 0.05f;
                } else {
                    float f2 = event.getAmount() * 0.05f;
                    float f3 = level;
                    Object object = Config.INSTANCE.getLifeSteal().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    f = f2 + f3 * ((Number)object).floatValue();
                }
                float value = f;
                player.m_5634_(value);
                Integer n = (Integer)Config.INSTANCE.getLifeStealHurtTarget().get();
                if (n == null) {
                    return;
                }
                int hurtValue = n;
                if (hurtValue != 0) {
                    event.setAmount(event.getAmount() * ((float)hurtValue * value));
                }
            }
        }
    }

    @SubscribeEvent
    public final void doBlessSwordEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            Intrinsics.checkNotNull((Object)mainHandItem);
            int level = EnchantmentsUtilsKt.enchantmentLevel(mainHandItem, BlessSwordEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            player.m_5634_(event.getAmount() * (float)level * 0.03f);
            if (Intrinsics.areEqual((Object)event.getEntity().m_6336_(), (Object)MobType.f_21641_) && mainHandItem.m_41720_() instanceof SwordItem) {
                event.setAmount(event.getAmount() + (0.6f * (float)level + 1.0f + (event.getAmount() * 0.04f * (float)level + 1.0f)));
            }
        }
    }

    @SubscribeEvent
    public final void doBreakMagicEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            LivingEntity livingEntity;
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity target = event.getEntity();
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            int enchantmentLevel = EnchantmentsUtilsKt.enchantmentLevel(itemStack, BreakMagicEnchantment.INSTANCE);
            if (enchantmentLevel == 0) {
                return;
            }
            if (target.m_21220_().isEmpty()) {
                return;
            }
            int count = target.m_21220_().size();
            event.setAmount(event.getAmount() + ((livingEntity = target) instanceof Witch ? 1.5f * (float)enchantmentLevel : (livingEntity instanceof Ravager ? 1.5f * (float)enchantmentLevel : 0.625f * (float)count * (float)enchantmentLevel)));
        }
    }

    @SubscribeEvent
    public final void doSpeedIsUnbreakableEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            int level = EnchantmentsUtilsKt.enchantmentLevel(itemStack, SpeedIsUnbreakableEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            if (Math.random() < (double)(0.01f * (float)level + 0.25f)) {
                target.f_19802_ = 23 - level * 3;
            }
        }
    }

    @SubscribeEvent
    public final void doAddAttackSpeedEvent(@NotNull ItemAttributeModifierEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        if (EnchantmentsUtilsKt.isItemEnchanted(itemStack, SpeedIsUnbreakableEnchantment.INSTANCE)) {
            ItemStack itemStack2 = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemStack(...)");
            int level = EnchantmentsUtilsKt.enchantmentLevel(itemStack2, SpeedIsUnbreakableEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            if (event.getSlotType() == EquipmentSlot.MAINHAND) {
                event.addModifier(Attributes.f_22283_, new AttributeModifier(UUIDUtilsKt.asUUID("e6109481-134f-4c54-a535-29c3ae5c7a21"), "attackSpeed", 0.15 * (double)level, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    @SubscribeEvent
    public final void doMagicBlessEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            int level = EnchantmentsUtilsKt.enchantmentLevel(itemStack, MagicBlessEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            if (Math.random() < 0.4) {
                int debuffIndex = Random.Default.nextInt(0, debuffs.size());
                MobEffect mobEffect = debuffs.get(debuffIndex);
                if (mobEffect == null) {
                    return;
                }
                MobEffect debuff = mobEffect;
                int debuffDuration = Random.Default.nextInt(20, 20 * level + 1);
                int debuffLevel = Random.Default.nextInt(0, level);
                boolean bl = Intrinsics.areEqual((Object)target.m_6336_(), (Object)MobType.f_21641_) && Intrinsics.areEqual((Object)debuff, (Object)MobEffects.f_19602_) ? target.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 5, debuffLevel)) : (Intrinsics.areEqual((Object)debuff, (Object)MobEffects.f_19602_) ? target.m_7292_(new MobEffectInstance(debuff, 5, debuffLevel)) : target.m_7292_(new MobEffectInstance(debuff, debuffDuration, debuffLevel)));
            }
        }
    }

    @SubscribeEvent
    public final void doAntidoteEvent(@NotNull LivingAttackEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            MobEffectInstance mobEffectInstance = EffectUtilsKt.getRandomDebuff(attacker);
            if (mobEffectInstance == null) {
                return;
            }
            MobEffectInstance debuff = mobEffectInstance;
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            if (EnchantmentsUtilsKt.isItemEnchanted(itemStack, AntidoteEnchantment.INSTANCE) && Math.random() < 0.2) {
                attacker.m_21195_(debuff.m_19544_());
            }
        }
    }

    private static final boolean debuffs$lambda$0(MobEffect it) {
        return it.m_19483_() == MobEffectCategory.HARMFUL;
    }

    static {
        IForgeRegistry iForgeRegistry = ForgeRegistries.MOB_EFFECTS;
        Intrinsics.checkNotNullExpressionValue((Object)iForgeRegistry, (String)"MOB_EFFECTS");
        debuffs = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)iForgeRegistry)), WeaponEnchantmentsHandler::debuffs$lambda$0));
    }
}

