/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.events;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.error1015.somanyenchantments.enchantments.protection.MagicProtectionEnchantment;
import org.error1015.somanyenchantments.enchantments.protection.PhysicsProtectionEnchantment;
import org.error1015.somanyenchantments.utils.DamageSourceUtilsKt;
import org.error1015.somanyenchantments.utils.EnchantmentsUtilsKt;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lorg/error1015/somanyenchantments/events/ProtectionEnchantmentEventHandler;", "", "<init>", "()V", "doMagicProtectionEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doPhysicsProtectionEvent", "SoManyEnchantments-1.20.1"})
public final class ProtectionEnchantmentEventHandler {
    @NotNull
    public static final ProtectionEnchantmentEventHandler INSTANCE = new ProtectionEnchantmentEventHandler();

    private ProtectionEnchantmentEventHandler() {
    }

    @SubscribeEvent
    public final void doMagicProtectionEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource() == null) {
            return;
        }
        if (event.getSource().m_276093_(DamageTypes.f_268515_)) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            int level = EnchantmentsUtilsKt.getAllArmorsEnchantmentsTotalLevel(target, MagicProtectionEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            event.setAmount(event.getAmount() - (float)level * 0.8f);
        }
    }

    @SubscribeEvent
    public final void doPhysicsProtectionEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        if (DamageSourceUtilsKt.isLivingEntityAttack(damageSource)) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            int level = EnchantmentsUtilsKt.getAllArmorsEnchantmentsTotalLevel(target, PhysicsProtectionEnchantment.INSTANCE);
            if (level <= 0) {
                return;
            }
            event.setAmount(event.getAmount() - (float)level * 0.5f);
        }
    }
}

