/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.error1015.somanyenchantments.Config;
import org.error1015.somanyenchantments.enchantments.curse.FrailtyCurseEnchantment;
import org.error1015.somanyenchantments.enchantments.curse.MagicCurseEnchantment;
import org.error1015.somanyenchantments.enchantments.curse.RottenCurseEnchantment;
import org.error1015.somanyenchantments.enchantments.curse.SealedCurseEnchantment;
import org.error1015.somanyenchantments.enchantments.curse.UnpredictableEnchantment;
import org.error1015.somanyenchantments.utils.EffectUtilsKt;
import org.error1015.somanyenchantments.utils.EnchantmentsUtilsKt;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0007R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/error1015/somanyenchantments/events/CurseEnchantmentHandler;", "", "<init>", "()V", "curses", "", "Lnet/minecraft/world/item/enchantment/Enchantment;", "kotlin.jvm.PlatformType", "getCurses", "()Ljava/util/List;", "doUnpredictableEnchantmentEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doFrailtyCurseEnchantmentEvent", "doSealedCurseEnchantmentEvent", "Lnet/minecraftforge/event/entity/living/LivingAttackEvent;", "doRottenCurseEnchantmentEvent", "Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;", "doMagicCurseEvent", "SoManyEnchantments-1.20.1"})
public final class CurseEnchantmentHandler {
    @NotNull
    public static final CurseEnchantmentHandler INSTANCE = new CurseEnchantmentHandler();
    @NotNull
    private static final List<Enchantment> curses;

    private CurseEnchantmentHandler() {
    }

    @NotNull
    public final List<Enchantment> getCurses() {
        return curses;
    }

    @SubscribeEvent
    public final void doUnpredictableEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            ItemStack itemStack = player.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            if (EnchantmentsUtilsKt.isItemEnchanted(itemStack, UnpredictableEnchantment.INSTANCE)) {
                ItemStack itemStack2 = player.m_21205_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getMainHandItem(...)");
                int level = EnchantmentsUtilsKt.enchantmentLevel(itemStack2, UnpredictableEnchantment.INSTANCE);
                if (level == 0) {
                    return;
                }
                float value = Random.Default.nextFloat() + 1.25f * (float)level * event.getAmount();
                if (Math.random() <= 0.32) {
                    event.getEntity().m_5634_(value);
                    event.setCanceled(true);
                } else {
                    event.setAmount(value + (float)2);
                }
            }
        }
    }

    @SubscribeEvent
    public final void doFrailtyCurseEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            int level = EnchantmentsUtilsKt.getAllArmorsEnchantmentsTotalLevel((LivingEntity)player, FrailtyCurseEnchantment.INSTANCE);
            if (level == 0) {
                return;
            }
            event.setAmount(event.getAmount() + (float)level * 0.4f);
        }
    }

    @SubscribeEvent
    public final void doSealedCurseEnchantmentEvent(@NotNull LivingAttackEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            ItemStack itemStack = attacker.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            if (EnchantmentsUtilsKt.isItemEnchanted(itemStack, SealedCurseEnchantment.INSTANCE) && Random.Default.nextDouble() < 0.2) {
                List armors = new ArrayList();
                for (ItemStack stack : target.m_6168_()) {
                    if (stack == null) continue;
                    armors.add(stack);
                }
                if (curses.isEmpty() || armors.isEmpty()) {
                    return;
                }
                int armorsIndex = Random.Default.nextInt(0, armors.size());
                ItemStack armor = (ItemStack)armors.get(armorsIndex);
                int curseIndex = Random.Default.nextInt(0, curses.size());
                Enchantment enchantment = curses.get(curseIndex);
                if (enchantment == null) {
                    return;
                }
                Enchantment enchantment2 = enchantment;
                int level = Random.Default.nextInt(1, enchantment2.m_6586_() + 1);
                Map map = EnchantmentHelper.m_44831_((ItemStack)armor);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantments(...)");
                Map armorEnchantments = MapsKt.toMutableMap((Map)map);
                boolean isEnchantmentCompatible = EnchantmentHelper.m_44859_((Collection)armorEnchantments.keySet(), (Enchantment)enchantment2);
                if (!enchantment2.m_6081_(armor) || !isEnchantmentCompatible) {
                    return;
                }
                Integer n = level;
                armorEnchantments.put(enchantment2, n);
                EnchantmentHelper.m_44865_((Map)armorEnchantments, (ItemStack)armor);
                attacker.m_6469_(attacker.m_269291_().m_269425_(), (float)level * 4.0f);
            }
        }
    }

    @SubscribeEvent
    public final void doRottenCurseEnchantmentEvent(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getEntity() instanceof ItemEntity) {
            Entity entity = event.getEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.item.ItemEntity");
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.m_32055_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            if (EnchantmentsUtilsKt.isItemEnchanted(itemStack, RottenCurseEnchantment.INSTANCE)) {
                Object object = Config.INSTANCE.getRottenCurse().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                itemEntity.lifespan = 20 * ((Number)object).intValue();
            }
        }
    }

    @SubscribeEvent
    public final void doMagicCurseEvent(@NotNull LivingAttackEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity sourceEntity = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity == null) {
                return;
            }
            LivingEntity target = livingEntity;
            if (EnchantmentsUtilsKt.armorHasEnchantment(sourceEntity, MagicCurseEnchantment.INSTANCE)) {
                MobEffectInstance mobEffectInstance = EffectUtilsKt.getRandomDebuff(target);
                if (mobEffectInstance == null) {
                    return;
                }
                MobEffectInstance effect = mobEffectInstance;
                if (Math.random() > (double)((Number)Config.INSTANCE.getMagicCurseChance().get()).floatValue()) {
                    target.m_21195_(effect.m_19544_());
                    sourceEntity.m_7292_(effect);
                }
            }
        }
    }

    private static final boolean curses$lambda$0(Enchantment it) {
        return it.m_6589_();
    }

    static {
        IForgeRegistry iForgeRegistry = ForgeRegistries.ENCHANTMENTS;
        Intrinsics.checkNotNullExpressionValue((Object)iForgeRegistry, (String)"ENCHANTMENTS");
        curses = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)iForgeRegistry)), CurseEnchantmentHandler::curses$lambda$0));
    }
}

