/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.util;

import com.iafenvoy.jupiter.Jupiter;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.Nullable;

public class ReflectUtil {
    @Nullable
    public static Class<?> getClassUnsafely(String name) {
        try {
            return Class.forName(name);
        }
        catch (ReflectiveOperationException e) {
            Jupiter.LOGGER.error("Failed to get class", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <V> V constructUnsafely(Class<V> cls) {
        try {
            Constructor<V> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Jupiter.LOGGER.error("Failed to construct object");
            return null;
        }
    }
}

