/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.dialog.Dialog;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ListDialog<T>
extends Dialog<List<T>> {
    protected final ListBaseEntry<T> entry;
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<T>> widgets = new ArrayList<WidgetBuilder<T>>();
    private int configPerPage;

    public ListDialog(Screen parent, ListBaseEntry<T> entry) {
        super(parent, entry);
        this.entry = entry;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_130674_((String)"<"), button -> this.m_7379_()).m_252987_(10, 5, 20, 15).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_130674_((String)"+"), button -> {
            ((List)this.entry.getValue()).add(this.entry.newValue());
            this.m_232761_();
        }).m_252987_(this.f_96543_ - 60, 5, 20, 20).m_253136_());
        this.calculateMaxItems();
        this.widgets.clear();
        List values = (List)this.entry.getValue();
        for (int i = 0; i < values.size(); ++i) {
            WidgetBuilder<T> widget = WidgetBuilderManager.get(this.entry.newSingleInstance(values.get(i), i, () -> this.m_232761_()));
            this.widgets.add(widget);
            widget.addDialogElements(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
            }, i + ":", 40, 0, Math.max(10, this.f_96543_ - 70), 20);
        }
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.f_96544_ - 25) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, ((List)this.entry.getValue()).size() - this.configPerPage));
    }

    public void m_6574_(Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        List entries = (List)this.entry.getValue();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.widgets.get(i).update(true, 30 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (super.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (amount > 0.0 ? -1 : 1) * 2);
        this.updateItemPos();
        return true;
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(mouseX, mouseY, partialTicks, this.f_96543_ - 18, 25, 8, this.f_96544_ - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.m_6375_(mouseX, mouseY, mouseButton);
        if (!b) {
            this.m_7522_(null);
        }
        return b;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }
}

