/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.network.ByteBufUtil;
import com.iafenvoy.jupiter.network.ClientNetworkHelper;
import com.iafenvoy.jupiter.network.NetworkConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientConfigNetwork {
    private static final Map<ResourceLocation, Consumer<CompoundTag>> CALLBACKS = new HashMap<ResourceLocation, Consumer<CompoundTag>>();

    public static void startConfigSync(ResourceLocation id, Consumer<CompoundTag> callback) {
        CALLBACKS.put(id, callback);
        ClientNetworkHelper.sendToServer(NetworkConstants.CONFIG_REQUEST_C2S, ByteBufUtil.create().m_130085_(id));
    }

    public static void init() {
        ClientNetworkHelper.registerReceiver(NetworkConstants.CONFIG_SYNC_S2C, (client, buf) -> {
            ResourceLocation id = buf.m_130281_();
            boolean allow = buf.readBoolean();
            Consumer<CompoundTag> callback = CALLBACKS.get(id);
            if (callback == null) {
                return null;
            }
            if (allow) {
                CompoundTag data = buf.m_130260_();
                return () -> callback.accept(data);
            }
            return () -> callback.accept(null);
        });
        ClientNetworkHelper.registerReceiver(NetworkConstants.CONFIG_ERROR_S2C, (client, buf) -> () -> client.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_ACCESS_FAILURE, (Component)Component.m_237115_((String)"jupiter.toast.upload_config_error_title"), (Component)Component.m_237115_((String)"jupiter.toast.upload_config_error_content"))));
    }
}

