/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class SirenIslandStructure
extends Structure {
    public static final Codec<SirenIslandStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SirenIslandStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, SirenIslandStructure::new)).codec();

    protected SirenIslandStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation blockRotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockPos = this.m_226582_(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.m_142679_((StructurePiece)new SirenIslandPiece(0, new BoundingBox(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.SIREN_ISLAND.get();
    }

    public static class SirenIslandPiece
    extends StructurePiece {
        protected SirenIslandPiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.SIREN_ISLAND.get(), length, boundingBox);
        }

        public SirenIslandPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.SIREN_ISLAND.get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            BlockPos stonePos;
            float j;
            float i;
            int up = random.m_188503_(4) + 1;
            BlockPos center = pivot.m_6630_(up);
            int layer = 0;
            int sirens = 1 + random.m_188503_(3);
            while (!world.m_8055_(center).m_60815_() && center.m_123342_() >= world.m_141937_()) {
                ++layer;
                for (i = 0.0f; i < (float)this.getRadius(layer, up); i += 0.5f) {
                    j = 0.0f;
                    while ((double)j < Math.PI * 2 * (double)i + (double)random.m_188503_(2)) {
                        stonePos = BlockPos.m_274561_((double)Math.floor((float)center.m_123341_() + Mth.m_14031_((float)j) * i + (float)random.m_188503_(2)), (double)center.m_123342_(), (double)Math.floor((float)center.m_123343_() + Mth.m_14089_((float)j) * i + (float)random.m_188503_(2)));
                        world.m_7731_(stonePos, this.getStone(random), 3);
                        BlockPos upPos = stonePos.m_7494_();
                        if (world.m_46859_(upPos) && world.m_46859_(upPos.m_122029_()) && world.m_46859_(upPos.m_122012_()) && world.m_46859_(upPos.m_122012_().m_122029_()) && random.m_188503_(3) == 0 && sirens > 0) {
                            this.spawnSiren((ServerLevelAccessor)world, random, upPos.m_122012_().m_122029_());
                            --sirens;
                        }
                        j += 0.5f;
                    }
                }
                center = center.m_7495_();
            }
            ++layer;
            for (i = 0.0f; i < (float)this.getRadius(layer, up); i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i + (double)random.m_188503_(2)) {
                    stonePos = BlockPos.m_274561_((double)Math.floor((float)center.m_123341_() + Mth.m_14031_((float)j) * i + (float)random.m_188503_(2)), (double)center.m_123342_(), (double)Math.floor((float)center.m_123343_() + Mth.m_14089_((float)j) * i + (float)random.m_188503_(2)));
                    while (!world.m_8055_(stonePos).m_60815_() && stonePos.m_123342_() >= 0) {
                        world.m_7731_(stonePos, this.getStone(random), 3);
                        stonePos = stonePos.m_7495_();
                    }
                    j += 0.5f;
                }
            }
        }

        private int getRadius(int layer, int up) {
            int MAX_ISLAND_RADIUS = 10;
            return layer > up ? (int)((double)layer * 0.25) + up : Math.min(layer, MAX_ISLAND_RADIUS);
        }

        private BlockState getStone(RandomSource random) {
            int chance = random.m_188503_(100);
            if (chance > 90) {
                return Blocks.f_50079_.m_49966_();
            }
            if (chance > 70) {
                return Blocks.f_49994_.m_49966_();
            }
            if (chance > 45) {
                return Blocks.f_50652_.m_49966_();
            }
            return Blocks.f_50069_.m_49966_();
        }

        private void spawnSiren(ServerLevelAccessor worldIn, RandomSource rand, BlockPos position) {
            EntitySiren siren = new EntitySiren((EntityType<EntitySiren>)((EntityType)IafEntities.SIREN.get()), (Level)worldIn.m_6018_());
            siren.setSinging(true);
            siren.setHairColor(rand.m_188503_(2));
            siren.setSingingPose(rand.m_188503_(2));
            siren.m_19890_((double)position.m_123341_() + 0.5, position.m_123342_() + 1, (double)position.m_123343_() + 0.5, rand.m_188501_() * 360.0f, 0.0f);
            worldIn.m_7967_((Entity)siren);
        }
    }
}

