/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.item.block.BlockPixieHouse;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class PixieVillageStructure
extends Structure {
    public static final Codec<PixieVillageStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PixieVillageStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, PixieVillageStructure::new)).codec();

    protected PixieVillageStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation blockRotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockPos = this.m_226582_(context, blockRotation);
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.m_142679_((StructurePiece)new PixieVillagePiece(0, new BoundingBox(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.PIXIE_VILLAGE.get();
    }

    public static class PixieVillagePiece
    extends StructurePiece {
        protected PixieVillagePiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.PIXIE_VILLAGE.get(), length, boundingBox);
        }

        public PixieVillagePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.PIXIE_VILLAGE.get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            int maxRoads = (Integer)IafCommonConfig.INSTANCE.pixie.size.getValue() + random.m_188503_(5);
            BlockPos buildPosition = pivot;
            for (int placedRoads = 0; placedRoads < maxRoads; ++placedRoads) {
                int roadLength = 10 + random.m_188503_(15);
                Direction buildingDirection = Direction.m_122407_((int)random.m_188503_(3));
                for (int i = 0; i < roadLength; ++i) {
                    BlockPos buildPosition2 = buildPosition.m_5484_(buildingDirection, i);
                    if (world.m_8055_(buildPosition2 = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, buildPosition2).m_7495_()).m_60819_().m_76178_()) {
                        world.m_7731_(buildPosition2, Blocks.f_152481_.m_49966_(), 2);
                    } else {
                        world.m_7731_(buildPosition2, Blocks.f_50741_.m_49966_(), 2);
                    }
                    if (random.m_188503_(8) != 0) continue;
                    Direction houseDir = random.m_188499_() ? buildingDirection.m_122427_() : buildingDirection.m_122428_();
                    int houseColor = random.m_188503_(5);
                    BlockState houseState = switch (houseColor) {
                        case 0 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        case 1 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        case 2 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_OAK.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        case 3 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_BIRCH.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        case 4 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_SPRUCE.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        case 5 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_DARK_OAK.get()).m_49966_().m_61124_((Property)BlockPixieHouse.FACING, (Comparable)houseDir.m_122424_());
                        default -> ((Block)IafBlocks.PIXIE_HOUSE_OAK.get()).m_49966_();
                    };
                    EntityPixie pixie = (EntityPixie)((EntityType)IafEntities.PIXIE.get()).m_20615_((Level)world.m_6018_());
                    assert (pixie != null);
                    pixie.m_6518_((ServerLevelAccessor)world, world.m_6436_(buildPosition2.m_7494_()), MobSpawnType.SPAWNER, null, null);
                    pixie.m_6034_(buildPosition2.m_123341_(), buildPosition2.m_123342_() + 2, buildPosition2.m_123343_());
                    pixie.m_21530_();
                    world.m_7967_((Entity)pixie);
                    world.m_7731_(buildPosition2.m_121945_(houseDir).m_7494_(), houseState, 2);
                    if (world.m_8055_(buildPosition2.m_121945_(houseDir)).m_60815_()) continue;
                    world.m_7731_(buildPosition2.m_121945_(houseDir), Blocks.f_50546_.m_49966_(), 2);
                    world.m_7731_(buildPosition2.m_121945_(houseDir).m_7495_(), Blocks.f_50546_.m_49966_(), 2);
                }
                buildPosition = buildPosition.m_5484_(buildingDirection, random.m_188503_(roadLength));
            }
        }
    }
}

