/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSentinel;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSoldier;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexBiolight;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexConnectedResin;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexResin;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.util.RestrictWorldAccess;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MyrmexHiveStructure
extends Structure {
    public static final Codec<MyrmexHiveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MyrmexHiveStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.BOOL.fieldOf("jungle").forGetter(structure -> structure.jungle)).apply((Applicative)instance, MyrmexHiveStructure::new)).codec();
    private final boolean jungle;

    protected MyrmexHiveStructure(Structure.StructureSettings config, boolean jungle) {
        super(config);
        this.jungle = jungle;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation blockRotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockPos = this.m_226582_(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> this.addPieces((StructurePiecesBuilder)collector, blockPos, context)));
    }

    private void addPieces(StructurePiecesBuilder collector, BlockPos pos, Structure.GenerationContext context) {
        int down = Math.max(15, pos.m_123342_() - 16 + context.f_226626_().m_188503_(5));
        long seed = context.f_226626_().m_188505_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                collector.m_142679_((StructurePiece)new MyrmexHivePiece(0, new BoundingBox(pos.m_123341_() + i * 32, pos.m_123342_(), pos.m_123343_() + j * 32, pos.m_123341_() + i * 32, pos.m_123342_(), pos.m_123343_() + j * 32), new BlockPos(i * 32, 0, j * 32), down, seed, false, this.jungle));
            }
        }
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.MYRMEX_HIVE.get();
    }

    public static MyrmexHivePiece placeSmallGen(boolean isJungle, WorldGenLevel world, RandomSource random, BlockPos pos) {
        int down = Math.max(15, pos.m_123342_() - 20 + random.m_188503_(10));
        MyrmexHivePiece piece = new MyrmexHivePiece(0, new BoundingBox(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), new BlockPos(0, 0, 0), down, random.m_188505_(), true, isJungle);
        piece.hasFoodRoom = false;
        piece.hasNursery = false;
        piece.totalRooms = 0;
        piece.entrances = 0;
        piece.generateMainRoom((ServerLevelAccessor)world, random, pos);
        return piece;
    }

    public static class MyrmexHivePiece
    extends StructurePiece {
        public static final ResourceLocation MYRMEX_GOLD_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/myrmex_loot_chest");
        public static final ResourceLocation DESERT_MYRMEX_FOOD_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/myrmex_desert_food_chest");
        public static final ResourceLocation JUNGLE_MYRMEX_FOOD_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/myrmex_jungle_food_chest");
        public static final ResourceLocation MYRMEX_TRASH_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/myrmex_trash_chest");
        private static final BlockState DESERT_RESIN = ((Block)IafBlocks.MYRMEX_DESERT_RESIN.get()).m_49966_();
        private static final BlockState STICKY_DESERT_RESIN = ((Block)IafBlocks.MYRMEX_DESERT_RESIN_STICKY.get()).m_49966_();
        private static final BlockState JUNGLE_RESIN = ((Block)IafBlocks.MYRMEX_JUNGLE_RESIN.get()).m_49966_();
        private static final BlockState STICKY_JUNGLE_RESIN = ((Block)IafBlocks.MYRMEX_JUNGLE_RESIN_STICKY.get()).m_49966_();
        private final BlockPos offset;
        private final int y;
        private final long seed;
        public MyrmexHive hive;
        private int entrances = 0;
        private int totalRooms;
        private boolean hasFoodRoom;
        private boolean hasNursery;
        private final boolean small;
        private final boolean jungle;

        protected MyrmexHivePiece(int length, BoundingBox boundingBox, BlockPos offset, int y, long seed, boolean small, boolean jungle) {
            super((StructurePieceType)IafStructurePieces.MYRMEX_HIVE.get(), length, boundingBox);
            this.offset = offset;
            this.y = y;
            this.seed = seed;
            this.small = small;
            this.jungle = jungle;
        }

        public MyrmexHivePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.MYRMEX_HIVE.get(), nbt);
            this.offset = BlockPos.m_122022_((long)nbt.m_128454_("offset"));
            this.y = nbt.m_128451_("down");
            this.seed = nbt.m_128454_("seed");
            this.small = nbt.m_128471_("small");
            this.jungle = nbt.m_128471_("jungle");
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
            nbt.m_128356_("offset", this.offset.m_121878_());
            nbt.m_128405_("down", this.y);
            nbt.m_128356_("seed", this.seed);
            nbt.m_128379_("small", this.small);
            nbt.m_128379_("jungle", this.jungle);
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            LegacyRandomSource rand = new LegacyRandomSource(this.seed);
            this.hasFoodRoom = false;
            this.hasNursery = false;
            this.totalRooms = 0;
            BlockPos undergroundPos = new BlockPos(pivot.m_123341_(), this.y, pivot.m_123343_());
            this.entrances = 0;
            this.generateMainRoom(new RestrictWorldAccess((ServerLevelAccessor)world, pos -> this.isIn(chunkPos, (BlockPos)pos)), (RandomSource)rand, undergroundPos);
        }

        private boolean isIn(ChunkPos chunkPos, BlockPos blockPos) {
            return chunkPos.m_45604_() - 16 <= blockPos.m_123341_() && blockPos.m_123341_() <= chunkPos.m_45608_() + 16 && chunkPos.m_45605_() - 16 <= blockPos.m_123343_() && blockPos.m_123343_() <= chunkPos.m_45609_() + 16;
        }

        private void generateMainRoom(ServerLevelAccessor world, RandomSource rand, BlockPos position) {
            this.hive = new MyrmexHive((Level)world.m_6018_(), position, 100);
            MyrmexWorldData.addHive((Level)world.m_6018_(), this.hive);
            BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            this.generateSphere((LevelAccessor)world, rand, position, 14, 7, resin, sticky_resin);
            this.generateSphere((LevelAccessor)world, rand, position, 12, 5, Blocks.f_50016_.m_49966_());
            this.decorateSphere((LevelAccessor)world, rand, position, 12, 5, RoomType.QUEEN);
            this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.NORTH, 7).m_7495_(), 8 + rand.m_188503_(10), Direction.NORTH, 100);
            this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.SOUTH, 7).m_7495_(), 8 + rand.m_188503_(10), Direction.SOUTH, 100);
            this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.WEST, 7).m_7495_(), 8 + rand.m_188503_(10), Direction.WEST, 100);
            this.generatePath((LevelAccessor)world, rand, position.m_5484_(Direction.EAST, 7).m_7495_(), 8 + rand.m_188503_(10), Direction.EAST, 100);
            if (!this.small) {
                EntityMyrmexBase myrmex;
                int i;
                EntityMyrmexQueen queen = new EntityMyrmexQueen((EntityType<EntityMyrmexQueen>)((EntityType)IafEntities.MYRMEX_QUEEN.get()), (Level)world.m_6018_());
                BlockPos ground = MyrmexHive.getGroundedPos((LevelAccessor)world, position);
                queen.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                queen.setHive(this.hive);
                queen.setJungleVariant(this.jungle);
                queen.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)queen);
                for (i = 0; i < 4 + rand.m_188503_(3); ++i) {
                    myrmex = new EntityMyrmexWorker((EntityType<EntityMyrmexWorker>)((EntityType)IafEntities.MYRMEX_WORKER.get()), (Level)world.m_6018_());
                    myrmex.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                    myrmex.setHive(this.hive);
                    myrmex.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                    myrmex.setJungleVariant(this.jungle);
                    world.m_7967_((Entity)myrmex);
                }
                for (i = 0; i < 2 + rand.m_188503_(2); ++i) {
                    myrmex = new EntityMyrmexSoldier((EntityType<EntityMyrmexSoldier>)((EntityType)IafEntities.MYRMEX_SOLDIER.get()), (Level)world.m_6018_());
                    myrmex.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                    myrmex.setHive(this.hive);
                    myrmex.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                    myrmex.setJungleVariant(this.jungle);
                    world.m_7967_((Entity)myrmex);
                }
                for (i = 0; i < rand.m_188503_(2); ++i) {
                    myrmex = new EntityMyrmexSentinel((EntityType<? extends EntityMyrmexSentinel>)((EntityType)IafEntities.MYRMEX_SENTINEL.get()), (Level)world.m_6018_());
                    myrmex.m_6518_(world, world.m_6436_(ground), MobSpawnType.CHUNK_GENERATION, null, null);
                    myrmex.setHive(this.hive);
                    myrmex.m_19890_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 1.0, (double)ground.m_123343_() + 0.5, 0.0f, 0.0f);
                    myrmex.setJungleVariant(this.jungle);
                    world.m_7967_((Entity)myrmex);
                }
            }
        }

        private void generatePath(LevelAccessor world, RandomSource rand, BlockPos offset, int length, Direction direction, int roomChance) {
            if (roomChance == 0) {
                return;
            }
            if (this.small) {
                length /= 2;
                if (this.entrances < 1) {
                    for (int i = 0; i < length; ++i) {
                        this.generateCircle(world, rand, offset.m_5484_(direction, i), direction);
                    }
                    this.generateEntrance(world, rand, offset.m_5484_(direction, length), direction);
                } else if (this.totalRooms < 2) {
                    int i;
                    for (i = 0; i < length; ++i) {
                        this.generateCircle(world, rand, offset.m_5484_(direction, i), direction);
                    }
                    this.generateRoom(world, rand, offset.m_5484_(direction, length), 6, roomChance / 2, direction);
                    for (i = -3; i < 3; ++i) {
                        this.generateCircleAir(world, rand, offset.m_5484_(direction, i), direction);
                        this.generateCircleAir(world, rand, offset.m_5484_(direction, length + i), direction);
                    }
                    ++this.totalRooms;
                }
            } else if (rand.m_188503_(100) < roomChance) {
                if (this.entrances < 3 && rand.m_188503_(1 + this.entrances * 2) == 0 && this.hasFoodRoom && this.hasNursery && this.totalRooms > 3 || this.entrances == 0) {
                    this.generateEntrance(world, rand, offset.m_5484_(direction, 1), direction);
                } else {
                    int i;
                    for (i = 0; i < length; ++i) {
                        this.generateCircle(world, rand, offset.m_5484_(direction, i), direction);
                    }
                    for (i = -3; i < 3; ++i) {
                        this.generateCircleAir(world, rand, offset.m_5484_(direction, length + i), direction);
                    }
                    ++this.totalRooms;
                    this.generateRoom(world, rand, offset.m_5484_(direction, length), 7, roomChance / 2, direction);
                }
            }
        }

        private void generateRoom(LevelAccessor world, RandomSource rand, BlockPos position, int size, int roomChance, Direction direction) {
            BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            RoomType type = RoomType.random(rand);
            if (!this.hasFoodRoom) {
                type = RoomType.FOOD;
                this.hasFoodRoom = true;
            } else if (!this.hasNursery) {
                type = RoomType.NURSERY;
                this.hasNursery = true;
            }
            this.generateSphereRespectResin(world, rand, position, size + 2, 6, resin, sticky_resin);
            this.generateSphere(world, rand, position, size, 3, Blocks.f_50016_.m_49966_());
            this.decorateSphere(world, rand, position, size, 3, type);
            this.hive.addRoom(position, type);
            if (!this.small) {
                if (rand.m_188503_(3) == 0 && direction.m_122424_() != Direction.NORTH) {
                    this.generatePath(world, rand, position.m_5484_(Direction.NORTH, size - 2), 5 + rand.m_188503_(20), Direction.NORTH, roomChance);
                }
                if (rand.m_188503_(3) == 0 && direction.m_122424_() != Direction.SOUTH) {
                    this.generatePath(world, rand, position.m_5484_(Direction.SOUTH, size - 2), 5 + rand.m_188503_(20), Direction.SOUTH, roomChance);
                }
                if (rand.m_188503_(3) == 0 && direction.m_122424_() != Direction.WEST) {
                    this.generatePath(world, rand, position.m_5484_(Direction.WEST, size - 2), 5 + rand.m_188503_(20), Direction.WEST, roomChance);
                }
                if (rand.m_188503_(3) == 0 && direction.m_122424_() != Direction.EAST) {
                    this.generatePath(world, rand, position.m_5484_(Direction.EAST, size - 2), 5 + rand.m_188503_(20), Direction.EAST, roomChance);
                }
            }
        }

        private void generateEntrance(LevelAccessor world, RandomSource rand, BlockPos position, Direction direction) {
            BlockPos up = position.m_7494_();
            this.hive.getEntranceBottoms().put(up, direction);
            while (up.m_123342_() < world.m_5452_(this.small ? Heightmap.Types.MOTION_BLOCKING_NO_LEAVES : Heightmap.Types.WORLD_SURFACE_WG, up).m_123342_() && !world.m_8055_(up).m_204336_(BlockTags.f_13106_)) {
                this.generateCircleRespectSky(world, rand, up, direction);
                up = up.m_7494_().m_121945_(direction);
            }
            BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            this.generateSphereRespectAir(world, rand, up, 8, 6, resin, sticky_resin);
            this.generateSphere(world, rand, up.m_7494_(), 4, 4, Blocks.f_50016_.m_49966_());
            this.decorateSphere(world, rand, up.m_7494_(), 4, 3, RoomType.ENTERANCE);
            this.hive.getEntrances().put(up, direction);
            ++this.entrances;
        }

        private void generateCircle(LevelAccessor world, RandomSource rand, BlockPos position, Direction direction) {
            int z;
            int x;
            float j;
            float i;
            BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            int radius = 5;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(Mth.m_14031_((float)j) * i);
                    z = (int)Math.floor(Mth.m_14089_((float)j) * i);
                    if (direction == Direction.WEST || direction == Direction.EAST) {
                        world.m_7731_(position.m_7918_(0, x, z), rand.m_188503_(3) == 0 ? sticky_resin : resin, 2);
                    } else {
                        world.m_7731_(position.m_7918_(x, z, 0), rand.m_188503_(3) == 0 ? sticky_resin : resin, 2);
                    }
                    j += 0.5f;
                }
            }
            radius -= 2;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(Mth.m_14031_((float)j) * i * Mth.m_14036_((float)rand.m_188501_(), (float)0.5f, (float)1.0f));
                    z = (int)Math.floor(Mth.m_14089_((float)j) * i * Mth.m_14036_((float)rand.m_188501_(), (float)0.5f, (float)1.0f));
                    if (direction == Direction.WEST || direction == Direction.EAST) {
                        world.m_7731_(position.m_7918_(0, x, z), Blocks.f_50016_.m_49966_(), 2);
                    } else {
                        world.m_7731_(position.m_7918_(x, z, 0), Blocks.f_50016_.m_49966_(), 2);
                    }
                    j += 0.5f;
                }
            }
            this.decorateCircle(world, rand, position, 3, 5, direction);
        }

        private void generateCircleRespectSky(LevelAccessor world, RandomSource rand, BlockPos position, Direction direction) {
            int z;
            int x;
            float j;
            float i;
            BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
            BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
            int radius = 6;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(Mth.m_14031_((float)j) * i);
                    z = (int)Math.floor(Mth.m_14089_((float)j) * i);
                    if (direction == Direction.WEST || direction == Direction.EAST) {
                        if (!world.m_46861_(position.m_7918_(0, x, z))) {
                            world.m_7731_(position.m_7918_(0, x, z), rand.m_188503_(3) == 0 ? sticky_resin : resin, 3);
                        }
                    } else if (!world.m_46861_(position.m_7918_(x, z, 0))) {
                        world.m_7731_(position.m_7918_(x, z, 0), rand.m_188503_(3) == 0 ? sticky_resin : resin, 3);
                    }
                    j += 0.5f;
                }
            }
            radius -= 2;
            for (i = 0.0f; i < (float)radius; i += 0.5f) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    x = (int)Math.floor(Mth.m_14031_((float)j) * i * Mth.m_14036_((float)rand.m_188501_(), (float)0.5f, (float)1.0f));
                    z = (int)Math.floor(Mth.m_14089_((float)j) * i * Mth.m_14036_((float)rand.m_188501_(), (float)0.5f, (float)1.0f));
                    if (direction == Direction.WEST || direction == Direction.EAST) {
                        world.m_7731_(position.m_7918_(0, x, z), Blocks.f_50016_.m_49966_(), 3);
                    } else {
                        world.m_7731_(position.m_7918_(x, z, 0), Blocks.f_50016_.m_49966_(), 3);
                    }
                    j += 0.5f;
                }
            }
            this.decorateCircle(world, rand, position, 4, 4, direction);
        }

        private void generateCircleAir(LevelAccessor world, RandomSource rand, BlockPos position, Direction direction) {
            for (float i = 0.0f; i < 3.0f; i += 0.5f) {
                float j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    int x = (int)Math.floor(Mth.m_14031_((float)j) * i * Mth.m_14036_((float)rand.m_188501_(), (float)0.5f, (float)1.0f));
                    int z = (int)Math.floor(Mth.m_14089_((float)j) * i * Mth.m_14036_((float)rand.m_188501_(), (float)0.5f, (float)1.0f));
                    if (direction == Direction.WEST || direction == Direction.EAST) {
                        world.m_7731_(position.m_7918_(0, x, z), Blocks.f_50016_.m_49966_(), 2);
                    } else {
                        world.m_7731_(position.m_7918_(x, z, 0), Blocks.f_50016_.m_49966_(), 2);
                    }
                    j += 0.5f;
                }
            }
            this.decorateCircle(world, rand, position, 3, 5, direction);
        }

        public void generateSphere(LevelAccessor world, RandomSource rand, BlockPos position, int size, int height, BlockState fill) {
            int ySize = rand.m_188503_(2);
            int j = size + rand.m_188503_(2);
            int k = height + ySize;
            int l = size + rand.m_188503_(2);
            float f = (float)(j + k + l) * 0.333f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_7918_(-j, -k, -l), (BlockPos)position.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.m_188501_(), (float)0.75f, (float)1.0f))) || world.m_46859_(blockpos)) continue;
                world.m_7731_(blockpos, fill, 3);
            }
        }

        public void generateSphere(LevelAccessor world, RandomSource rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
            int ySize = rand.m_188503_(2);
            int j = size + rand.m_188503_(2);
            int k = height + ySize;
            int l = size + rand.m_188503_(2);
            float f = (float)(j + k + l) * 0.333f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_7918_(-j, -k, -l), (BlockPos)position.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.m_188501_(), (float)0.75f, (float)1.0f)))) continue;
                world.m_7731_(blockpos, rand.m_188503_(3) == 0 ? fill2 : fill, 2);
            }
        }

        public void generateSphereRespectResin(LevelAccessor world, RandomSource rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
            int ySize = rand.m_188503_(2);
            int j = size + rand.m_188503_(2);
            int k = height + ySize;
            int l = size + rand.m_188503_(2);
            float f = (float)(j + k + l) * 0.333f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_7918_(-j, -k, -l), (BlockPos)position.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.m_188501_(), (float)0.75f, (float)1.0f))) || world.m_46859_(blockpos) && (!world.m_46859_(blockpos) || this.hasResinUnder(blockpos, world))) continue;
                world.m_7731_(blockpos, rand.m_188503_(3) == 0 ? fill2 : fill, 2);
            }
        }

        public void generateSphereRespectAir(LevelAccessor world, RandomSource rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
            int ySize = rand.m_188503_(2);
            int j = size + rand.m_188503_(2);
            int k = height + ySize;
            int l = size + rand.m_188503_(2);
            float f = (float)(j + k + l) * 0.333f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_7918_(-j, -k, -l), (BlockPos)position.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f * Mth.m_14036_((float)rand.m_188501_(), (float)0.75f, (float)1.0f))) || world.m_46859_(blockpos)) continue;
                world.m_7731_(blockpos, rand.m_188503_(3) == 0 ? fill2 : fill, 2);
            }
        }

        private boolean hasResinUnder(BlockPos pos, LevelAccessor world) {
            BlockPos copy = pos.m_7495_();
            while (world.m_46859_(copy) && copy.m_123342_() > 1) {
                copy = copy.m_7495_();
            }
            return world.m_8055_(copy).m_60734_() instanceof BlockMyrmexResin || world.m_8055_(copy).m_60734_() instanceof BlockMyrmexConnectedResin;
        }

        private void decorateCircle(LevelAccessor world, RandomSource rand, BlockPos position, int size, int height, Direction direction) {
            int radius = size + 2;
            for (float i = 0.0f; i < (float)radius; i += 0.5f) {
                float j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i) {
                    int x = (int)Math.floor(Mth.m_14031_((float)j) * i);
                    int z = (int)Math.floor(Mth.m_14089_((float)j) * i);
                    if (direction == Direction.WEST || direction == Direction.EAST) {
                        if (world.m_46859_(position.m_7918_(0, x, z))) {
                            this.decorate(world, position.m_7918_(0, x, z), position, size, rand, RoomType.TUNNEL);
                        }
                    } else if (world.m_46859_(position.m_7918_(x, z, 0))) {
                        this.decorate(world, position.m_7918_(x, z, 0), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.m_46859_(position.m_7918_(0, x, z))) {
                        this.decorateTubers(world, position.m_7918_(0, x, z), rand, RoomType.TUNNEL);
                    }
                    j += 0.5f;
                }
            }
        }

        private void decorateSphere(LevelAccessor world, RandomSource rand, BlockPos position, int size, int height, RoomType roomType) {
            int ySize = rand.m_188503_(2);
            int j = size + rand.m_188503_(2);
            int k = height + ySize;
            int l = size + rand.m_188503_(2);
            float f = (float)(j + k + l) * 0.333f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_7918_(-j, -k, -l), (BlockPos)position.m_7918_(j, k + 1, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f))) continue;
                if (world.m_8055_(blockpos.m_7495_()).m_60815_() && world.m_46859_(blockpos)) {
                    this.decorate(world, blockpos, position, size, rand, roomType);
                }
                if (!world.m_46859_(blockpos)) continue;
                this.decorateTubers(world, blockpos, rand, roomType);
            }
        }

        private void decorate(LevelAccessor world, BlockPos blockpos, BlockPos center, int size, RandomSource random, RoomType roomType) {
            switch (roomType) {
                case FOOD: {
                    if (random.m_188503_(45) == 0 && world.m_8055_(blockpos.m_7495_()).m_60734_() instanceof BlockMyrmexResin) {
                        MyrmexHivePiece.generateSkeleton(world, blockpos, center, size, random);
                    }
                    if (random.m_188503_(13) == 0) {
                        MyrmexHivePiece.generateLeaves(world, blockpos, center, size, random, this.jungle);
                    }
                    if (random.m_188503_(12) == 0) {
                        MyrmexHivePiece.generatePumpkins(world, blockpos, center, size, random, this.jungle);
                    }
                    if (random.m_188503_(6) == 0) {
                        MyrmexHivePiece.generateMushrooms(world, blockpos, center, size, random);
                    }
                    if (random.m_188503_(12) != 0) break;
                    MyrmexHivePiece.generateCocoon(world, blockpos, random, this.jungle, this.jungle ? JUNGLE_MYRMEX_FOOD_CHEST : DESERT_MYRMEX_FOOD_CHEST);
                    break;
                }
                case SHINY: {
                    if (random.m_188503_(12) != 0) break;
                    MyrmexHivePiece.generateGold(world, blockpos, center, size, random);
                    break;
                }
                case TRASH: {
                    if (random.m_188503_(24) == 0) {
                        MyrmexHivePiece.generateTrashHeap(world, blockpos, center, size, random);
                    }
                    if (random.m_188499_()) {
                        MyrmexHivePiece.generateTrashOre(world, blockpos, center, size, random);
                    }
                    if (random.m_188503_(12) != 0) break;
                    MyrmexHivePiece.generateCocoon(world, blockpos, random, this.jungle, MYRMEX_TRASH_CHEST);
                    break;
                }
            }
        }

        private void decorateTubers(LevelAccessor world, BlockPos blockpos, RandomSource random, RoomType roomType) {
            if (world.m_8055_(blockpos.m_7494_()).m_60815_() && random.m_188503_(roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 20 : 6) == 0) {
                int tuberLength = roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 1 : (roomType == RoomType.QUEEN ? 1 + random.m_188503_(5) : 1 + random.m_188503_(3));
                for (int i = 0; i < tuberLength; ++i) {
                    if (!world.m_46859_(blockpos.m_6625_(i))) continue;
                    boolean connected = i != tuberLength - 1;
                    world.m_7731_(blockpos.m_6625_(i), this.jungle ? (BlockState)((Block)IafBlocks.MYRMEX_JUNGLE_BIOLIGHT.get()).m_49966_().m_61124_((Property)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)) : (BlockState)((Block)IafBlocks.MYRMEX_DESERT_BIOLIGHT.get()).m_49966_().m_61124_((Property)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)), 2);
                }
            }
        }

        public static void generateSkeleton(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand) {
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                Direction direction = Direction.m_122407_((int)rand.m_188503_(3));
                Direction.Axis oppositeAxis = direction.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
                int maxRibHeight = rand.m_188503_(2);
                for (int spine = 0; spine < 5 + rand.m_188503_(2) * 2; ++spine) {
                    BlockPos segment = blockpos.m_5484_(direction, spine);
                    if (origin.m_123331_((Vec3i)segment) <= (double)(radius * radius)) {
                        worldIn.m_7731_(segment, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 2);
                    }
                    if (spine % 2 == 0) continue;
                    BlockPos rightRib = segment.m_121945_(direction.m_122428_());
                    BlockPos leftRib = segment.m_121945_(direction.m_122427_());
                    if (origin.m_123331_((Vec3i)rightRib) <= (double)(radius * radius)) {
                        worldIn.m_7731_(rightRib, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                    }
                    if (origin.m_123331_((Vec3i)leftRib) <= (double)(radius * radius)) {
                        worldIn.m_7731_(leftRib, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                    }
                    for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                        if (origin.m_123331_((Vec3i)rightRib.m_6630_(ribHeight).m_121945_(direction.m_122428_())) <= (double)(radius * radius)) {
                            worldIn.m_7731_(rightRib.m_6630_(ribHeight).m_121945_(direction.m_122428_()), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
                        }
                        if (!(origin.m_123331_((Vec3i)leftRib.m_6630_(ribHeight).m_121945_(direction.m_122427_())) <= (double)(radius * radius))) continue;
                        worldIn.m_7731_(leftRib.m_6630_(ribHeight).m_121945_(direction.m_122427_()), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
                    }
                    if (origin.m_123331_((Vec3i)rightRib.m_6630_(maxRibHeight + 2)) <= (double)(radius * radius)) {
                        worldIn.m_7731_(rightRib.m_6630_(maxRibHeight + 2), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                    }
                    if (!(origin.m_123331_((Vec3i)leftRib.m_6630_(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                    worldIn.m_7731_(leftRib.m_6630_(maxRibHeight + 2), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                }
            }
        }

        public static void generateLeaves(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand, boolean jungle) {
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                BlockState leaf = (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.TRUE);
                if (jungle) {
                    leaf = (BlockState)Blocks.f_50053_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.TRUE);
                }
                int i1 = 0;
                for (int i = 0; i < 3; ++i) {
                    int j = i1 + rand.m_188503_(2);
                    int k = i1 + rand.m_188503_(2);
                    int l = i1 + rand.m_188503_(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (BlockPos pos : BlockPos.m_121990_((BlockPos)blockpos.m_7918_(-j, -k, -l), (BlockPos)blockpos.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                        if (!(pos.m_123331_((Vec3i)blockpos) <= (double)(f * f)) || !worldIn.m_46859_(pos)) continue;
                        worldIn.m_7731_(pos, leaf, 4);
                    }
                    blockpos = blockpos.m_7918_(-(i1 + 1) + rand.m_188503_(2), -rand.m_188503_(2), -(i1 + 1) + rand.m_188503_(2));
                }
            }
        }

        public static void generatePumpkins(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand, boolean jungle) {
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                worldIn.m_7731_(blockpos, jungle ? Blocks.f_50186_.m_49966_() : Blocks.f_50133_.m_49966_(), 2);
            }
        }

        public static void generateCocoon(LevelAccessor worldIn, BlockPos blockpos, RandomSource rand, boolean jungle, ResourceLocation lootTable) {
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                BlockEntity blockEntity;
                worldIn.m_7731_(blockpos, jungle ? ((Block)IafBlocks.JUNGLE_MYRMEX_COCOON.get()).m_49966_() : ((Block)IafBlocks.DESERT_MYRMEX_COCOON.get()).m_49966_(), 3);
                if (worldIn.m_7702_(blockpos) != null && (blockEntity = worldIn.m_7702_(blockpos)) instanceof RandomizableContainerBlockEntity) {
                    RandomizableContainerBlockEntity lootable = (RandomizableContainerBlockEntity)blockEntity;
                    BlockEntity tileentity1 = worldIn.m_7702_(blockpos);
                    assert (tileentity1 != null);
                    lootable.m_59626_(lootTable, rand.m_188505_());
                }
            }
        }

        public static void generateMushrooms(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand) {
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                worldIn.m_7731_(blockpos, rand.m_188499_() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_(), 2);
            }
        }

        public static void generateGold(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand) {
            BlockState gold = ((Block)IafBlocks.GOLD_PILE.get()).m_49966_();
            int choice = rand.m_188503_(2);
            if (choice == 1) {
                gold = ((Block)IafBlocks.SILVER_PILE.get()).m_49966_();
            } else if (choice == 2) {
                gold = ((Block)IafBlocks.COPPER_PILE.get()).m_49966_();
            }
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                worldIn.m_7731_(blockpos, (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_122012_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + RandomSource.m_216327_().m_188503_(7))), 3);
                worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_122019_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + RandomSource.m_216327_().m_188503_(7))), 3);
                worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_122024_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + RandomSource.m_216327_().m_188503_(7))), 3);
                worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_122029_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + RandomSource.m_216327_().m_188503_(7))), 3);
                if (rand.m_188503_(3) == 0) {
                    BlockEntity tileentity1;
                    worldIn.m_7731_(blockpos.m_7494_(), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)GenerationConstants.HORIZONTALS[RandomSource.m_216327_().m_188503_(3)]), 2);
                    if (worldIn.m_8055_(blockpos.m_7494_()).m_60734_() instanceof ChestBlock && (tileentity1 = worldIn.m_7702_(blockpos.m_7494_())) instanceof ChestBlockEntity) {
                        ChestBlockEntity chest = (ChestBlockEntity)tileentity1;
                        chest.m_59626_(MYRMEX_GOLD_CHEST, rand.m_188505_());
                    }
                }
            }
        }

        public static void generateTrashHeap(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand) {
            if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
                Block blob = switch (rand.m_188503_(3)) {
                    case 0 -> Blocks.f_50493_;
                    case 1 -> Blocks.f_49992_;
                    case 2 -> Blocks.f_50652_;
                    case 3 -> Blocks.f_49994_;
                    default -> Blocks.f_50016_;
                };
                int i1 = 0;
                for (int i = 0; i < 3; ++i) {
                    int j = i1 + rand.m_188503_(2);
                    int k = i1 + rand.m_188503_(2);
                    int l = i1 + rand.m_188503_(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (BlockPos pos : BlockPos.m_121990_((BlockPos)blockpos.m_7918_(-j, -k, -l), (BlockPos)blockpos.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                        if (!(pos.m_123331_((Vec3i)blockpos) <= (double)(f * f))) continue;
                        worldIn.m_7731_(pos, blob.m_49966_(), 4);
                    }
                    blockpos = blockpos.m_7918_(-(i1 + 1) + rand.m_188503_(2), -rand.m_188503_(2), -(i1 + 1) + rand.m_188503_(2));
                }
            }
        }

        public static void generateTrashOre(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, RandomSource rand) {
            Block current = worldIn.m_8055_(blockpos).m_60734_();
            if (origin.m_123331_((Vec3i)blockpos) <= (double)(radius * radius) && (current == Blocks.f_50493_ || current == Blocks.f_49992_ || current == Blocks.f_50652_ || current == Blocks.f_49994_)) {
                Block ore = Blocks.f_50173_;
                if (rand.m_188503_(3) == 0) {
                    Block block = ore = rand.m_188499_() ? Blocks.f_49995_ : (Block)IafBlocks.SILVER_ORE.get();
                    if (rand.m_188503_(2) == 0) {
                        ore = Blocks.f_152505_;
                    }
                } else if (rand.m_188503_(3) == 0) {
                    ore = Blocks.f_50089_;
                } else if (rand.m_188503_(2) == 0) {
                    Block block = ore = rand.m_188499_() ? Blocks.f_50264_ : (Block)IafBlocks.SAPPHIRE_ORE.get();
                    if (rand.m_188503_(2) == 0) {
                        ore = Blocks.f_152492_;
                    }
                }
                worldIn.m_7731_(blockpos, ore.m_49966_(), 2);
            }
        }
    }

    public static enum RoomType {
        DEFAULT(false),
        TUNNEL(false),
        ENTERANCE(false),
        QUEEN(false),
        FOOD(true),
        EMPTY(true),
        NURSERY(true),
        SHINY(true),
        TRASH(true);

        final boolean random;

        private RoomType(boolean random) {
            this.random = random;
        }

        public static RoomType random(RandomSource rand) {
            ArrayList<RoomType> list = new ArrayList<RoomType>();
            for (RoomType type : RoomType.values()) {
                if (!type.random) continue;
                list.add(type);
            }
            return (RoomType)((Object)list.get(rand.m_188503_(list.size())));
        }
    }
}

