/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.CommonTags;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.iceandfire.world.structure.DragonRoostStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class LightningDragonRoostStructure
extends DragonRoostStructure {
    public static final Codec<LightningDragonRoostStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LightningDragonRoostStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, LightningDragonRoostStructure::new)).codec();

    protected LightningDragonRoostStructure(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    protected DragonRoostStructure.DragonRoostPiece createPiece(BoundingBox boundingBox, boolean isMale) {
        return new LightningDragonRoostPiece(0, boundingBox, (Block)IafBlocks.COPPER_PILE.get(), isMale);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.LIGHTNING_DRAGON_ROOST.get();
    }

    public static class LightningDragonRoostPiece
    extends DragonRoostStructure.DragonRoostPiece {
        private static final ResourceLocation DRAGON_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/lightning_dragon_roost");

        protected LightningDragonRoostPiece(int length, BoundingBox boundingBox, Block treasureBlock, boolean isMale) {
            super((StructurePieceType)IafStructurePieces.LIGHTNING_DRAGON_ROOST.get(), length, boundingBox, treasureBlock, isMale);
        }

        public LightningDragonRoostPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.LIGHTNING_DRAGON_ROOST.get(), nbt);
        }

        @Override
        protected EntityType<? extends EntityDragonBase> getDragonType() {
            return (EntityType)IafEntities.LIGHTNING_DRAGON.get();
        }

        @Override
        protected ResourceLocation getRoostLootTable() {
            return DRAGON_CHEST;
        }

        @Override
        protected BlockState transform(BlockState state) {
            Block block = null;
            if (state.m_60713_(Blocks.f_50440_)) {
                block = (Block)IafBlocks.CRACKLED_GRASS.get();
            } else if (state.m_60713_(Blocks.f_152481_)) {
                block = (Block)IafBlocks.CRACKLED_DIRT_PATH.get();
            } else if (state.m_204336_(CommonTags.Blocks.GRAVEL)) {
                block = (Block)IafBlocks.CRACKLED_GRAVEL.get();
            } else if (state.m_204336_(BlockTags.f_144274_)) {
                block = (Block)IafBlocks.CRACKLED_DIRT.get();
            } else if (state.m_204336_(CommonTags.Blocks.STONE)) {
                block = (Block)IafBlocks.CRACKLED_STONE.get();
            } else if (state.m_204336_(CommonTags.Blocks.COBBLESTONE)) {
                block = (Block)IafBlocks.CRACKLED_COBBLESTONE.get();
            } else if (state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13090_)) {
                block = (Block)IafBlocks.ASH.get();
            } else if (state.m_60713_(Blocks.f_50034_) || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13073_)) {
                block = Blocks.f_50016_;
            }
            if (block != null) {
                return block.m_49966_();
            }
            return state;
        }

        @Override
        protected void handleCustomGeneration(WorldGenLevel world, BlockPos origin, RandomSource random, BlockPos position, double distance) {
            if (distance > 0.05 && random.m_188503_(800) == 0) {
                this.generateSpire((LevelAccessor)world, random, this.getSurfacePosition(world, position));
            }
            if (distance > 0.05 && random.m_188503_(1000) == 0) {
                this.generateSpike((LevelAccessor)world, random, this.getSurfacePosition(world, position), GenerationConstants.HORIZONTALS[random.m_188503_(3)]);
            }
        }

        private void generateSpike(LevelAccessor worldIn, RandomSource rand, BlockPos position, Direction direction) {
            int radius = 5;
            for (int i = 0; i < 5; ++i) {
                int j = Math.max(0, radius - (int)((float)i * 1.75f));
                int l = radius - i;
                int k = Math.max(0, radius - (int)((float)i * 1.5f));
                float f = (float)(j + l) * 0.333f + 0.5f;
                BlockPos up = position.m_7494_().m_5484_(direction, i);
                int xOrZero = direction.m_122434_() == Direction.Axis.Z ? j : 0;
                int zOrZero = direction.m_122434_() == Direction.Axis.Z ? 0 : k;
                for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)up.m_7918_(-xOrZero, -l, -zOrZero), (BlockPos)up.m_7918_(xOrZero, l, zOrZero)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                    if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f))) continue;
                    int height = Math.max(blockpos.m_123342_() - up.m_123342_(), 0);
                    if (i == 0) {
                        if (!(rand.m_188501_() < (float)height * 0.3f)) continue;
                        worldIn.m_7731_(blockpos, ((Block)IafBlocks.CRACKLED_STONE.get()).m_49966_(), 2);
                        continue;
                    }
                    worldIn.m_7731_(blockpos, ((Block)IafBlocks.CRACKLED_STONE.get()).m_49966_(), 2);
                }
            }
        }

        private void generateSpire(LevelAccessor worldIn, RandomSource rand, BlockPos position) {
            int height = 5 + rand.m_188503_(5);
            Direction bumpDirection = Direction.NORTH;
            for (int i = 0; i < height; ++i) {
                worldIn.m_7731_(position.m_6630_(i), ((Block)IafBlocks.CRACKLED_STONE.get()).m_49966_(), 2);
                if (rand.m_188499_()) {
                    bumpDirection = bumpDirection.m_122427_();
                }
                int offset = 1;
                if (i < 4) {
                    worldIn.m_7731_(position.m_6630_(i).m_122012_(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).m_49966_(), 2);
                    worldIn.m_7731_(position.m_6630_(i).m_122019_(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).m_49966_(), 2);
                    worldIn.m_7731_(position.m_6630_(i).m_122029_(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).m_49966_(), 2);
                    worldIn.m_7731_(position.m_6630_(i).m_122024_(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).m_49966_(), 2);
                    offset = 2;
                }
                if (i >= height - 2) continue;
                worldIn.m_7731_(position.m_6630_(i).m_5484_(bumpDirection, offset), ((Block)IafBlocks.CRACKLED_COBBLESTONE.get()).m_49966_(), 2);
            }
        }
    }
}

