/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class HydraCaveStructure
extends Structure {
    public static final Codec<HydraCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HydraCaveStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, HydraCaveStructure::new)).codec();

    protected HydraCaveStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation blockRotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockPos = this.m_226582_(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.m_142679_((StructurePiece)new HydraCavePiece(0, new BoundingBox(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.HYDRA_CAVE.get();
    }

    public static class HydraCavePiece
    extends StructurePiece {
        public static final ResourceLocation HYDRA_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/hydra_cave");

        protected HydraCavePiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.HYDRA_CAVE.get(), length, boundingBox);
        }

        public HydraCavePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.HYDRA_CAVE.get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            int i1 = 8;
            int i2 = i1 - 2;
            int ySize = random.m_188503_(2);
            int j = i1 + random.m_188503_(2);
            int k = 5 + ySize;
            int l = i1 + random.m_188503_(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)pivot.m_7918_(-j, -k, -l), (BlockPos)pivot.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                boolean isNotInDoorway;
                boolean doorwayX = blockpos.m_123341_() >= pivot.m_123341_() - 2 + random.m_188503_(2) && blockpos.m_123341_() <= pivot.m_123341_() + 2 + random.m_188503_(2);
                boolean doorwayZ = blockpos.m_123343_() >= pivot.m_123343_() - 2 + random.m_188503_(2) && blockpos.m_123343_() <= pivot.m_123343_() + 2 + random.m_188503_(2);
                boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.m_123342_() > pivot.m_123342_() || blockpos.m_123342_() > pivot.m_123342_() + k - (1 + random.m_188503_(2));
                if (!(blockpos.m_123331_((Vec3i)pivot) <= (double)(f * f))) continue;
                if (!(world.m_8055_(pivot).m_60734_() instanceof ChestBlock) && isNotInDoorway) {
                    world.m_7731_(blockpos, Blocks.f_50440_.m_49966_(), 3);
                    if (world.m_8055_(pivot.m_7495_()).m_60734_() == Blocks.f_50440_) {
                        world.m_7731_(blockpos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
                    }
                    if (random.m_188503_(4) == 0) {
                        world.m_7731_(blockpos.m_7494_(), Blocks.f_50034_.m_49966_(), 2);
                    }
                    if (random.m_188503_(9) == 0) {
                        world.m_9598_().m_175515_(Registries.f_256911_).m_203636_(TreeFeatures.f_195137_).ifPresent(holder -> ((ConfiguredFeature)holder.m_203334_()).m_224953_(world, chunkGenerator, random, blockpos.m_7494_()));
                    }
                }
                if (blockpos.m_123342_() == pivot.m_123342_()) {
                    world.m_7731_(blockpos, Blocks.f_50440_.m_49966_(), 3);
                }
                if (blockpos.m_123342_() > pivot.m_123342_() - 1 || world.m_8055_(blockpos).m_60815_()) continue;
                world.m_7731_(blockpos, Blocks.f_50069_.m_49966_(), 3);
            }
            ySize = random.m_188503_(2);
            j = i2 + random.m_188503_(2);
            k = 4 + ySize;
            l = i2 + random.m_188503_(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)pivot.m_7918_(-j, -k, -l), (BlockPos)pivot.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)pivot) <= (double)(f * f)) || blockpos.m_123342_() <= pivot.m_123342_() || world.m_8055_(pivot).m_60734_() instanceof ChestBlock) continue;
                world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
            }
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)pivot.m_7918_(-j, -k, -l), (BlockPos)pivot.m_7918_(j, k + 8, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)pivot) <= (double)(f * f)) || blockpos.m_123342_() != pivot.m_123342_()) continue;
                if (random.m_188503_(30) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.m_7494_())) {
                    BlockEntity blockEntity;
                    world.m_7731_(blockpos.m_6630_(1), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)GenerationConstants.HORIZONTALS[new Random().nextInt(3)]), 2);
                    if (!(world.m_8055_(blockpos.m_6630_(1)).m_60734_() instanceof ChestBlock) || !((blockEntity = world.m_7702_(blockpos.m_6630_(1))) instanceof ChestBlockEntity)) continue;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    chest.m_59626_(HYDRA_CHEST, random.m_188505_());
                    continue;
                }
                if (random.m_188503_(45) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.m_7494_())) {
                    world.m_7731_(blockpos.m_7494_(), (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(random.m_188503_(15))), 2);
                    continue;
                }
                if (random.m_188503_(35) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.m_7494_())) {
                    world.m_7731_(blockpos.m_7494_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 2);
                    for (Direction facing : Direction.values()) {
                        if (!(random.m_188501_() < 0.3f) || facing == Direction.DOWN) continue;
                        world.m_7731_(blockpos.m_7494_().m_121945_(facing), Blocks.f_50050_.m_49966_(), 2);
                    }
                    continue;
                }
                if (random.m_188503_(15) == 0 && this.isTouchingAir((LevelAccessor)world, blockpos.m_7494_())) {
                    world.m_7731_(blockpos.m_7494_(), Blocks.f_50359_.m_49966_(), 2);
                    continue;
                }
                if (random.m_188503_(15) != 0 || !this.isTouchingAir((LevelAccessor)world, blockpos.m_7494_())) continue;
                world.m_7731_(blockpos.m_7494_(), random.m_188499_() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_(), 2);
            }
            EntityHydra hydra = new EntityHydra((EntityType<EntityHydra>)((EntityType)IafEntities.HYDRA.get()), (Level)world.m_6018_());
            hydra.setVariant(random.m_188503_(3));
            hydra.m_21446_(pivot, 15);
            hydra.m_19890_((double)pivot.m_123341_() + 0.5, (double)pivot.m_123342_() + 1.5, (double)pivot.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            world.m_7967_((Entity)hydra);
        }

        private boolean isTouchingAir(LevelAccessor worldIn, BlockPos pos) {
            for (Direction direction : GenerationConstants.HORIZONTALS) {
                if (worldIn.m_46859_(pos.m_121945_(direction))) continue;
                return false;
            }
            return true;
        }
    }
}

