/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.structure.DragonCaveStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class FireDragonCaveStructure
extends DragonCaveStructure {
    public static final Codec<FireDragonCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FireDragonCaveStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, FireDragonCaveStructure::new)).codec();

    protected FireDragonCaveStructure(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    protected DragonCaveStructure.DragonCavePiece createPiece(BoundingBox boundingBox, boolean male, BlockPos offset, int y, long seed) {
        return new FireDragonCavePiece(0, boundingBox, male, offset, y, seed);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.FIRE_DRAGON_CAVE.get();
    }

    public static class FireDragonCavePiece
    extends DragonCaveStructure.DragonCavePiece {
        public static final ResourceLocation FIRE_DRAGON_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/fire_dragon_female_cave");
        public static final ResourceLocation FIRE_DRAGON_CHEST_MALE = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/fire_dragon_male_cave");

        protected FireDragonCavePiece(int length, BoundingBox boundingBox, boolean male, BlockPos offset, int y, long seed) {
            super((StructurePieceType)IafStructurePieces.FIRE_DRAGON_CAVE.get(), length, boundingBox, male, offset, y, seed);
        }

        public FireDragonCavePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.FIRE_DRAGON_CAVE.get(), nbt);
        }

        @Override
        protected TagKey<Block> getOreTag() {
            return IafBlockTags.FIRE_DRAGON_CAVE_ORES;
        }

        @Override
        protected DragonCaveStructure.WorldGenCaveStalactites getCeilingDecoration() {
            return new DragonCaveStructure.WorldGenCaveStalactites((Block)IafBlocks.CHARRED_STONE.get(), 3);
        }

        @Override
        protected BlockState getTreasurePile() {
            return ((Block)IafBlocks.GOLD_PILE.get()).m_49966_();
        }

        @Override
        protected BlockState getPaletteBlock(RandomSource random) {
            return ((Block)(random.m_188499_() ? IafBlocks.CHARRED_STONE : IafBlocks.CHARRED_COBBLESTONE).get()).m_49966_();
        }

        @Override
        protected ResourceLocation getChestTable(boolean male) {
            return male ? FIRE_DRAGON_CHEST_MALE : FIRE_DRAGON_CHEST;
        }

        @Override
        protected EntityType<? extends EntityDragonBase> getDragonType() {
            return (EntityType)IafEntities.FIRE_DRAGON.get();
        }
    }
}

