/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world;

import com.iafenvoy.iceandfire.IceAndFire;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DragonPosWorldData
extends SavedData {
    private static final String IDENTIFIER = "iceandfire_dragonPositions";
    protected final Map<UUID, BlockPos> lastDragonPositions = new HashMap<UUID, BlockPos>();
    private int tickCounter;

    public DragonPosWorldData() {
    }

    public DragonPosWorldData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public static DragonPosWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            DimensionDataStorage storage = serverWorld.m_8895_();
            DragonPosWorldData data = (DragonPosWorldData)storage.m_164861_(DragonPosWorldData::new, DragonPosWorldData::new, IDENTIFIER);
            if (data != null) {
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public void addDragon(UUID uuid, BlockPos pos) {
        this.lastDragonPositions.put(uuid, pos);
        this.m_77762_();
    }

    public void removeDragon(UUID uuid) {
        this.lastDragonPositions.remove(uuid);
        this.m_77762_();
    }

    public BlockPos getDragonPos(UUID uuid) {
        return this.lastDragonPositions.get(uuid);
    }

    public void debug() {
        IceAndFire.LOGGER.warn(this.lastDragonPositions.toString());
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void load(CompoundTag nbt) {
        this.tickCounter = nbt.m_128451_("Tick");
        ListTag nbttaglist = nbt.m_128437_("DragonMap", 10);
        this.lastDragonPositions.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
            UUID uuid = CompoundNBT.m_128342_("DragonUUID");
            BlockPos pos = new BlockPos(CompoundNBT.m_128451_("DragonPosX"), CompoundNBT.m_128451_("DragonPosY"), CompoundNBT.m_128451_("DragonPosZ"));
            this.lastDragonPositions.put(uuid, pos);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("Tick", this.tickCounter);
        ListTag nbttaglist = new ListTag();
        for (Map.Entry<UUID, BlockPos> pair : this.lastDragonPositions.entrySet()) {
            CompoundTag CompoundNBT = new CompoundTag();
            CompoundNBT.m_128362_("DragonUUID", pair.getKey());
            CompoundNBT.m_128405_("DragonPosX", pair.getValue().m_123341_());
            CompoundNBT.m_128405_("DragonPosY", pair.getValue().m_123342_());
            CompoundNBT.m_128405_("DragonPosZ", pair.getValue().m_123343_());
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.m_128365_("DragonMap", (Tag)nbttaglist);
        return compound;
    }
}

