/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui.bestiary;

import com.google.common.collect.Maps;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.data.BestiaryPages;
import com.iafenvoy.iceandfire.data.DragonArmor;
import com.iafenvoy.iceandfire.data.SeaSerpent;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.screen.gui.bestiary.ChangePageButton;
import com.iafenvoy.iceandfire.screen.gui.bestiary.IndexPageButton;
import com.iafenvoy.iceandfire.screen.handler.BestiaryScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.io.IOUtils;

public class BestiaryScreen
extends AbstractContainerScreen<BestiaryScreenHandler> {
    protected static final int X = 390;
    protected static final int Y = 245;
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/bestiary/bestiary.png");
    private static final ResourceLocation DRAWINGS_0 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/bestiary/drawings_0.png");
    private static final ResourceLocation DRAWINGS_1 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/bestiary/drawings_1.png");
    private static final Map<String, ResourceLocation> PICTURE_LOCATION_CACHE = Maps.newHashMap();
    public final List<BestiaryPages> allPageTypes = new ArrayList<BestiaryPages>();
    public final List<IndexPageButton> indexButtons = new ArrayList<IndexPageButton>();
    protected final ItemStack book;
    public BestiaryPages pageType;
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int indexPages;
    public int indexPagesTotal = 1;
    protected boolean index;

    public BestiaryScreen(BestiaryScreenHandler container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.book = container.getBook();
        if (!this.book.m_41619_() && this.book.m_41720_() != null && this.book.m_41720_() == IafItems.BESTIARY.get() && this.book.m_41783_() != null) {
            Set<BestiaryPages> pages = BestiaryPages.containedPages(this.book.m_41783_().m_128437_("Pages", 8).stream().map(Tag::m_7916_).collect(Collectors.toList()));
            this.allPageTypes.addAll(pages);
            this.allPageTypes.sort(Comparator.comparingInt(BestiaryPages::getId));
            this.indexPagesTotal = (int)Math.ceil((double)pages.size() / 10.0);
        }
        this.index = true;
    }

    private static Item getItemByRegistryName(String registryName) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)registryName));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.indexButtons.clear();
        int centerX = (this.f_96543_ - 390) / 2;
        int centerY = (this.f_96544_ - 245) / 2;
        this.previousPage = new ChangePageButton(centerX + 15, centerY + 215, false, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages > 0 : this.pageType != null) {
                if (this.index) {
                    --this.indexPages;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)IafSounds.BESTIARY_PAGE.get()), (float)1.0f));
                } else if (this.bookPages > 0) {
                    --this.bookPages;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)IafSounds.BESTIARY_PAGE.get()), (float)1.0f));
                } else {
                    this.index = true;
                }
            }
        });
        this.m_142416_((GuiEventListener)this.previousPage);
        this.nextPage = new ChangePageButton(centerX + 357, centerY + 215, true, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages < this.indexPagesTotal - 1 : this.pageType != null && this.bookPages < this.pageType.getPagesCount()) {
                if (this.index) {
                    ++this.indexPages;
                } else {
                    ++this.bookPages;
                }
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)IafSounds.BESTIARY_PAGE.get()), (float)1.0f));
            }
        });
        this.m_142416_((GuiEventListener)this.nextPage);
        if (!this.allPageTypes.isEmpty()) {
            for (int i = 0; i < this.allPageTypes.size(); ++i) {
                int xIndex = i % -2;
                int yIndex = i % 10;
                int id = 2 + i;
                IndexPageButton button = new IndexPageButton(centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), (Component)Component.m_237115_((String)("bestiary." + this.allPageTypes.get(i).getName().toLowerCase(Locale.ROOT))), widget -> {
                    if (this.indexButtons.get(id - 2) != null && this.allPageTypes.get(id - 2) != null) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)IafSounds.BESTIARY_PAGE.get()), (float)1.0f));
                        this.index = false;
                        this.bookPages = 0;
                        this.pageType = this.allPageTypes.get(id - 2);
                    }
                });
                this.indexButtons.add(button);
                this.m_142416_((GuiEventListener)button);
            }
        }
    }

    public void m_88315_(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ms);
        for (Renderable widget2 : this.f_169369_) {
            if (!(widget2 instanceof IndexPageButton)) continue;
            IndexPageButton button = (IndexPageButton)widget2;
            button.f_93623_ = this.index;
            button.f_93624_ = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).f_93623_ = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int cornerX = (this.f_96543_ - 390) / 2;
        int cornerY = (this.f_96544_ - 245) / 2;
        ms.m_280163_(TEXTURE, cornerX, cornerY, 0.0f, 0.0f, 390, 245, 390, 390);
        RenderSystem.disableDepthTest();
        super.m_88315_(ms, mouseX, mouseY, partialTicks);
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_252880_((float)cornerX, (float)cornerY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int centerX = (this.f_96543_ - 390) / 2;
        int centerY = (this.f_96544_ - 245) / 2;
        if (!this.index) {
            this.drawPerPage(ms, this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            ms.m_280056_(this.f_96547_, String.valueOf(pageLeft), 97, 213, 0x303030, false);
            ms.m_280056_(this.f_96547_, String.valueOf(pageRight), 292, 213, 0x303030, false);
        }
        ms.m_280168_().m_85849_();
        this.f_169369_.forEach(widget -> widget.m_88315_(ms, mouseX, mouseY, partialTicks));
        RenderSystem.enableDepthTest();
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
    }

    public void drawPerPage(GuiGraphics ms, int bookPages) {
        this.imageFromTxt(ms);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        if (this.pageType.equals(BestiaryPages.INTRODUCTION)) {
            if (bookPages == 1) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafBlocks.SAPPHIRE_ORE.get()), 30, 20, 2.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SAPPHIRE_GEM.get()), 40, 55, 2.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                boolean drawGold = player.f_19797_ % 20 < 10;
                this.drawItemStack(ms, new ItemStack((ItemLike)(drawGold ? Items.f_42587_ : (ItemLike)IafItems.SILVER_NUGGET.get())), 144, 34, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)(drawGold ? Items.f_42587_ : (ItemLike)IafItems.SILVER_NUGGET.get())), 161, 34, 1.5f);
                this.drawItemStack(ms, new ItemStack(drawGold ? (ItemLike)IafBlocks.GOLD_PILE.get() : (ItemLike)IafBlocks.SILVER_PILE.get()), 151, 7, 2.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 90, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50705_), 161, 124, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50705_), 161, 107, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MANUSCRIPT.get()), 161, 91, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafBlocks.LECTERN.get()), 151, 78, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.TAMED_DRAGONS)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 90, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42500_), 145, 124, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42485_), 145, 107, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42500_), 145, 91, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42485_), 161, 124, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42500_), 161, 107, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42485_), 161, 91, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42500_), 177, 124, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42485_), 177, 107, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42500_), 177, 91, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_MEAL.get()), 151, 78, 2.0f);
            }
            if (bookPages == 1) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_SKULL_FIRE.get()), 161, 17, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 161, 32, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_STAFF.get()), 151, 10, 2.0f);
            }
            if (bookPages == 2) {
                ms.m_280168_().m_85836_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafBlocks.FIRE_LILY.get()), 5, 14, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafBlocks.FROST_LILY.get()), 17, 14, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafBlocks.LIGHTNING_LILY.get()), 30, 14, 3.75f);
                ms.m_280168_().m_85849_();
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                int type = player.f_19797_ / 20 % 3;
                this.drawItemStack(ms, new ItemStack(type == 0 ? (ItemLike)IafBlocks.FIRE_LILY.get() : (type == 1 ? (ItemLike)IafBlocks.FROST_LILY.get() : (ItemLike)IafBlocks.LIGHTNING_LILY.get())), 161, 17, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42399_), 161, 32, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)(type == 0 ? Items.f_42585_ : (type == 1 ? Items.f_42696_ : Items.f_42730_))), 177, 17, 1.5f);
                this.drawItemStack(ms, new ItemStack(type == 0 ? (ItemLike)IafItems.FIRE_STEW.get() : (type == 1 ? (ItemLike)IafItems.FROST_STEW.get() : (ItemLike)IafItems.LIGHTNING_STEW.get())), 151, 10, 2.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 65, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 144, 97, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 180, 110, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 180, 92, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 198, 92, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 198, 74, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_HORN.get()), 151, 60, 2.0f);
            }
            if (bookPages == 3) {
                int j = 18;
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONARMOR_IRON_HEAD.get(), 1), j += 16, 60, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONARMOR_IRON_NECK.get(), 1), j += 16, 60, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONARMOR_IRON_BODY.get(), 1), j += 16, 60, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONARMOR_IRON_TAIL.get(), 1), j + 16, 60, 1.5f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 10, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 160, 12, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 180, 31, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42416_), 199, 50, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_FLUTE.get()), 151, 18, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.MATERIALS)) {
            int j;
            if (bookPages == 0) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONSCALES_RED.get()), 18, 14, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BONE.get()), 70, 8, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.WITHERBONE.get()), 112, 65, 2.5f);
                j = 18;
                this.drawItemStack(ms, new ItemStack((ItemLike)DragonArmor.RED.helmet.get()), j += 16, 110, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)DragonArmor.RED.chestplate.get()), j += 16, 110, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)DragonArmor.RED.leggings.get()), j += 16, 110, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)DragonArmor.RED.boots.get()), j + 16, 110, 1.5f);
            }
            if (bookPages == 1) {
                j = 1;
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONBONE_SWORD.get()), j += 16, 14, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONBONE_PICKAXE.get()), j += 16, 14, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONBONE_AXE.get()), j += 16, 14, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONBONE_SHOVEL.get()), j += 16, 14, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONBONE_HOE.get()), j += 16, 14, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_BOW.get()), j + 16, 14, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.FIRE_DRAGON_FLESH.get()), 18, 24, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.FIRE_DRAGON_HEART.get()), 70, 14, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGON_SKULL_FIRE.get()), 70, 39, 3.75f);
            }
            if (bookPages == 2) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.FIRE_DRAGON_BLOOD.get()), 18, 20, 3.75f);
            }
        } else if (this.pageType.equals(BestiaryPages.ALCHEMY)) {
            if (bookPages == 0) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.FIRE_DRAGON_BLOOD.get()), 2, 24, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.ICE_DRAGON_BLOOD.get()), 18, 24, 3.75f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.LIGHTNING_DRAGON_BLOOD.get()), 34, 24, 3.75f);
                int type = player.f_19797_ / 20 % 3;
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DRAGONBONE_SWORD.get()), 161, 17, 1.5f);
                this.drawItemStack(ms, new ItemStack(type == 0 ? (ItemLike)IafItems.FIRE_DRAGON_BLOOD.get() : (type == 1 ? (ItemLike)IafItems.ICE_DRAGON_BLOOD.get() : (ItemLike)IafItems.LIGHTNING_DRAGON_BLOOD.get())), 161, 32, 1.5f);
                this.drawItemStack(ms, new ItemStack(type == 0 ? (ItemLike)IafItems.DRAGONBONE_SWORD_FIRE.get() : (type == 1 ? (ItemLike)IafItems.DRAGONBONE_SWORD_ICE.get() : (ItemLike)IafItems.DRAGONBONE_SWORD_LIGHTNING.get())), 151, 10, 2.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
            }
        } else if (this.pageType.equals(BestiaryPages.HIPPOGRYPH)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(0.8f, 0.8f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 29, 150, 303, 151, 61, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 91, 150, 364, 151, 61, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 151, 150, 425, 151, 61, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 29, 190, 303, 187, 61, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 91, 190, 364, 187, 61, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 151, 190, 425, 187, 61, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 90, 230, 425, 223, 61, 35, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42648_), 70, 20, 3.75f);
            }
            if (bookPages == 1) {
                int drawType;
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 16, 24, 3.75f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 10, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42402_), 160, 31, 1.35f);
                int n = player.f_19797_ % 60 > 40 ? 2 : (drawType = player.f_19797_ % 60 > 20 ? 1 : 0);
                this.drawItemStack(ms, new ItemStack((ItemLike)(drawType == 0 ? Items.f_42651_ : (drawType == 1 ? Items.f_42652_ : Items.f_42653_))), 180, 31, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42402_), 199, 31, 1.35f);
                this.drawItemStack(ms, new ItemStack(drawType == 0 ? (ItemLike)IafItems.IRON_HIPPOGRYPH_ARMOR.get() : (drawType == 1 ? (ItemLike)IafItems.GOLD_HIPPOGRYPH_ARMOR.get() : (ItemLike)IafItems.DIAMOND_HIPPOGRYPH_ARMOR.get())), 151, 18, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42699_), 70, 23, 3.75f);
            }
        } else if (this.pageType.equals(BestiaryPages.GORGON)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 10, 89, 473, 117, 19, 34, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 50, 78, 399, 106, 28, 45, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 100, 89, 455, 117, 18, 34, 512.0f);
                ms.m_280168_().m_85849_();
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 70, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42401_), 160, 97, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42454_), 180, 97, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42401_), 199, 97, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.BLINDFOLD.get()), 171, 65, 2.0f);
            }
            if (bookPages == 1) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.GORGON_HEAD.get()), 16, 12, 3.75f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.7f, 1.7f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 37, 95, 473, 117, 19, 34, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 60, 95, 455, 117, 18, 34, 512.0f);
                ms.m_280168_().m_85849_();
            }
        } else if (this.pageType.equals(BestiaryPages.PIXIE)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                this.drawImage(ms, DRAWINGS_0, 20, 60, 371, 258, 47, 35, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 42, 95, 416, 258, 45, 35, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 67, 60, 462, 258, 47, 35, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 88, 95, 370, 293, 47, 35, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 110, 60, 416, 293, 47, 35, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.PIXIE_DUST.get()), 70, 10, 3.75f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(0.9f, 0.9f, 1.0f);
                ms.m_280168_().m_252880_(20.0f, 24.0f, 0.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 150, 100, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 160, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 199, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50705_), 180, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 160, 131, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 199, 131, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 180, 150, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 160, 150, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50058_), 199, 150, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafBlocks.JAR_EMPTY.get()), 171, 85, 2.0f);
                ms.m_280168_().m_85849_();
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.AMBROSIA.get()), 14, 22, 3.75f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 100, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.PIXIE_DUST.get()), 180, 131, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42399_), 180, 150, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.AMBROSIA.get()), 171, 85, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.CYCLOPS)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
                this.drawImage(ms, DRAWINGS_0, 185, 8, 399, 328, 24, 63, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
                this.drawImage(ms, DRAWINGS_0, 50, 35, 423, 328, 24, 63, 512.0f);
                ms.m_280168_().m_85849_();
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 50, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42407_), 180, 76, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 160, 76, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 199, 76, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 160, 57, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 180, 57, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 199, 57, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SHEEP_HELMET.get()), 165, 45, 2.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 95, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42408_), 180, 126, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 160, 126, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 199, 126, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 160, 107, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 199, 107, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 160, 145, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 180, 145, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 199, 145, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SHEEP_CHESTPLATE.get()), 165, 95, 2.0f);
            }
            if (bookPages == 2) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
                this.drawImage(ms, DRAWINGS_0, 185, 30, 447, 328, 24, 63, 512.0f);
                ms.m_280168_().m_85849_();
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 13, 24, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42462_), 34, 46, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 14, 46, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 53, 46, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 14, 27, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 34, 27, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 53, 27, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 14, 65, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 53, 65, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SHEEP_LEGGINGS.get()), 64, 27, 2.0f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 13, 84, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42463_), 34, 94, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 14, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 53, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 14, 94, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50041_), 53, 94, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SHEEP_BOOTS.get()), 64, 73, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.SIREN)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
                this.drawImage(ms, DRAWINGS_1, 190, 25, 0, 0, 25, 42, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 220, 15, 25, 0, 25, 42, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 255, 25, 50, 0, 25, 42, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 190, 135, 0, 42, 26, 28, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 220, 125, 26, 42, 26, 28, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 255, 135, 52, 42, 26, 28, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.EARPLUGS.get()), 18, 40, 3.75f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 160, 0, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50251_), 180, 20, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Blocks.f_50251_), 215, 20, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.EARPLUGS.get()), 170, 10, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SHINY_SCALES.get()), 123, 75, 2.25f);
            }
        } else if (this.pageType.equals(BestiaryPages.HIPPOCAMPUS)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                this.drawImage(ms, DRAWINGS_1, 210, 25, 0, 70, 57, 49, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 265, 25, 57, 70, 57, 49, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 320, 25, 0, 119, 57, 49, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 210, 80, 57, 119, 57, 49, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 265, 80, 0, 168, 57, 49, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 320, 80, 57, 168, 57, 49, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_41910_), 37, 33, 2.25f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42696_), 37, 73, 2.25f);
            }
            if (bookPages == 2) {
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 35, 25, 2.25f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SHINY_SCALES.get()), 35, 75, 2.25f);
            }
        } else if (this.pageType.equals(BestiaryPages.DEATHWORM)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                this.drawImage(ms, DRAWINGS_1, 230, 25, 0, 217, 133, 16, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 230, 50, 0, 233, 133, 16, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 230, 75, 0, 249, 133, 16, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                ms.m_280168_().m_85836_();
                this.drawImage(ms, DRAWINGS_1, 25, 95, 0, 265, 148, 44, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 250, 5, 0, 309, 81, 162, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 2) {
                int drawType = player.f_19797_ % 60 > 40 ? 2 : (player.f_19797_ % 60 > 20 ? 1 : 0);
                Item chitin = switch (drawType) {
                    case 2 -> (Item)IafItems.DEATH_WORM_CHITIN_RED.get();
                    case 1 -> (Item)IafItems.DEATH_WORM_CHITIN_WHITE.get();
                    default -> (Item)IafItems.DEATH_WORM_CHITIN_YELLOW.get();
                };
                this.drawItemStack(ms, new ItemStack((ItemLike)chitin, 1), 17, 30, 3.75f);
                this.drawItemStack(ms, new ItemStack(drawType == 2 ? (ItemLike)IafItems.DEATHWORM_RED_HELMET.get() : (drawType == 1 ? (ItemLike)IafItems.DEATHWORM_WHITE_HELMET.get() : (ItemLike)IafItems.DEATHWORM_YELLOW_HELMET.get())), 92, 8, 2.25f);
                this.drawItemStack(ms, new ItemStack(drawType == 2 ? (ItemLike)IafItems.DEATHWORM_RED_CHESTPLATE.get() : (drawType == 1 ? (ItemLike)IafItems.DEATHWORM_WHITE_CHESTPLATE.get() : (ItemLike)IafItems.DEATHWORM_YELLOW_CHESTPLATE.get())), 112, 8, 2.25f);
                this.drawItemStack(ms, new ItemStack(drawType == 2 ? (ItemLike)IafItems.DEATHWORM_RED_LEGGINGS.get() : (drawType == 1 ? (ItemLike)IafItems.DEATHWORM_WHITE_LEGGINGS.get() : (ItemLike)IafItems.DEATHWORM_YELLOW_LEGGINGS.get())), 132, 8, 2.25f);
                this.drawItemStack(ms, new ItemStack(drawType == 2 ? (ItemLike)IafItems.DEATHWORM_RED_BOOTS.get() : (drawType == 1 ? (ItemLike)IafItems.DEATHWORM_WHITE_BOOTS.get() : (ItemLike)IafItems.DEATHWORM_YELLOW_BOOTS.get())), 152, 8, 2.25f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DEATHWORM_EGG.get()), 125, 42, 2.25f);
            }
            if (bookPages == 3) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.DEATHWORM_EGG_GIGANTIC.get(), 1), 125, 4, 2.25f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42523_), 115, 55, 2.25f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42523_), 135, 55, 2.25f);
            }
        } else if (this.pageType.equals(BestiaryPages.COCKATRICE)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_1, 155, 10, 114, 0, 88, 36, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 155, 45, 114, 36, 88, 36, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 18, 10, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42401_), 20, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42454_), 40, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42401_), 59, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.BLINDFOLD.get()), 60, 18, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.WITHERBONE.get()), 30, 58, 2.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.ROTTEN_EGG.get()), 109, 18, 2.5f);
            }
        } else if (this.pageType.equals(BestiaryPages.STYMPHALIAN_BIRD)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_1, 34, 46, 114, 72, 59, 37, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 155, 35, 114, 109, 67, 35, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.STYMPHALIAN_BIRD_FEATHER.get()), 109, 60, 2.5f);
            }
            if (bookPages == 1) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 18, 10, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42484_), 40, 13, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 40, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.STYMPHALIAN_BIRD_FEATHER.get()), 40, 49, 1.35f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.STYMPHALIAN_ARROW.get()), 60, 18, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.TROLL)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_1, 15, 60, 156, 211, 25, 58, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 50, 55, 181, 211, 25, 58, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 85, 60, 206, 211, 25, 58, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 155, 22, 114, 145, 24, 66, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 190, 19, 188, 142, 47, 69, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                int i = player.f_19797_ % (TrollType.BuiltinWeapon.values().length * 20) / 20;
                this.drawItemStack(ms, new ItemStack((ItemLike)TrollType.BuiltinWeapon.values()[i].getItem()), 30, 7, 2.5f);
                int j = player.f_19797_ % (TrollType.values().size() * 20) / 20;
                this.drawItemStack(ms, new ItemStack((ItemLike)TrollType.values().get((int)j).leather.get()), 100, 30, 2.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.TROLL_TUSK.get()), 120, 30, 2.5f);
            }
            if (bookPages == 2) {
                int j = player.f_19797_ % (TrollType.values().size() * 20) / 20;
                this.drawItemStack(ms, new ItemStack((ItemLike)TrollType.values().get((int)j).helmet.get()), 27, 15, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)TrollType.values().get((int)j).chestplate.get()), 47, 15, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)TrollType.values().get((int)j).leggings.get()), 67, 15, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)TrollType.values().get((int)j).boots.get()), 87, 15, 1.5f);
            }
        } else if (this.pageType.equals(BestiaryPages.MYRMEX)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.51f, 1.51f, 1.0f);
                this.drawImage(ms, DRAWINGS_1, 137, 10, 202, 16, 57, 21, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 195, 10, 278, 16, 57, 21, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.51f, 1.51f, 1.0f);
                this.drawImage(ms, DRAWINGS_1, 7, 17, 202, 37, 59, 21, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 65, 17, 278, 37, 59, 21, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 7, 77, 202, 58, 59, 21, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 65, 77, 278, 58, 59, 21, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 145, 20, 278, 103, 43, 45, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 195, 20, 321, 103, 43, 45, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 2) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.51f, 1.51f, 1.0f);
                this.drawImage(ms, DRAWINGS_1, 25, 13, 202, 79, 76, 24, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 25, 40, 278, 79, 76, 24, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_DESERT_CHITIN.get()), 125, 43, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_JUNGLE_CHITIN.get()), 155, 43, 2.0f);
                int i = 133;
                boolean jungle = player.f_19797_ % 60 > 30;
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_SHOVEL.get() : (ItemLike)IafItems.MYRMEX_DESERT_SHOVEL.get()), i += 16, 100, 1.51f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_PICKAXE.get() : (ItemLike)IafItems.MYRMEX_DESERT_PICKAXE.get()), i += 16, 100, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_AXE.get() : (ItemLike)IafItems.MYRMEX_DESERT_AXE.get()), i += 16, 100, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_SWORD.get() : (ItemLike)IafItems.MYRMEX_DESERT_SWORD.get()), i += 16, 100, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_SWORD_VENOM.get() : (ItemLike)IafItems.MYRMEX_DESERT_SWORD_VENOM.get()), i += 16, 100, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_HOE.get() : (ItemLike)IafItems.MYRMEX_DESERT_HOE.get()), i + 16, 100, 1.5f);
                int j = 148;
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_HELMET.get() : (ItemLike)IafItems.MYRMEX_DESERT_HELMET.get()), j += 16, 115, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_CHESTPLATE.get() : (ItemLike)IafItems.MYRMEX_DESERT_CHESTPLATE.get()), j += 16, 115, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_LEGGINGS.get() : (ItemLike)IafItems.MYRMEX_DESERT_LEGGINGS.get()), j += 16, 115, 1.5f);
                this.drawItemStack(ms, new ItemStack(jungle ? (ItemLike)IafItems.MYRMEX_JUNGLE_BOOTS.get() : (ItemLike)IafItems.MYRMEX_DESERT_BOOTS.get()), j + 16, 115, 1.5f);
            }
            if (bookPages == 3) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_STINGER.get()), 35, 22, 2.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_DESERT_RESIN.get()), 25, 64, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_JUNGLE_RESIN.get()), 55, 64, 2.0f);
            }
            if (bookPages == 4) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_DESERT_STAFF.get()), 25, 73, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_JUNGLE_STAFF.get()), 55, 73, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_DESERT_EGG.get()), 125, 90, 2.0f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.MYRMEX_JUNGLE_EGG.get()), 155, 90, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.AMPHITHERE)) {
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
                this.drawImage(ms, DRAWINGS_1, 70, 97, 257, 163, 136, 93, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 270, 50, 148, 267, 120, 51, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 380, 50, 148, 318, 120, 51, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 270, 100, 148, 369, 120, 51, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 380, 100, 148, 420, 120, 51, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 330, 150, 268, 267, 120, 51, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 2) {
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.AMPHITHERE_FEATHER.get()), 30, 20, 2.5f);
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 19, 71, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42484_), 36, 73, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 36, 89, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.AMPHITHERE_FEATHER.get()), 36, 106, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.AMPHITHERE_ARROW.get()), 60, 65, 2.0f);
            }
        } else if (this.pageType.equals(BestiaryPages.SEA_SERPENT)) {
            int j;
            if (bookPages == 0) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
                this.drawImage(ms, DRAWINGS_1, 290, 5, 422, 0, 90, 64, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 380, 5, 422, 64, 90, 64, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 290, 70, 422, 128, 90, 64, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 380, 70, 422, 192, 90, 64, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 290, 140, 422, 256, 90, 64, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 380, 140, 422, 320, 90, 64, 512.0f);
                this.drawImage(ms, DRAWINGS_1, 345, 210, 422, 384, 90, 64, 512.0f);
                ms.m_280168_().m_85849_();
            }
            if (bookPages == 1) {
                this.drawImage(ms, DRAWINGS_1, 60, 90, 337, 0, 70, 83, 512.0f);
                j = player.f_19797_ % (SeaSerpent.values().size() * 20) / 20;
                this.drawItemStack(ms, new ItemStack((ItemLike)SeaSerpent.values().get((int)j).scale.get()), 130, 40, 2.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SERPENT_FANG.get()), 90, 40, 2.5f);
            }
            if (bookPages == 2) {
                ms.m_280168_().m_85836_();
                ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 19, 31, 389, 1, 50, 50, 512.0f);
                ms.m_280168_().m_85849_();
                j = player.f_19797_ % (SeaSerpent.values().size() * 20) / 20;
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SERPENT_FANG.get()), 36, 32, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)Items.f_42398_), 36, 48, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)SeaSerpent.values().get((int)j).scale.get()), 36, 66, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)SeaSerpent.values().get((int)j).helmet.get()), 34, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)SeaSerpent.values().get((int)j).chestplate.get()), 50, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)SeaSerpent.values().get((int)j).leggings.get()), 66, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)SeaSerpent.values().get((int)j).boots.get()), 82, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((ItemLike)IafItems.SEA_SERPENT_ARROW.get()), 60, 33, 2.0f);
            }
        }
        this.writeFromTxt(ms);
    }

    public void imageFromTxt(GuiGraphics ms) {
        String fileName = this.pageType.getName() + "_" + this.bookPages + ".txt";
        String languageName = Minecraft.m_91087_().f_91066_.f_92075_.toLowerCase(Locale.ROOT);
        ResourceLocation fileLoc = ResourceLocation.m_214293_((String)"iceandfire", (String)("lang/bestiary/" + languageName + "_0/" + fileName));
        ResourceLocation backupLoc = ResourceLocation.m_214293_((String)"iceandfire", (String)("lang/bestiary/en_us_0/" + fileName));
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(fileLoc);
        if (resource.isEmpty()) {
            resource = Minecraft.m_91087_().m_91098_().m_213713_(backupLoc);
        }
        try {
            if (resource.isPresent()) {
                List lines = IOUtils.readLines((InputStream)((Resource)resource.get()).m_215507_(), (Charset)StandardCharsets.UTF_8);
                int zLevelAdd = 0;
                for (String line : lines) {
                    String[] split;
                    if (((line = line.trim()).contains("<") || line.contains(">")) && line.contains("<image>")) {
                        line = line.substring(8, line.length() - 1);
                        split = line.split(" ");
                        ResourceLocation id = ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/gui/bestiary/" + split[0]));
                        assert (id != null);
                        ResourceLocation resourcelocation = PICTURE_LOCATION_CACHE.computeIfAbsent(id.toString(), k -> id);
                        ms.m_280168_().m_85836_();
                        this.drawImage(ms, resourcelocation, Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Float.parseFloat(split[7]) * 512.0f);
                        ms.m_280168_().m_85849_();
                    }
                    if (line.contains("<item>")) {
                        line = line.substring(7, line.length() - 1);
                        split = line.split(" ");
                        RenderSystem.enableDepthTest();
                        this.drawItemStack(ms, new ItemStack((ItemLike)BestiaryScreen.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f);
                    }
                    if (line.contains("<block>")) {
                        line = line.substring(8, line.length() - 1);
                        split = line.split(" ");
                        RenderSystem.enableDepthTest();
                        this.drawBlockStack(ms, new ItemStack((ItemLike)BestiaryScreen.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f, ++zLevelAdd);
                    }
                    if (!line.contains("<recipe>")) continue;
                    line = line.substring(9, line.length() - 1);
                    split = line.split(" ");
                    RenderSystem.enableDepthTest();
                    float scale = Float.parseFloat(split[split.length - 1]);
                    int x = Integer.parseInt(split[split.length - 3]);
                    int y = Integer.parseInt(split[split.length - 2]);
                    ItemStack result = new ItemStack((ItemLike)BestiaryScreen.getItemByRegistryName(split[0]), 1);
                    ItemStack[] ingredients = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
                    int j = 8;
                    for (int i = split.length - 5; i >= 2; i -= 2) {
                        ingredients[j] = new ItemStack((ItemLike)BestiaryScreen.getItemByRegistryName(split[i]), 1);
                        --j;
                    }
                    RenderSystem.enableDepthTest();
                    ms.m_280168_().m_85836_();
                    this.drawRecipe(ms, result, ingredients, x, y, scale);
                    ms.m_280168_().m_85849_();
                }
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error((Object)e);
        }
    }

    private void drawRecipe(GuiGraphics ms, ItemStack result, ItemStack[] ingredients, int x, int y, float scale) {
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85837_((double)x, (double)y, 0.0);
        ms.m_280168_().m_85841_(scale, scale, scale);
        ms.m_280168_().m_85849_();
        for (int i = 0; i < 9; ++i) {
            ms.m_280168_().m_85836_();
            ms.m_280168_().m_85837_(44.0, 20.0, 32.0);
            ms.m_280168_().m_85837_((double)((float)x + (float)(i % 3 * 22) * scale), (double)y + Math.floor((double)i / 3.0) * 22.0 * (double)scale, 0.0);
            ms.m_280480_(ingredients[i], 0, 0);
            ms.m_280168_().m_85849_();
        }
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85837_(40.0, 20.0, 32.0);
        float finScale = scale * 1.5f;
        ms.m_280168_().m_85837_((double)((float)x + 70.0f * finScale), (double)((float)y + 10.0f * finScale), 0.0);
        ms.m_280168_().m_85841_(finScale, finScale, finScale);
        ms.m_280480_(result, 0, 0);
        ms.m_280168_().m_85849_();
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        ms.m_280168_().m_85841_(scale, scale, 0.0f);
        ms.m_280168_().m_252880_(37.0f, 13.0f, 1.0f);
        ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
        this.drawImage(ms, DRAWINGS_0, 0, 0, 389, 1, 50, 50, 512.0f);
        ms.m_280168_().m_85849_();
    }

    public void writeFromTxt(GuiGraphics ms) {
        String fileName = this.pageType.getName() + "_" + this.bookPages + ".txt";
        String languageName = Minecraft.m_91087_().f_91066_.f_92075_.toLowerCase(Locale.ROOT);
        ResourceLocation fileLoc = ResourceLocation.m_214293_((String)"iceandfire", (String)("lang/bestiary/" + languageName + "_0/" + fileName));
        ResourceLocation backupLoc = ResourceLocation.m_214293_((String)"iceandfire", (String)("lang/bestiary/en_us_0/" + fileName));
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(fileLoc);
        if (resource.isEmpty()) {
            resource = Minecraft.m_91087_().m_91098_().m_213713_(backupLoc);
        }
        try {
            assert (resource.isPresent());
            List lines = IOUtils.readLines((InputStream)((Resource)resource.get()).m_215507_(), (String)"UTF-8");
            int linenumber = 0;
            for (String line : lines) {
                if ((line = line.trim()).contains("<") || line.contains(">")) continue;
                ms.m_280168_().m_85836_();
                if (this.usingVanillaFont()) {
                    ms.m_280168_().m_85841_(0.945f, 0.945f, 0.945f);
                    ms.m_280168_().m_252880_(0.0f, 5.5f, 0.0f);
                }
                if (linenumber <= 19) {
                    this.f_96547_.m_271703_(line, 15.0f, (float)(20 + linenumber * 10), 0x303030, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else {
                    this.f_96547_.m_271703_(line, 220.0f, (float)((linenumber - 19) * 10), 0x303030, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                ++linenumber;
                ms.m_280168_().m_85849_();
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error((Object)e);
        }
        ms.m_280168_().m_85836_();
        String s = I18n.m_118938_((String)("bestiary." + this.pageType.getName()), (Object[])new Object[0]);
        float scale = this.f_96547_.m_92895_(s) <= 100 ? 2.0f : (float)this.f_96547_.m_92895_(s) * 0.0125f;
        ms.m_280168_().m_85841_(scale, scale, scale);
        this.f_96547_.m_271703_(s, 10.0f, 2.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ms.m_280168_().m_85849_();
    }

    private boolean usingVanillaFont() {
        return this.f_96547_ == Minecraft.m_91087_().f_91062_;
    }

    public void drawImage(GuiGraphics ms, ResourceLocation texture, int x, int y, int u, int v, int width, int height, float scale) {
        ms.m_280168_().m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        ms.m_280168_().m_85841_(scale / 512.0f, scale / 512.0f, scale / 512.0f);
        ms.m_280163_(texture, x, y, (float)u, (float)v, width, height, 512, 512);
        ms.m_280168_().m_85849_();
    }

    private void drawItemStack(GuiGraphics ms, ItemStack stack, int x, int y, float scale) {
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85841_(scale, scale, scale);
        ms.m_280480_(stack, x, y);
        ms.m_280168_().m_85849_();
    }

    private void drawBlockStack(GuiGraphics ms, ItemStack stack, int x, int y, float scale, int zScale) {
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85841_(scale, scale, scale);
        ms.m_280168_().m_252880_(0.0f, 0.0f, (float)(zScale * 10));
        ms.m_280480_(stack, x, y);
        ms.m_280168_().m_85849_();
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
    }
}

