/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.screen.handler.DragonScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.joml.Quaternionf;

public class DragonScreen
extends AbstractContainerScreen<DragonScreenHandler> {
    private static final ResourceLocation texture = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/dragon.png");

    public DragonScreen(DragonScreenHandler dragonInv, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)dragonInv, playerInv, name);
        this.f_97727_ = 214;
    }

    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrixStack);
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        EntityDragonBase dragon;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(texture, k, l, 0, 0, this.f_97726_, this.f_97727_);
        assert (Minecraft.m_91087_().f_91073_ != null);
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(((DragonScreenHandler)this.f_97732_).getDragonId());
        if (entity instanceof EntityDragonBase) {
            dragon = (EntityDragonBase)entity;
            float dragonScale = 1.0f / Math.max(1.0E-4f, dragon.m_6134_());
            Quaternionf quaternionf = new Quaternionf().rotateY((float)Mth.m_14139_((double)((float)mouseX / (float)this.f_96543_), (double)0.0, (double)Math.PI)).rotateZ((float)Mth.m_14139_((double)((float)mouseY / (float)this.f_96543_), (double)Math.PI, (double)3.3415926535897933));
            InventoryScreen.m_280432_((GuiGraphics)matrixStack, (int)(k + 88), (int)(l + (int)(0.5f * dragon.flyProgress) + 55), (int)((int)(dragonScale * 23.0f)), (Quaternionf)quaternionf, null, (LivingEntity)dragon);
        }
        if (entity instanceof EntityDragonBase) {
            dragon = (EntityDragonBase)entity;
            assert (this.f_96541_ != null);
            Font textRenderer = this.f_96541_.f_91062_;
            String s3 = dragon.m_7770_() == null ? I18n.m_118938_((String)"dragon.unnamed", (Object[])new Object[0]) : I18n.m_118938_((String)"dragon.name", (Object[])new Object[0]) + " " + dragon.m_7770_().getString();
            textRenderer.m_271703_(s3, (float)k + (float)this.f_97726_ / 2.0f - (float)textRenderer.m_92895_(s3) / 2.0f, (float)(l + 75), 0xFFFFFF, false, matrixStack.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)matrixStack.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s2 = I18n.m_118938_((String)"dragon.health", (Object[])new Object[0]) + " " + Math.floor(Math.min(dragon.m_21223_(), dragon.m_21233_())) + " / " + dragon.m_21233_();
            textRenderer.m_271703_(s2, (float)k + (float)this.f_97726_ / 2.0f - (float)textRenderer.m_92895_(s2) / 2.0f, (float)(l + 84), 0xFFFFFF, false, matrixStack.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)matrixStack.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s = dragon.isMale() ? "dragon.gender.male" : "dragon.gender.female";
            String s5 = I18n.m_118938_((String)"dragon.gender", (Object[])new Object[0]) + I18n.m_118938_((String)s, (Object[])new Object[0]);
            textRenderer.m_271703_(s5, (float)k + (float)this.f_97726_ / 2.0f - (float)textRenderer.m_92895_(s5) / 2.0f, (float)(l + 93), 0xFFFFFF, false, matrixStack.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)matrixStack.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s6 = I18n.m_118938_((String)"dragon.hunger", (Object[])new Object[0]) + dragon.getHunger() + "/100";
            textRenderer.m_271703_(s6, (float)k + (float)this.f_97726_ / 2.0f - (float)textRenderer.m_92895_(s6) / 2.0f, (float)(l + 102), 0xFFFFFF, false, matrixStack.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)matrixStack.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s4 = I18n.m_118938_((String)"dragon.stage", (Object[])new Object[0]) + " " + dragon.getDragonStage() + " " + I18n.m_118938_((String)"dragon.days.front", (Object[])new Object[0]) + dragon.getAgeInDays() + " " + I18n.m_118938_((String)"dragon.days.back", (Object[])new Object[0]);
            textRenderer.m_271703_(s4, (float)k + (float)this.f_97726_ / 2.0f - (float)textRenderer.m_92895_(s4) / 2.0f, (float)(l + 111), 0xFFFFFF, false, matrixStack.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)matrixStack.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s7 = dragon.m_269323_() != null ? I18n.m_118938_((String)"dragon.owner", (Object[])new Object[0]) + dragon.m_269323_().m_7755_().getString() : I18n.m_118938_((String)"dragon.untamed", (Object[])new Object[0]);
            textRenderer.m_271703_(s7, (float)k + (float)this.f_97726_ / 2.0f - (float)textRenderer.m_92895_(s7) / 2.0f, (float)(l + 120), 0xFFFFFF, false, matrixStack.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)matrixStack.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }
}

