/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.iceandfire.screen.handler.DragonForgeScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;

public class DragonForgeScreen
extends AbstractContainerScreen<DragonForgeScreenHandler> {
    private static final ResourceLocation TEXTURE_FIRE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/dragonforge_fire.png");
    private static final ResourceLocation TEXTURE_ICE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/dragonforge_ice.png");
    private static final ResourceLocation TEXTURE_LIGHTNING = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/gui/dragonforge_lightning.png");
    private final DragonForgeScreenHandler tileFurnace;

    public DragonForgeScreen(DragonForgeScreenHandler container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tileFurnace = container;
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        assert (this.f_96541_ != null);
        Font textRenderer = this.f_96541_.f_91062_;
        if (this.tileFurnace != null) {
            String s = I18n.m_118938_((String)("block.iceandfire.dragonforge_" + DragonType.getNameFromInt(this.tileFurnace.getPropertyDelegate().fireType) + "_core"), (Object[])new Object[0]);
            pGuiGraphics.m_280056_(this.f_96547_, s, this.f_97726_ / 2 - textRenderer.m_92895_(s) / 2, 6, 0x404040, false);
        }
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int dragonType = this.tileFurnace.getPropertyDelegate().fireType;
        ResourceLocation texture = switch (dragonType) {
            case 0 -> TEXTURE_FIRE;
            case 1 -> TEXTURE_ICE;
            default -> TEXTURE_LIGHTNING;
        };
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(texture, k, l, 0, 0, this.f_97726_, this.f_97727_);
        int i1 = this.getCookTime(this.tileFurnace.getPropertyDelegate().cookTime);
        pGuiGraphics.m_280218_(texture, k + 12, l + 23, 0, 166, i1, 38);
    }

    private int getCookTime(int time) {
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91073_ != null);
        List<DragonForgeRecipe> recipes = this.f_96541_.f_91073_.m_7465_().m_44013_((RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get()).stream().filter(item -> item.isValidInput(this.tileFurnace.m_38853_(0).m_7993_()) && item.isValidBlood(this.tileFurnace.m_38853_(1).m_7993_())).toList();
        int maxCookTime = recipes.isEmpty() ? 100 : recipes.get(0).getCookTime();
        double scale = 125000.0 / (double)maxCookTime;
        return (int)(scale * (double)time / (double)maxCookTime);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
    }
}

