/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.particle.CockatriceBeamRender;
import com.iafenvoy.iceandfire.render.model.ModelCockatrice;
import com.iafenvoy.iceandfire.render.model.ModelCockatriceChick;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RenderCockatrice
extends MobRenderer<EntityCockatrice, AdvancedEntityModel<EntityCockatrice>> {
    public static final ResourceLocation TEXTURE_ROOSTER = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/cockatrice/cockatrice_0.png");
    public static final ResourceLocation TEXTURE_HEN = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/cockatrice/cockatrice_1.png");
    public static final ResourceLocation TEXTURE_ROOSTER_CHICK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/cockatrice/cockatrice_0_chick.png");
    public static final ResourceLocation TEXTURE_HEN_CHICK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/cockatrice/cockatrice_1_chick.png");
    public static final ModelCockatrice ADULT_MODEL = new ModelCockatrice();
    public static final ModelCockatriceChick BABY_MODEL = new ModelCockatriceChick();

    public RenderCockatrice(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelCockatrice(), 0.6f);
    }

    private Vec3 getPosition(LivingEntity LivingEntityIn, double p_177110_2_) {
        double d0 = LivingEntityIn.f_19790_ + (LivingEntityIn.m_20185_() - LivingEntityIn.f_19790_);
        double d1 = p_177110_2_ + LivingEntityIn.f_19791_ + (LivingEntityIn.m_20186_() - LivingEntityIn.f_19791_);
        double d2 = LivingEntityIn.f_19792_ + (LivingEntityIn.m_20189_() - LivingEntityIn.f_19792_);
        return new Vec3(d0, d1, d2);
    }

    public boolean shouldRender(EntityCockatrice livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.m_5523_((Mob)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasTargetedEntity() && (livingentity = livingEntityIn.getTargetedEntity()) != null) {
            Vec3 Vector3d = this.getPosition(livingentity, (double)livingentity.m_20206_() * 0.5);
            Vec3 Vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.m_20192_());
            return camera.m_113029_(new AABB(Vector3d1.f_82479_, Vector3d1.f_82480_, Vector3d1.f_82481_, Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_));
        }
        return false;
    }

    public void render(EntityCockatrice entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        boolean blindness;
        this.f_115290_ = entityIn.m_6162_() ? BABY_MODEL : ADULT_MODEL;
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        LivingEntity livingentity = entityIn.getTargetedEntity();
        boolean bl = blindness = entityIn.m_21023_(MobEffects.f_19610_) || livingentity != null && livingentity.m_21023_(MobEffects.f_19610_);
        if (!blindness && livingentity != null && EntityGorgon.isEntityLookingAt((LivingEntity)entityIn, livingentity, 0.6f) && EntityGorgon.isEntityLookingAt(livingentity, (LivingEntity)entityIn, 0.6f)) {
            CockatriceBeamRender.render((Entity)entityIn, (Entity)livingentity, matrixStackIn, bufferIn, partialTicks);
        }
    }

    protected void scale(EntityCockatrice entity, PoseStack matrixStackIn, float partialTickTime) {
        if (entity.m_6162_()) {
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getTexture(EntityCockatrice cockatrice) {
        return cockatrice.m_6162_() ? (cockatrice.isHen() ? TEXTURE_HEN_CHICK : TEXTURE_ROOSTER_CHICK) : (cockatrice.isHen() ? TEXTURE_HEN : TEXTURE_ROOSTER);
    }
}

