/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderChain {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/misc/chain_link.png");

    public static void render(LivingEntity entityLivingIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int lightIn, List<Entity> chainedTo) {
        for (Entity chainTarget : chainedTo) {
            if (chainTarget == null) {
                IceAndFire.LOGGER.warn("Found null value in list of target entities");
                continue;
            }
            try {
                RenderChain.renderLink(entityLivingIn, matrixStackIn, bufferIn, lightIn, chainTarget);
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Could not render chain link for {} connected to {}", (Object)entityLivingIn.toString(), (Object)chainTarget.toString());
            }
        }
    }

    public static <E extends Entity> void renderLink(LivingEntity entityLivingIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int lightIn, E chainTarget) {
        float f3 = entityLivingIn.m_20206_() * 0.4f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, (double)f3, 0.0);
        Vec3 vector3d = RenderChain.getPosition(chainTarget, (double)chainTarget.m_20206_() * 0.5);
        Vec3 vector3d1 = RenderChain.getPosition((Entity)entityLivingIn, f3);
        Vec3 vector3d2 = vector3d.m_82546_(vector3d1);
        float f4 = (float)(vector3d2.m_82553_() + 0.0);
        vector3d2 = vector3d2.m_82541_();
        float f5 = (float)Math.acos(vector3d2.f_82480_);
        float f6 = (float)Math.atan2(vector3d2.f_82481_, vector3d2.f_82479_);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252961_(1.5707964f - f6));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252961_(f5));
        float f7 = -1.0f;
        int j = 255;
        int k = 255;
        int l = 255;
        float f19 = 0.0f;
        float f20 = 0.2f;
        float f21 = 0.0f;
        float f22 = -0.2f;
        float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = 0.0f;
        float f30 = f4 + f29;
        float f32 = 0.75f;
        float f31 = f4 + f32;
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)RenderChain.getTexture()));
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        matrixStackIn.m_85836_();
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f31, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f32, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f32, lightIn);
        RenderChain.vertex(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f31, lightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int r, int g, int b, float u, float v, int packedLight) {
        consumer.m_252986_(matrix4f, x, y, z).m_6122_(r, g, b, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static Vec3 getPosition(Entity LivingEntityIn, double p_177110_2_) {
        return LivingEntityIn.m_20182_().m_82520_(0.0, p_177110_2_, 0.0);
    }

    public static ResourceLocation getTexture() {
        return TEXTURE;
    }
}

