/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafRecipeSerializers;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.uranus.client.model.tabula.JsonUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DragonForgeRecipe
implements Recipe<BlockEntityDragonForge> {
    private final Ingredient input;
    private final Ingredient blood;
    private final ItemStack result;
    private final String dragonType;
    private final int cookTime;
    private final ResourceLocation recipeId;

    public DragonForgeRecipe(ResourceLocation recipeId, Ingredient input, Ingredient blood, ItemStack result, String dragonType, int cookTime) {
        this.recipeId = recipeId;
        this.input = input;
        this.blood = blood;
        this.result = result;
        this.dragonType = dragonType;
        this.cookTime = cookTime;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getBlood() {
        return this.blood;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public String getDragonType() {
        return this.dragonType;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(BlockEntityDragonForge inv, Level worldIn) {
        return this.input.test(inv.m_8020_(0)) && this.blood.test(inv.m_8020_(1)) && this.dragonType.equals(inv.getTypeID());
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean isValidBlood(ItemStack blood) {
        return this.blood.test(blood);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public ItemStack craft(BlockEntityDragonForge dragonforge, RegistryAccess registryAccess) {
        return this.result;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)IafBlocks.DRAGONFORGE_FIRE_CORE.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)IafRecipeSerializers.DRAGONFORGE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DragonForgeRecipe> {
        public DragonForgeRecipe read(ResourceLocation recipeId, JsonObject json) {
            String dragonType = JsonUtils.getString((JsonObject)json, (String)"dragon_type");
            Ingredient input = Ingredient.m_43917_((JsonElement)JsonUtils.getJsonObject((JsonObject)json, (String)"input"));
            Ingredient blood = Ingredient.m_43917_((JsonElement)JsonUtils.getJsonObject((JsonObject)json, (String)"blood"));
            int cookTime = JsonUtils.getInt((JsonObject)json, (String)"cook_time");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)JsonUtils.getJsonObject((JsonObject)json, (String)"result"));
            return new DragonForgeRecipe(recipeId, input, blood, result, dragonType, cookTime);
        }

        public DragonForgeRecipe read(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int cookTime = buffer.readInt();
            String dragonType = buffer.m_130277_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient blood = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new DragonForgeRecipe(recipeId, input, blood, result, dragonType, cookTime);
        }

        public void write(FriendlyByteBuf buffer, DragonForgeRecipe recipe) {
            buffer.writeInt(recipe.cookTime);
            buffer.m_130070_(recipe.dragonType);
            recipe.input.m_43923_(buffer);
            recipe.blood.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

