/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.network;

import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityHippocampus;
import com.iafenvoy.iceandfire.entity.EntityHippogryph;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.event.ServerEvents;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerNetworkHelper {
    public static void registerReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)StaticVariables.MYRMEX_SYNC, (buf, ctx) -> {
            MyrmexHive serverHive = MyrmexHive.fromNBT(buf.m_130260_());
            CompoundTag tag = new CompoundTag();
            serverHive.writeVillageDataToNBT(tag);
            serverHive.readVillageDataFromNBT(tag);
            Player player = ctx.getPlayer();
            if (player != null) {
                MyrmexHive realHive = MyrmexWorldData.get(player.m_9236_()).getHiveFromUUID(serverHive.hiveUUID);
                realHive.readVillageDataFromNBT(serverHive.toNBT());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)StaticVariables.DRAGON_CONTROL, (buf, ctx) -> {
            Entity entity;
            int dragonId = buf.readInt();
            byte controlState = buf.readByte();
            BlockPos pos = buf.m_130135_();
            Player player = ctx.getPlayer();
            if (player != null && ServerEvents.isRidingOrBeingRiddenBy(entity = player.m_9236_().m_6815_(dragonId), (Entity)player)) {
                if (entity instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)entity;
                    if (dragon.m_21830_((LivingEntity)player)) {
                        dragon.setControlState(controlState);
                    }
                } else if (entity instanceof EntityHippogryph) {
                    EntityHippogryph hippogryph = (EntityHippogryph)entity;
                    if (hippogryph.m_21830_((LivingEntity)player)) {
                        hippogryph.setControlState(controlState);
                    }
                } else if (entity instanceof EntityHippocampus) {
                    EntityHippocampus hippo = (EntityHippocampus)entity;
                    if (hippo.m_21830_((LivingEntity)player)) {
                        hippo.setControlState(controlState);
                    }
                    hippo.m_20343_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                } else if (entity instanceof EntityDeathWorm) {
                    EntityDeathWorm deathWorm = (EntityDeathWorm)entity;
                    deathWorm.setControlState(controlState);
                    deathWorm.m_20343_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                } else if (entity instanceof EntityAmphithere) {
                    EntityAmphithere amphithere = (EntityAmphithere)entity;
                    if (amphithere.m_21830_((LivingEntity)player)) {
                        amphithere.setControlState(controlState);
                    }
                    amphithere.m_20343_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)StaticVariables.MULTIPART_INTERACT, (buf, ctx) -> {
            UUID creatureID = buf.m_130259_();
            float dmg = buf.readFloat();
            Player player = ctx.getPlayer();
            ctx.queue(() -> {
                LivingEntity livingEntity;
                double dist;
                ServerLevel serverWorld;
                Entity entity;
                Level patt3895$temp;
                if (player != null && (patt3895$temp = player.m_9236_()) instanceof ServerLevel && (entity = (serverWorld = (ServerLevel)patt3895$temp).m_8791_(creatureID)) instanceof LivingEntity && (dist = (double)player.m_20270_((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                    if (dmg > 0.0f) {
                        livingEntity.m_6469_(player.m_9236_().f_268497_.m_269333_((LivingEntity)player), dmg);
                    } else {
                        livingEntity.m_6096_(player, InteractionHand.MAIN_HAND);
                    }
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)StaticVariables.PLAYER_HIT_MULTIPART, (buf, ctx) -> {
            LivingEntity livingEntity;
            double dist;
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.m_9236_().m_6815_(buf.readInt())) instanceof LivingEntity && (dist = (double)player.m_20270_((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                player.m_5706_((Entity)livingEntity);
                if (livingEntity instanceof EntityHydra) {
                    EntityHydra hydra = (EntityHydra)livingEntity;
                    hydra.triggerHeadFlags(buf.readInt());
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)StaticVariables.START_RIDING_MOB_C2S, (buf, ctx) -> {
            TamableAnimal tamable;
            Entity entity;
            int dragonId = buf.readInt();
            boolean ride = buf.readBoolean();
            boolean baby = buf.readBoolean();
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.m_9236_().m_6815_(dragonId)) instanceof ISyncMount && entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21830_((LivingEntity)player) && tamable.m_20270_((Entity)player) < 14.0f) {
                if (ride) {
                    if (baby) {
                        tamable.m_7998_((Entity)player, true);
                    } else {
                        player.m_7998_((Entity)tamable, true);
                    }
                } else if (baby) {
                    tamable.m_8127_();
                } else {
                    player.m_8127_();
                }
            }
        });
    }
}

