/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.iafenvoy.iceandfire.entity.EntityTideTrident;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemTideTrident
extends TridentItem {
    public ItemTideTrident() {
        super(new Item.Properties().m_41503_(400));
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            int riptideLevel;
            Player player = (Player)entityLiving;
            int time = this.m_8105_(stack) - timeLeft;
            if (time >= 10 && ((riptideLevel = EnchantmentHelper.m_44932_((ItemStack)stack)) <= 0 || player.m_20070_())) {
                if (!worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(entityLiving.m_7655_()));
                    if (riptideLevel == 0) {
                        EntityTideTrident tideTrident = new EntityTideTrident(worldIn, (LivingEntity)player, stack);
                        tideTrident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                        if (player.m_150110_().f_35937_) {
                            tideTrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.m_7967_((Entity)tideTrident);
                        worldIn.m_6269_(null, (Entity)tideTrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            player.m_150109_().m_36057_(stack);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (riptideLevel > 0) {
                    float yaw = player.m_146908_();
                    float pitch = player.m_146909_();
                    float velocityX = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                    float velocityY = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                    float velocityZ = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                    float speed = Mth.m_14116_((float)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
                    float targetSpeed = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                    player.m_5997_((double)(velocityX *= targetSpeed / speed), (double)(velocityY *= targetSpeed / speed), (double)(velocityZ *= targetSpeed / speed));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent sound = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    worldIn.m_6269_(null, (Entity)player, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 12.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.legendary_weapon.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.tide_trident.desc_0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.tide_trident.desc_1").m_130940_(ChatFormatting.GRAY));
    }
}

