/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDragonForgeInput
extends BaseEntityBlock
implements IDragonProof {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private final int dragonType;

    public BlockDragonForgeInput(int dragonType) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60988_().m_60913_(40.0f, 500.0f).m_60918_(SoundType.f_56743_));
        this.dragonType = dragonType;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE));
    }

    public static String name(int dragonType) {
        return "dragonforge_%s_input".formatted(DragonType.getNameFromInt(dragonType));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntityDragonForge forge;
        if (this.getConnectedTileEntity(world, hitResult.m_82425_()) != null && (forge = this.getConnectedTileEntity(world, hitResult.m_82425_())) != null && forge.getPropertyDelegate().fireType == this.dragonType) {
            MenuProvider inamedcontainerprovider;
            if (!world.f_46443_ && (inamedcontainerprovider = this.m_7246_(forge.m_58900_(), world, forge.m_58899_())) != null) {
                player.m_5893_(inamedcontainerprovider);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private BlockEntityDragonForge getConnectedTileEntity(Level world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            if (world.m_7702_(pos.m_121945_(facing)) == null || !(world.m_7702_(pos.m_121945_(facing)) instanceof BlockEntityDragonForge)) continue;
            return (BlockEntityDragonForge)world.m_7702_(pos.m_121945_(facing));
        }
        return null;
    }

    public BlockState getStateFromMeta(int meta) {
        return (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(meta > 0));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getMetaFromState(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? 1 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return world.f_46443_ ? null : BlockDragonForgeInput.m_152132_(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.DRAGONFORGE_INPUT.get()), BlockEntityDragonForgeInput::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityDragonForgeInput(pos, state);
    }
}

