/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeBrick;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDragonForgeBricks
extends BaseEntityBlock
implements IDragonProof {
    public static final BooleanProperty GRILL = BooleanProperty.m_61465_((String)"grill");
    private final int isFire;

    public BlockDragonForgeBricks(int isFire) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60988_().m_60913_(40.0f, 500.0f).m_60918_(SoundType.f_56743_));
        this.isFire = isFire;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)GRILL, (Comparable)Boolean.FALSE));
    }

    public static String name(int dragonType) {
        return "dragonforge_%s_brick".formatted(DragonType.getNameFromInt(dragonType));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult resultIn) {
        BlockEntityDragonForge forge;
        if (this.getConnectedTileEntity(worldIn, resultIn.m_82425_()) != null && (forge = this.getConnectedTileEntity(worldIn, resultIn.m_82425_())) != null && forge.getPropertyDelegate().fireType == this.isFire) {
            MenuProvider inamedcontainerprovider;
            if (!worldIn.f_46443_ && (inamedcontainerprovider = this.m_7246_(forge.m_58900_(), worldIn, forge.m_58899_())) != null) {
                player.m_5893_(inamedcontainerprovider);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private BlockEntityDragonForge getConnectedTileEntity(Level worldIn, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockEntityDragonForge forge;
            BlockEntity blockEntity;
            if (worldIn.m_7702_(pos.m_121945_(facing)) == null || !((blockEntity = worldIn.m_7702_(pos.m_121945_(facing))) instanceof BlockEntityDragonForge) || !(forge = (BlockEntityDragonForge)blockEntity).assembled()) continue;
            return forge;
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GRILL});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityDragonForgeBrick(pos, state);
    }
}

