/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ItemDragonSeeker
extends Item {
    private final SeekerType type;

    public ItemDragonSeeker(SeekerType type) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (world.f_46443_) {
            return super.m_7203_(world, user, hand);
        }
        if (!((Boolean)IafCommonConfig.INSTANCE.misc.enableDragonSeeker.getValue()).booleanValue()) {
            user.m_5661_((Component)Component.m_237115_((String)"text.iceandfire.not_enable"), false);
            return super.m_7203_(world, user, hand);
        }
        ItemStack stack = user.m_21120_(hand);
        EntityDragonBase dragon = (EntityDragonBase)world.m_45963_(EntityDragonBase.class, TargetingConditions.m_148352_().m_26888_(entity -> {
            if (!(entity instanceof EntityDragonBase)) {
                return false;
            }
            EntityDragonBase d = (EntityDragonBase)entity;
            if (d.isMobDead() && !this.type.trackDead) {
                return false;
            }
            return !d.m_21824_() || this.type.trackTeamed;
        }), (LivingEntity)user, user.m_20185_(), user.m_20186_(), user.m_20189_(), new AABB(this.type.add(user.m_20182_(), true), this.type.add(user.m_20182_(), false)));
        if (dragon == null) {
            user.m_213846_((Component)Component.m_237115_((String)"item.iceandfire.dragon_seeker.not_found"));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.type.admin) {
            String pos1 = String.format("[%d, %d, %d]", (int)dragon.m_20185_(), (int)dragon.m_20186_(), (int)dragon.m_20189_());
            String pos2 = String.format("/tp @s %d %d %d", (int)dragon.m_20185_(), (int)dragon.m_20186_(), (int)dragon.m_20189_());
            MutableComponent locationText = Component.m_237113_((String)pos1).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, pos2)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
            user.m_213846_((Component)Component.m_237115_((String)"item.iceandfire.dragon_seeker.found_location").m_7220_((Component)locationText));
        } else {
            user.m_213846_((Component)Component.m_237115_((String)"item.iceandfire.dragon_seeker.found"));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        String name = BuiltInRegistries.f_257033_.m_7981_((Object)this).m_135815_();
        tooltip.add((Component)Component.m_237115_((String)("item.iceandfire." + name + ".tooltip")));
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.dragon_seeker.credit").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
    }

    public static enum SeekerType {
        NORMAL(150, true, true, false),
        EPIC(200, false, true, false),
        LEGENDARY(300, false, false, false),
        GODLY(500, false, false, true);

        private final int trackRange;
        private final boolean trackDead;
        private final boolean trackTeamed;
        private final boolean admin;

        private SeekerType(int trackRange, boolean trackDead, boolean trackTeamed, boolean admin) {
            this.trackRange = trackRange;
            this.trackDead = trackDead;
            this.trackTeamed = trackTeamed;
            this.admin = admin;
        }

        public Vec3 add(Vec3 origin, boolean reverse) {
            int range = this.trackRange;
            if (reverse) {
                range *= -1;
            }
            return origin.m_82520_((double)range, (double)range, (double)range);
        }
    }
}

