/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityChainTie;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.phys.AABB;

public class ItemChain
extends Item {
    private final boolean sticky;

    public ItemChain(boolean sticky) {
        super(new Item.Properties());
        this.sticky = sticky;
    }

    public static void attachToFence(Player player, Level worldIn, BlockPos fence) {
        double d0 = 30.0;
        int i = fence.m_123341_();
        int j = fence.m_123342_();
        int k = fence.m_123343_();
        for (LivingEntity livingEntity : worldIn.m_45976_(LivingEntity.class, new AABB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0))) {
            IafEntityData data = IafEntityData.get(livingEntity);
            if (!data.chainData.isChainedTo((Entity)player)) continue;
            EntityChainTie entityleashknot = EntityChainTie.getKnotForPosition(worldIn, fence);
            if (entityleashknot == null) {
                entityleashknot = EntityChainTie.createTie(worldIn, fence);
            }
            data.chainData.removeChain((Entity)player);
            data.chainData.attachChain((Entity)entityleashknot);
        }
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.chain.desc_0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.chain.desc_1").m_130940_(ChatFormatting.GRAY));
        if (this.sticky) {
            tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.chain_sticky.desc_2").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.chain_sticky.desc_3").m_130940_(ChatFormatting.GREEN));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        IafEntityData targetData = IafEntityData.get(target);
        if (targetData.chainData.isChainedTo((Entity)playerIn)) {
            return InteractionResult.PASS;
        }
        if (this.sticky) {
            double d0 = 60.0;
            double i = playerIn.m_20185_();
            double j = playerIn.m_20186_();
            double k = playerIn.m_20189_();
            List nearbyEntities = playerIn.m_9236_().m_6443_(LivingEntity.class, new AABB(i - d0, j - d0, k - d0, i + d0, j + d0, k + d0), livingEntity -> true);
            if (playerIn.m_6144_()) {
                targetData.chainData.clearChains();
                for (LivingEntity livingEntity2 : nearbyEntities) {
                    IafEntityData nearbyData = IafEntityData.get(livingEntity2);
                    nearbyData.chainData.removeChain((Entity)target);
                }
                return InteractionResult.SUCCESS;
            }
            AtomicBoolean flag = new AtomicBoolean(false);
            for (LivingEntity livingEntity3 : nearbyEntities) {
                IafEntityData nearbyData = IafEntityData.get(livingEntity3);
                if (!nearbyData.chainData.isChainedTo((Entity)playerIn)) continue;
                targetData.chainData.removeChain((Entity)playerIn);
                nearbyData.chainData.removeChain((Entity)playerIn);
                nearbyData.chainData.attachChain((Entity)target);
                flag.set(true);
            }
            if (!flag.get()) {
                targetData.chainData.attachChain((Entity)playerIn);
            }
        } else {
            targetData.chainData.attachChain((Entity)playerIn);
        }
        if (!playerIn.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
        if (!(block instanceof WallBlock)) {
            return InteractionResult.PASS;
        }
        if (!context.m_43725_().f_46443_) {
            ItemChain.attachToFence(context.m_43723_(), context.m_43725_(), context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }
}

