/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.forge.component;

import com.iafenvoy.iceandfire.forge.component.PortalDataStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortalDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<PortalDataStorage> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PortalDataStorage>(){});
    private PortalDataStorage storage;
    private final LazyOptional<PortalDataStorage> storageLazyOptional = LazyOptional.of(this::getOrCreateStorage);
    private final Player player;

    public PortalDataProvider(Player player) {
        this.player = player;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return CAPABILITY.orEmpty(capability, this.storageLazyOptional);
    }

    public CompoundTag serializeNBT() {
        return this.getOrCreateStorage().serializeNBT();
    }

    public void deserializeNBT(CompoundTag arg) {
        this.getOrCreateStorage().deserializeNBT(arg);
    }

    private PortalDataStorage getOrCreateStorage() {
        if (this.storage == null) {
            this.storage = new PortalDataStorage(this.player);
        }
        return this.storage;
    }
}

