/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.event;

import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.config.IafClientConfig;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.particle.CockatriceBeamRender;
import com.iafenvoy.iceandfire.registry.IafKeybindings;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.render.block.RenderFrozenState;
import com.iafenvoy.iceandfire.render.entity.RenderChain;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation SIREN_SHADER = ResourceLocation.m_214293_((String)"iceandfire", (String)"shaders/post/siren.json");
    public static int currentView = 0;

    public static void onCameraSetup(Camera camera) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20202_() instanceof EntityDragonBase) {
            float scale = ((EntityDragonBase)player.m_20202_()).getRenderSize() / 3.0f;
            if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
                if (currentView == 1) {
                    camera.m_90568_(-camera.m_90566_((double)(scale * 1.2f)), 0.0, 0.0);
                } else if (currentView == 2) {
                    camera.m_90568_(-camera.m_90566_((double)(scale * 3.0f)), 0.0, 0.0);
                } else if (currentView == 3) {
                    camera.m_90568_(-camera.m_90566_((double)(scale * 5.0f)), 0.0, 0.0);
                }
            }
        }
    }

    public static EventResult onEntityInteract(Player player, Entity entity, InteractionHand hand) {
        if (entity instanceof EntityMultipartPart) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static void onLivingUpdate(LivingEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity instanceof ICustomMoveController) {
            ICustomMoveController moveController = (ICustomMoveController)entity;
            if (entity.m_20202_() != null && entity.m_20202_() == mc.f_91074_) {
                byte previousState = moveController.getControlState();
                moveController.dismount(mc.f_91066_.f_92090_.m_90857_());
                byte controlState = moveController.getControlState();
                if (controlState != previousState) {
                    FriendlyByteBuf buf = PacketBufferUtils.create();
                    buf.writeInt(entity.m_19879_()).writeByte((int)controlState);
                    buf.m_130064_(entity.m_20183_());
                    NetworkManager.sendToServer((ResourceLocation)StaticVariables.DRAGON_CONTROL, (FriendlyByteBuf)buf);
                }
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_) {
                Entity controlState = player.m_20202_();
                if (controlState instanceof ICustomMoveController) {
                    ICustomMoveController controller = (ICustomMoveController)controlState;
                    Entity vehicle = player.m_20202_();
                    byte previousState = controller.getControlState();
                    controller.up(mc.f_91066_.f_92089_.m_90857_());
                    controller.down(IafKeybindings.DRAGON_DOWN.m_90857_());
                    controller.attack(IafKeybindings.DRAGON_STRIKE.m_90857_());
                    controller.dismount(mc.f_91066_.f_92090_.m_90857_());
                    controller.strike(IafKeybindings.DRAGON_BREATH.m_90857_());
                    byte controlState2 = controller.getControlState();
                    if (controlState2 != previousState) {
                        FriendlyByteBuf buf = PacketBufferUtils.create();
                        buf.writeInt(vehicle.m_19879_()).writeByte((int)controlState2);
                        buf.m_130064_(vehicle.m_20183_());
                        NetworkManager.sendToServer((ResourceLocation)StaticVariables.DRAGON_CONTROL, (FriendlyByteBuf)buf);
                    }
                }
                GameRenderer renderer = Minecraft.m_91087_().f_91063_;
                IafEntityData data = IafEntityData.get((LivingEntity)player);
                if (((Boolean)IafClientConfig.INSTANCE.sirenShader.getValue()).booleanValue() && data.sirenData.charmedBy == null && renderer.m_109149_() != null && SIREN_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                    renderer.m_109086_();
                }
                if (data.sirenData.charmedBy == null) {
                    return;
                }
                if (((Boolean)IafClientConfig.INSTANCE.sirenShader.getValue()).booleanValue() && !data.sirenData.isCharmed && renderer.m_109149_() != null && SIREN_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                    renderer.m_109086_();
                }
                if (data.sirenData.isCharmed) {
                    if (entity.m_217043_().m_188503_(40) == 0) {
                        entity.m_9236_().m_7106_((ParticleOptions)IafParticles.SIREN_APPEARANCE.get(), player.m_20185_(), player.m_20186_(), player.m_20189_(), (double)data.sirenData.charmedBy.getHairColor(), 0.0, 0.0);
                    }
                    if (((Boolean)IafClientConfig.INSTANCE.sirenShader.getValue()).booleanValue() && renderer.m_109149_() == null) {
                        renderer.m_109128_(SIREN_SHADER);
                    }
                }
            }
        }
    }

    public static void onPostRenderLiving(LivingEntity entity, float partialRenderTick, PoseStack matrixStack, MultiBufferSource buffers, int light) {
        IafEntityData data = IafEntityData.get(entity);
        data.miscData.checkScepterTarget();
        for (LivingEntity target : data.miscData.getTargetedByScepter()) {
            CockatriceBeamRender.render((Entity)entity, (Entity)target, matrixStack, buffers, partialRenderTick);
        }
        if (data.frozenData.isFrozen) {
            RenderFrozenState.render(entity, matrixStack, buffers, light, data.frozenData.frozenTicks);
        }
        RenderChain.render(entity, matrixStack, buffers, light, data.chainData.getChainedTo());
    }
}

