/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeInput;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEntityDragonForgeInput
extends BlockEntity {
    private static final int LURE_DISTANCE = 50;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private int ticksSinceDragonFire;
    private BlockEntityDragonForge core = null;

    public BlockEntityDragonForgeInput(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.DRAGONFORGE_INPUT.get(), pos, state);
    }

    public static void tick(Level level, BlockPos position, BlockState state, BlockEntityDragonForgeInput forgeInput) {
        if (forgeInput.core == null) {
            forgeInput.core = forgeInput.getConnectedTileEntity(position);
        }
        if (forgeInput.ticksSinceDragonFire > 0) {
            --forgeInput.ticksSinceDragonFire;
        }
        if ((forgeInput.ticksSinceDragonFire == 0 || forgeInput.core == null) && forgeInput.isActive()) {
            BlockEntity tileentity = level.m_7702_(position);
            level.m_46597_(position, forgeInput.getDeactivatedState());
            if (tileentity != null) {
                tileentity.m_6339_();
                level.m_151523_(tileentity);
            }
        }
        if (forgeInput.isAssembled()) {
            forgeInput.lureDragons();
        }
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    protected void lureDragons() {
        Vec3 targetPosition = new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
        AABB searchArea = new AABB((double)this.f_58858_.m_123341_() - 50.0, (double)this.f_58858_.m_123342_() - 50.0, (double)this.f_58858_.m_123343_() - 50.0, (double)this.f_58858_.m_123341_() + 50.0, (double)this.f_58858_.m_123342_() + 50.0, (double)this.f_58858_.m_123343_() + 50.0);
        boolean dragonSelected = false;
        assert (this.f_58857_ != null);
        for (EntityDragonBase dragon : this.f_58857_.m_45976_(EntityDragonBase.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == dragon.dragonType.getIntFromType() && (dragon.isChained() || dragon.m_21824_()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.f_58858_;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.f_58858_) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    private boolean canSeeInput(EntityDragonBase dragon, Vec3 target) {
        if (target != null) {
            assert (this.f_58857_ != null);
            BlockHitResult rayTrace = this.f_58857_.m_45547_(new ClipContext(dragon.getHeadPosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
            double distance = dragon.getHeadPosition().m_82554_(rayTrace.m_82450_());
            return distance < (double)(10.0f + dragon.m_20205_());
        }
        return false;
    }

    private BlockState getDeactivatedState() {
        return switch (this.getDragonType()) {
            case 1 -> (BlockState)((Block)IafBlocks.DRAGONFORGE_ICE_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            case 2 -> (BlockState)((Block)IafBlocks.DRAGONFORGE_LIGHTNING_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            default -> (BlockState)((Block)IafBlocks.DRAGONFORGE_FIRE_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
        };
    }

    private int getDragonType() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() == IafBlocks.DRAGONFORGE_FIRE_INPUT.get()) {
            return 0;
        }
        if (state.m_60734_() == IafBlocks.DRAGONFORGE_ICE_INPUT.get()) {
            return 1;
        }
        if (state.m_60734_() == IafBlocks.DRAGONFORGE_LIGHTNING_INPUT.get()) {
            return 2;
        }
        return 0;
    }

    private boolean isActive() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return state.m_60734_() instanceof BlockDragonForgeInput && (Boolean)state.m_61143_((Property)BlockDragonForgeInput.ACTIVE) != false;
    }

    private BlockEntityDragonForge getConnectedTileEntity(BlockPos position) {
        for (Direction facing : HORIZONTALS) {
            assert (this.f_58857_ != null);
            BlockEntity blockEntity = this.f_58857_.m_7702_(position.m_121945_(facing));
            if (!(blockEntity instanceof BlockEntityDragonForge)) continue;
            BlockEntityDragonForge forge = (BlockEntityDragonForge)blockEntity;
            return forge;
        }
        return null;
    }
}

