/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityMyrmexSentinel;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MyrmexAIFindHidingSpot
extends Goal {
    private static final int RADIUS = 32;
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super Entity> targetEntitySelector;
    private final EntityMyrmexSentinel myrmex;
    private BlockPos targetBlock = null;
    private int wanderRadius = 32;

    public MyrmexAIFindHidingSpot(EntityMyrmexSentinel myrmex) {
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)myrmex);
        this.targetEntitySelector = myrmex1 -> myrmex1 instanceof EntityMyrmexSentinel;
        this.myrmex = myrmex;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.targetBlock = this.getTargetPosition(this.wanderRadius);
        return this.myrmex.canMove() && this.myrmex.m_5448_() == null && this.myrmex.canSeeSky() && !this.myrmex.isHiding() && this.myrmex.visibleTicks <= 0;
    }

    public boolean m_8045_() {
        return !this.myrmex.shouldEnterHive() && this.myrmex.m_5448_() == null && !this.myrmex.isHiding() && this.myrmex.visibleTicks <= 0;
    }

    public void m_8037_() {
        if (this.targetBlock != null) {
            this.myrmex.m_21573_().m_26519_((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_() + 0.5, 1.0);
            if (this.areMyrmexNear() || this.myrmex.isOnResin()) {
                if (this.myrmex.m_20238_(Vec3.m_82512_((Vec3i)this.targetBlock)) < 9.0) {
                    this.wanderRadius += 32;
                    this.targetBlock = this.getTargetPosition(this.wanderRadius);
                }
            } else if (this.myrmex.m_5448_() == null && this.myrmex.m_7962_() == null && this.myrmex.visibleTicks == 0 && this.myrmex.m_20238_(Vec3.m_82512_((Vec3i)this.targetBlock)) < 9.0) {
                this.myrmex.setHiding(true);
                this.myrmex.m_21573_().m_26573_();
            }
        }
    }

    public void m_8041_() {
        this.targetBlock = null;
        this.wanderRadius = 32;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.myrmex.m_20191_().m_82377_(targetDistance, 14.0, targetDistance);
    }

    public BlockPos getTargetPosition(int radius) {
        int x = (int)this.myrmex.m_20185_() + this.myrmex.m_217043_().m_188503_(radius * 2) - radius;
        int z = (int)this.myrmex.m_20189_() + this.myrmex.m_217043_().m_188503_(radius * 2) - radius;
        return this.myrmex.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z));
    }

    private boolean areMyrmexNear() {
        List sentinels = this.myrmex.m_9236_().m_6249_((Entity)this.myrmex, this.getTargetableArea(5.0), this.targetEntitySelector);
        ArrayList<Entity> hiddenSentinels = new ArrayList<Entity>();
        for (Entity sentinel : sentinels) {
            if (!(sentinel instanceof EntityMyrmexSentinel) || !((EntityMyrmexSentinel)sentinel).isHiding()) continue;
            hiddenSentinels.add(sentinel);
        }
        return !hiddenSentinels.isEmpty();
    }
}

