/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.registry.IafEntities;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityStoneStatue
extends LivingEntity
implements IBlacklistedFromStatues {
    private static final EntityDataAccessor<String> TRAPPED_ENTITY_TYPE = SynchedEntityData.m_135353_(EntityStoneStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> TRAPPED_ENTITY_DATA = SynchedEntityData.m_135353_(EntityStoneStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Float> TRAPPED_ENTITY_WIDTH = SynchedEntityData.m_135353_(EntityStoneStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TRAPPED_ENTITY_HEIGHT = SynchedEntityData.m_135353_(EntityStoneStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TRAPPED_ENTITY_SCALE = SynchedEntityData.m_135353_(EntityStoneStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> CRACK_AMOUNT = SynchedEntityData.m_135353_(EntityStoneStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EntityDimensions stoneStatueSize = EntityDimensions.m_20398_((float)0.5f, (float)0.5f);

    public EntityStoneStatue(EntityType<? extends LivingEntity> t, Level worldIn) {
        super(t, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public static EntityStoneStatue buildStatueEntity(LivingEntity parent) {
        EntityStoneStatue statue = (EntityStoneStatue)((EntityType)IafEntities.STONE_STATUE.get()).m_20615_(parent.m_9236_());
        CompoundTag entityTag = new CompoundTag();
        try {
            if (!(parent instanceof Player)) {
                parent.m_20240_(entityTag);
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.debug("Encountered issue creating stone statue from {}", (Object)parent);
        }
        assert (statue != null);
        statue.setTrappedTag(entityTag);
        statue.setTrappedEntityTypeString(BuiltInRegistries.f_256780_.m_7981_((Object)parent.m_6095_()).toString());
        statue.setTrappedEntityWidth(parent.m_20205_());
        statue.setTrappedHeight(parent.m_20206_());
        statue.setTrappedScale(parent.m_6134_());
        return statue;
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_6075_() {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRAPPED_ENTITY_TYPE, (Object)"minecraft:pig");
        this.f_19804_.m_135372_(TRAPPED_ENTITY_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(TRAPPED_ENTITY_WIDTH, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(TRAPPED_ENTITY_HEIGHT, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(TRAPPED_ENTITY_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(CRACK_AMOUNT, (Object)0);
    }

    public EntityType<?> getTrappedEntityType() {
        return EntityType.m_20632_((String)this.getTrappedEntityTypeString()).orElse(EntityType.f_20510_);
    }

    public String getTrappedEntityTypeString() {
        return (String)this.f_19804_.m_135370_(TRAPPED_ENTITY_TYPE);
    }

    public void setTrappedEntityTypeString(String string) {
        this.f_19804_.m_135381_(TRAPPED_ENTITY_TYPE, (Object)string);
    }

    public CompoundTag getTrappedTag() {
        return (CompoundTag)this.f_19804_.m_135370_(TRAPPED_ENTITY_DATA);
    }

    public void setTrappedTag(CompoundTag tag) {
        this.f_19804_.m_135381_(TRAPPED_ENTITY_DATA, (Object)tag);
    }

    public float getTrappedWidth() {
        return ((Float)this.f_19804_.m_135370_(TRAPPED_ENTITY_WIDTH)).floatValue();
    }

    public void setTrappedEntityWidth(float size) {
        this.f_19804_.m_135381_(TRAPPED_ENTITY_WIDTH, (Object)Float.valueOf(size));
    }

    public float getTrappedHeight() {
        return ((Float)this.f_19804_.m_135370_(TRAPPED_ENTITY_HEIGHT)).floatValue();
    }

    public void setTrappedHeight(float size) {
        this.f_19804_.m_135381_(TRAPPED_ENTITY_HEIGHT, (Object)Float.valueOf(size));
    }

    public float getTrappedScale() {
        return ((Float)this.f_19804_.m_135370_(TRAPPED_ENTITY_SCALE)).floatValue();
    }

    public void setTrappedScale(float size) {
        this.f_19804_.m_135381_(TRAPPED_ENTITY_SCALE, (Object)Float.valueOf(size));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CrackAmount", this.getCrackAmount());
        tag.m_128350_("StatueWidth", this.getTrappedWidth());
        tag.m_128350_("StatueHeight", this.getTrappedHeight());
        tag.m_128350_("StatueScale", this.getTrappedScale());
        tag.m_128359_("StatueEntityType", this.getTrappedEntityTypeString());
        tag.m_128365_("StatueEntityTag", (Tag)this.getTrappedTag());
    }

    public float m_6134_() {
        return this.getTrappedScale();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCrackAmount(tag.m_128445_("CrackAmount"));
        this.setTrappedEntityWidth(tag.m_128457_("StatueWidth"));
        this.setTrappedHeight(tag.m_128457_("StatueHeight"));
        this.setTrappedScale(tag.m_128457_("StatueScale"));
        this.setTrappedEntityTypeString(tag.m_128461_("StatueEntityType"));
        if (tag.m_128441_("StatueEntityTag")) {
            this.setTrappedTag(tag.m_128469_("StatueEntityTag"));
        }
    }

    public boolean m_20147_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.stoneStatueSize;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_146922_(this.f_20883_);
        this.f_20885_ = this.m_146908_();
        if ((double)Math.abs(this.m_20205_() - this.getTrappedWidth()) > 0.01 || (double)Math.abs(this.m_20206_() - this.getTrappedHeight()) > 0.01) {
            double prevX = this.m_20185_();
            double prevZ = this.m_20189_();
            this.stoneStatueSize = EntityDimensions.m_20395_((float)this.getTrappedWidth(), (float)this.getTrappedHeight());
            this.m_6210_();
            this.m_6034_(prevX, this.m_20186_(), prevZ);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268524_) && amount > 0.0f) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                level = this.getTrappedEntityType().m_20615_((Level)serverWorld);
                if (level instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)level;
                    ExperienceOrb.m_147082_((ServerLevel)serverWorld, (Vec3)this.m_20182_(), (int)livingEntity.m_213860_());
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public int getCrackAmount() {
        return (Integer)this.f_19804_.m_135370_(CRACK_AMOUNT);
    }

    public void setCrackAmount(int crackAmount) {
        this.f_19804_.m_135381_(CRACK_AMOUNT, (Object)crackAmount);
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }
}

