/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.entity.ai.PixieAIEnterHouse;
import com.iafenvoy.iceandfire.entity.ai.PixieAIFlee;
import com.iafenvoy.iceandfire.entity.ai.PixieAIFollowOwner;
import com.iafenvoy.iceandfire.entity.ai.PixieAIMoveRandom;
import com.iafenvoy.iceandfire.entity.ai.PixieAIPickupItem;
import com.iafenvoy.iceandfire.entity.ai.PixieAISteal;
import com.iafenvoy.iceandfire.entity.block.BlockEntityPixieHouse;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.uranus.ServerHelper;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EntityPixie
extends TamableAnimal {
    public static final float[][] PARTICLE_RGB = new float[][]{{1.0f, 0.752f, 0.792f}, {0.831f, 0.662f, 1.0f}, {0.513f, 0.843f, 1.0f}, {0.654f, 0.909f, 0.615f}, {0.996f, 0.788f, 0.407f}};
    public static final int STEAL_COOLDOWN = 3000;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityPixie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityPixie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final MobEffect[] positivePotions = new MobEffect[]{MobEffects.f_19600_, MobEffects.f_19603_, MobEffects.f_19596_, MobEffects.f_19621_, MobEffects.f_19598_};
    public final MobEffect[] negativePotions = new MobEffect[]{MobEffects.f_19613_, MobEffects.f_19604_, MobEffects.f_19597_, MobEffects.f_19590_, MobEffects.f_19599_};
    public boolean slowSpeed = false;
    public int ticksUntilHouseAI;
    public int ticksHeldItemFor;
    public int stealCooldown = 0;
    private BlockPos housePos;
    private boolean isSitting;

    public EntityPixie(EntityType<? extends EntityPixie> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new AIMoveControl(this);
        this.f_21364_ = 3;
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, Level world, double x, double z, RandomSource rand) {
        BlockPos pos = BlockPos.m_274561_((double)x, (double)entity.m_146904_(), (double)z);
        for (int yDown = 0; yDown < 3; ++yDown) {
            if (world.m_46859_(pos.m_6625_(yDown))) continue;
            return pos.m_6630_(yDown);
        }
        return pos;
    }

    public static BlockPos findAHouse(Entity entity, Level world) {
        for (int xSearch = -10; xSearch < 10; ++xSearch) {
            for (int ySearch = -10; ySearch < 10; ++ySearch) {
                for (int zSearch = -10; zSearch < 10; ++zSearch) {
                    BlockEntity blockEntity;
                    if (world.m_7702_(entity.m_20183_().m_7918_(xSearch, ySearch, zSearch)) == null || !((blockEntity = world.m_7702_(entity.m_20183_().m_7918_(xSearch, ySearch, zSearch))) instanceof BlockEntityPixieHouse)) continue;
                    BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
                    if (house.hasPixie) continue;
                    return entity.m_20183_().m_7918_(xSearch, ySearch, zSearch);
                }
            }
        }
        return entity.m_20183_();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean isPixieSitting() {
        if (this.m_9236_().f_46443_) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
            this.m_21839_(isSitting);
            return isSitting;
        }
        return this.isSitting;
    }

    public void setPixieSitting(boolean sitting) {
        if (!this.m_9236_().f_46443_) {
            this.isSitting = sitting;
            this.m_21837_(sitting);
        }
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        if (sitting) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean m_21827_() {
        return this.isPixieSitting();
    }

    public int m_213860_() {
        return 3;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && this.m_217043_().m_188503_(3) == 0 && !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            this.stealCooldown = 3000;
            return true;
        }
        if (this.isOwnerClose() && (source.m_7639_() != null && source == this.m_9236_().m_269111_().m_269564_(source.m_7639_()) || source == this.m_9236_().m_269111_().m_269318_() || this.m_269323_() != null && source.m_7639_() == this.m_269323_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource source) {
        LivingEntity owner;
        boolean invulnerable = super.m_6673_(source);
        if (!invulnerable && (owner = this.m_269323_()) != null && source.m_7639_() == owner) {
            return true;
        }
        return invulnerable;
    }

    public void m_6667_(DamageSource cause) {
        if (!this.m_9236_().f_46443_ && !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        super.m_6667_(cause);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    protected void m_7324_(Entity entityIn) {
        if (this.m_269323_() != entityIn) {
            entityIn.m_7334_((Entity)this);
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_21830_((LivingEntity)player)) {
            if (player.m_21120_(hand).m_204117_(IafItemTags.HEAL_PIXIE) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(5.0f);
                player.m_21120_(hand).m_41774_(1);
                this.m_5496_((SoundEvent)IafSounds.PIXIE_TAUNT.get(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() > 1) {
                this.setCommand(0);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_41720_() == ((Block)IafBlocks.JAR_EMPTY.get()).m_5456_() && !this.m_21824_()) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            Block jar = switch (this.getColor()) {
                case 0 -> (Block)IafBlocks.JAR_PIXIE_0.get();
                case 1 -> (Block)IafBlocks.JAR_PIXIE_1.get();
                case 2 -> (Block)IafBlocks.JAR_PIXIE_2.get();
                case 3 -> (Block)IafBlocks.JAR_PIXIE_3.get();
                case 4 -> (Block)IafBlocks.JAR_PIXIE_4.get();
                default -> Blocks.f_50016_;
            };
            ItemStack stack = new ItemStack((ItemLike)jar, 1);
            if (!this.m_9236_().f_46443_) {
                if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                    this.stealCooldown = 3000;
                }
                this.m_5552_(stack, 0.0f);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PixieAIFollowOwner(this, 1.0, 2.0f, 4.0f));
        this.f_21345_.m_25352_(2, new PixieAIPickupItem(this, false));
        this.f_21345_.m_25352_(2, new PixieAIFlee<Player>(this, Player.class, 10.0f, (Predicate<Player>)((com.google.common.base.Predicate)entity -> true)));
        this.f_21345_.m_25352_(2, (Goal)new PixieAISteal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PixieAIMoveRandom(this));
        this.f_21345_.m_25352_(4, (Goal)new PixieAIEnterHouse(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColor(this.f_19796_.m_188503_(5));
        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (dataTag != null) {
            System.out.println("EntityPixie spawned with dataTag: " + dataTag);
        }
        return spawnDataIn;
    }

    private boolean isBeyondHeight() {
        if (this.m_20186_() > (double)this.m_9236_().m_151558_()) {
            return true;
        }
        BlockPos height = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_20183_());
        int maxY = 20 + height.m_123342_();
        return this.m_20186_() > (double)maxY;
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
        this.setPixieSitting(command == 1);
    }

    public void m_8107_() {
        BlockEntity blockEntity;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.isPixieSitting() && this.getCommand() != 1) {
                this.setPixieSitting(false);
            }
            if (!this.isPixieSitting() && this.getCommand() == 1) {
                this.setPixieSitting(true);
            }
            if (this.isPixieSitting()) {
                this.m_21573_().m_26573_();
            }
        }
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        this.ticksHeldItemFor = !this.m_21205_().m_41619_() && !this.m_21824_() ? ++this.ticksHeldItemFor : 0;
        if (!this.isPixieSitting() && !this.isBeyondHeight()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)IafParticles.PIXIE_DUST.get(), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), (double)PARTICLE_RGB[this.getColor()][0], (double)PARTICLE_RGB[this.getColor()][1], (double)PARTICLE_RGB[this.getColor()][2]);
        }
        if (this.ticksUntilHouseAI > 0) {
            --this.ticksUntilHouseAI;
        }
        if (!this.m_9236_().f_46443_ && this.housePos != null && this.m_20238_(Vec3.m_82512_((Vec3i)this.housePos)) < 1.5 && this.m_9236_().m_7702_(this.housePos) != null && (blockEntity = this.m_9236_().m_7702_(this.housePos)) instanceof BlockEntityPixieHouse) {
            BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
            if (house.hasPixie) {
                this.housePos = null;
            } else {
                house.hasPixie = true;
                house.pixieType = this.getColor();
                house.pixieItems.set(0, (Object)this.m_21120_(InteractionHand.MAIN_HAND));
                house.tamedPixie = this.m_21824_();
                house.pixieOwnerUUID = this.m_21805_();
                FriendlyByteBuf buf = PacketBufferUtils.create().m_130064_(this.housePos);
                buf.writeBoolean(true).writeInt(this.getColor());
                ServerHelper.sendToAll((ResourceLocation)StaticVariables.UPDATE_PIXIE_HOUSE, (FriendlyByteBuf)buf);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.m_269323_() != null && this.isOwnerClose() && this.f_19797_ % 80 == 0) {
            this.m_269323_().m_7292_(new MobEffectInstance(this.positivePotions[this.getColor()], 100, 0, false, false));
        }
    }

    public int getColor() {
        return Mth.m_14045_((int)((Integer)this.m_20088_().m_135370_(COLOR)), (int)0, (int)4);
    }

    public void setColor(int color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public void m_7378_(CompoundTag compound) {
        this.setColor(compound.m_128451_("Color"));
        this.stealCooldown = compound.m_128451_("StealCooldown");
        this.ticksHeldItemFor = compound.m_128451_("HoldingTicks");
        this.setPixieSitting(compound.m_128471_("PixieSitting"));
        this.setCommand(compound.m_128451_("Command"));
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("Color", this.getColor());
        compound.m_128405_("Command", this.getCommand());
        compound.m_128405_("StealCooldown", this.stealCooldown);
        compound.m_128405_("HoldingTicks", this.ticksHeldItemFor);
        compound.m_128379_("PixieSitting", this.isPixieSitting());
        super.m_7380_(compound);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public void setHousePosition(BlockPos blockPos) {
        this.housePos = blockPos;
    }

    public BlockPos getHousePos() {
        return this.housePos;
    }

    public boolean isOwnerClose() {
        return this.m_21824_() && this.m_269323_() != null && this.m_20280_((Entity)this.m_269323_()) < 100.0;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IafSounds.PIXIE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IafSounds.PIXIE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IafSounds.PIXIE_DIE.get();
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    class AIMoveControl
    extends MoveControl {
        public AIMoveControl(EntityPixie pixie) {
            super((Mob)pixie);
        }

        public void m_8126_() {
            float speedMod = 1.0f;
            if (EntityPixie.this.slowSpeed) {
                speedMod = 2.0f;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                if (EntityPixie.this.f_19862_) {
                    EntityPixie.this.m_146922_(this.f_24974_.m_146908_() + 180.0f);
                    speedMod = 0.1f;
                    BlockPos target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.m_9236_(), EntityPixie.this.m_20185_() + (double)EntityPixie.this.f_19796_.m_188503_(15) - 7.0, EntityPixie.this.m_20189_() + (double)EntityPixie.this.f_19796_.m_188503_(15) - 7.0, EntityPixie.this.f_19796_);
                    this.f_24975_ = target.m_123341_();
                    this.f_24976_ = target.m_123342_();
                    this.f_24977_ = target.m_123343_();
                }
                double d0 = this.f_24975_ - EntityPixie.this.m_20185_();
                double d1 = this.f_24976_ - EntityPixie.this.m_20186_();
                double d2 = this.f_24977_ - EntityPixie.this.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = Math.sqrt(d3)) < EntityPixie.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    EntityPixie.this.m_20256_(EntityPixie.this.m_20184_().m_82542_(0.5, 0.5, 0.5));
                } else {
                    EntityPixie.this.m_20256_(EntityPixie.this.m_20184_().m_82520_(d0 / d3 * 0.05 * this.f_24978_ * (double)speedMod, d1 / d3 * 0.05 * this.f_24978_ * (double)speedMod, d2 / d3 * 0.05 * this.f_24978_ * (double)speedMod));
                    if (EntityPixie.this.m_5448_() == null) {
                        EntityPixie.this.m_146922_(-((float)Mth.m_14136_((double)EntityPixie.this.m_20184_().f_82479_, (double)EntityPixie.this.m_20184_().f_82481_)) * 57.295776f);
                        EntityPixie.this.f_20883_ = EntityPixie.this.m_146908_();
                    } else {
                        double d4 = EntityPixie.this.m_5448_().m_20185_() - EntityPixie.this.m_20185_();
                        double d5 = EntityPixie.this.m_5448_().m_20189_() - EntityPixie.this.m_20189_();
                        EntityPixie.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                        EntityPixie.this.f_20883_ = EntityPixie.this.m_146908_();
                    }
                }
            }
        }
    }
}

