/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.entity.EntityMyrmexRoyal;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSentinel;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSoldier;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import com.iafenvoy.iceandfire.world.structure.MyrmexHiveStructure;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityMyrmexEgg
extends LivingEntity
implements IBlacklistedFromStatues,
IDeadMob {
    private static final EntityDataAccessor<Boolean> MYRMEX_TYPE = SynchedEntityData.m_135353_(EntityMyrmexEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MYRMEX_AGE = SynchedEntityData.m_135353_(EntityMyrmexEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MYRMEX_CASTE = SynchedEntityData.m_135353_(EntityMyrmexEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public UUID hiveUUID;

    public EntityMyrmexEgg(EntityType<? extends EntityMyrmexEgg> t, Level worldIn) {
        super(t, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Jungle", this.isJungle());
        tag.m_128405_("MyrmexAge", this.getMyrmexAge());
        tag.m_128405_("MyrmexCaste", this.getMyrmexCaste());
        tag.m_128362_("HiveUUID", this.hiveUUID == null ? (this.hiveUUID = UUID.randomUUID()) : this.hiveUUID);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setJungle(tag.m_128471_("Jungle"));
        this.setMyrmexAge(tag.m_128451_("MyrmexAge"));
        this.setMyrmexCaste(tag.m_128451_("MyrmexCaste"));
        this.hiveUUID = tag.m_128342_("HiveUUID");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(MYRMEX_TYPE, (Object)false);
        this.m_20088_().m_135372_(MYRMEX_AGE, (Object)0);
        this.m_20088_().m_135372_(MYRMEX_CASTE, (Object)0);
    }

    public boolean isJungle() {
        return (Boolean)this.m_20088_().m_135370_(MYRMEX_TYPE);
    }

    public void setJungle(boolean jungle) {
        this.m_20088_().m_135381_(MYRMEX_TYPE, (Object)jungle);
    }

    public int getMyrmexAge() {
        return (Integer)this.m_20088_().m_135370_(MYRMEX_AGE);
    }

    public void setMyrmexAge(int i) {
        this.m_20088_().m_135381_(MYRMEX_AGE, (Object)i);
    }

    public int getMyrmexCaste() {
        return (Integer)this.m_20088_().m_135370_(MYRMEX_CASTE);
    }

    public void setMyrmexCaste(int i) {
        this.m_20088_().m_135381_(MYRMEX_CASTE, (Object)i);
    }

    public boolean canSeeSky() {
        return this.m_9236_().m_46861_(this.m_20183_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.canSeeSky()) {
            this.setMyrmexAge(this.getMyrmexAge() + 1);
        }
        if (this.getMyrmexAge() > (Integer)IafCommonConfig.INSTANCE.myrmex.eggTicks.getValue()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            EntityMyrmexBase myrmex = switch (this.getMyrmexCaste()) {
                case 1 -> new EntityMyrmexSoldier((EntityType<EntityMyrmexSoldier>)((EntityType)IafEntities.MYRMEX_SOLDIER.get()), this.m_9236_());
                case 2 -> new EntityMyrmexRoyal((EntityType<? extends EntityMyrmexRoyal>)((EntityType)IafEntities.MYRMEX_ROYAL.get()), this.m_9236_());
                case 3 -> new EntityMyrmexSentinel((EntityType<? extends EntityMyrmexSentinel>)((EntityType)IafEntities.MYRMEX_SENTINEL.get()), this.m_9236_());
                case 4 -> new EntityMyrmexQueen((EntityType<EntityMyrmexQueen>)((EntityType)IafEntities.MYRMEX_QUEEN.get()), this.m_9236_());
                default -> new EntityMyrmexWorker((EntityType<EntityMyrmexWorker>)((EntityType)IafEntities.MYRMEX_WORKER.get()), this.m_9236_());
            };
            myrmex.setJungleVariant(this.isJungle());
            myrmex.setGrowthStage(0);
            myrmex.m_19890_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            if (myrmex instanceof EntityMyrmexQueen) {
                MyrmexHive hive = new MyrmexHive(this.m_9236_(), this.m_20183_(), 100);
                Player player = this.m_9236_().m_45930_((Entity)this, 30.0);
                if (player != null) {
                    hive.hasOwner = true;
                    hive.ownerUUID = player.m_20148_();
                    if (!this.m_9236_().f_46443_) {
                        hive.modifyPlayerReputation(player.m_20148_(), 100);
                    }
                }
                MyrmexWorldData.addHive(this.m_9236_(), hive);
                myrmex.setHive(hive);
            } else if (MyrmexWorldData.get(this.m_9236_()) != null) {
                MyrmexHive hive = this.hiveUUID == null ? MyrmexWorldData.get(this.m_9236_()).getNearestHive(this.m_20183_(), 400) : MyrmexWorldData.get(this.m_9236_()).getHiveFromUUID(this.hiveUUID);
                if (!this.m_9236_().f_46443_ && hive != null && Math.sqrt(this.m_20275_(hive.getCenter().m_123341_(), hive.getCenter().m_123342_(), hive.getCenter().m_123343_())) < 2000.0) {
                    myrmex.setHive(hive);
                }
            }
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7967_((Entity)myrmex);
            }
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), (SoundEvent)IafSounds.EGG_HATCH.get(), this.m_5720_(), 2.5f, 1.0f, false);
        }
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public boolean m_6469_(DamageSource dmg, float var2) {
        if (dmg.m_276093_(DamageTypes.f_268612_) || dmg.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !dmg.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_5552_(this.getItem(), 0.0f);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        return super.m_6469_(dmg, var2);
    }

    private ItemStack getItem() {
        ItemStack egg = new ItemStack(this.isJungle() ? (ItemLike)IafItems.MYRMEX_JUNGLE_EGG.get() : (ItemLike)IafItems.MYRMEX_DESERT_EGG.get(), 1);
        CompoundTag newTag = new CompoundTag();
        newTag.m_128405_("EggOrdinal", this.getMyrmexCaste());
        egg.m_41751_(newTag);
        return egg;
    }

    public boolean m_6094_() {
        return false;
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    protected void m_7324_(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public boolean isInNursery() {
        MyrmexHive hive = MyrmexWorldData.get(this.m_9236_()).getNearestHive(this.m_20183_(), 100);
        if (hive != null && hive.getRooms(MyrmexHiveStructure.RoomType.NURSERY).isEmpty() && hive.getRandomRoom(MyrmexHiveStructure.RoomType.NURSERY, this.m_217043_(), this.m_20183_()) != null) {
            return false;
        }
        if (hive != null) {
            BlockPos nursery = hive.getRandomRoom(MyrmexHiveStructure.RoomType.NURSERY, this.m_217043_(), this.m_20183_());
            return this.m_20275_(nursery.m_123341_(), nursery.m_123342_(), nursery.m_123343_()) < 2025.0;
        }
        return false;
    }
}

