/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class EntityMultipartPart
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(EntityMultipartPart.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> SCALE_WIDTH = SynchedEntityData.m_135353_(EntityMultipartPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_HEIGHT = SynchedEntityData.m_135353_(EntityMultipartPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PART_YAW = SynchedEntityData.m_135353_(EntityMultipartPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public EntityDimensions multipartSize;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier;

    protected EntityMultipartPart(EntityType<?> t, Level world) {
        super(t, world);
        this.multipartSize = t.m_20680_();
    }

    protected EntityMultipartPart(EntityType<?> t, Entity parent, float radius, float angleYaw, float offsetY, float sizeX, float sizeY, float damageMultiplier) {
        super(t, parent.m_9236_());
        this.setParent(parent);
        this.setScaleX(sizeX);
        this.setScaleY(sizeY);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
        this.damageMultiplier = damageMultiplier;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.1);
    }

    public static boolean sharesRider(Entity parent, Entity entityIn) {
        for (Entity entity : parent.m_20197_()) {
            if (entity.equals((Object)entityIn)) {
                return true;
            }
            if (!EntityMultipartPart.sharesRider(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    protected void m_5841_() {
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return new EntityDimensions(this.getScaleX(), this.getScaleY(), false);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(SCALE_WIDTH, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(SCALE_HEIGHT, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(PART_YAW, (Object)Float.valueOf(0.0f));
    }

    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    private float getScaleX() {
        return ((Float)this.f_19804_.m_135370_(SCALE_WIDTH)).floatValue();
    }

    protected void setScaleX(float scale) {
        this.f_19804_.m_135381_(SCALE_WIDTH, (Object)Float.valueOf(scale));
    }

    private float getScaleY() {
        return ((Float)this.f_19804_.m_135370_(SCALE_HEIGHT)).floatValue();
    }

    protected void setScaleY(float scale) {
        this.f_19804_.m_135381_(SCALE_HEIGHT, (Object)Float.valueOf(scale));
    }

    public float getPartYaw() {
        return ((Float)this.f_19804_.m_135370_(PART_YAW)).floatValue();
    }

    private void setPartYaw(float yaw) {
        this.f_19804_.m_135381_(PART_YAW, (Object)Float.valueOf(yaw % 360.0f));
    }

    public void m_8119_() {
        this.f_19798_ = false;
        if (this.f_19797_ > 10) {
            Entity parent = this.getParent();
            this.m_6210_();
            if (parent != null && !this.m_9236_().f_46443_) {
                float renderYawOffset = parent.m_146908_();
                if (parent instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)parent;
                    renderYawOffset = living.f_20883_;
                }
                if (this.isSlowFollow()) {
                    this.m_6034_(parent.f_19854_ + (double)(this.radius * Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))), parent.f_19855_ + (double)this.offsetY, parent.f_19856_ + (double)(this.radius * Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))));
                    double d0 = parent.m_20185_() - this.m_20185_();
                    double d1 = parent.m_20186_() - this.m_20186_();
                    double d2 = parent.m_20189_() - this.m_20189_();
                    float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                    this.m_146926_(this.limitAngle(this.m_146909_(), f2));
                    this.m_5834_();
                    this.m_146922_(renderYawOffset);
                    this.setPartYaw(this.m_146908_());
                    if (!this.m_9236_().f_46443_) {
                        this.collideWithNearbyEntities();
                    }
                } else {
                    this.m_6034_(parent.m_20185_() + (double)(this.radius * Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))), parent.m_20186_() + (double)this.offsetY, parent.m_20189_() + (double)(this.radius * Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))));
                    this.m_5834_();
                }
                if (!this.m_9236_().f_46443_) {
                    this.collideWithNearbyEntities();
                }
                if (parent.m_213877_() && !this.m_9236_().f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else if (this.f_19797_ > 20 && !this.m_9236_().f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        super.m_8119_();
    }

    protected boolean isSlowFollow() {
        return false;
    }

    protected float limitAngle(float sourceAngle, float targetAngle) {
        float f1;
        float f = Mth.m_14177_((float)(targetAngle - sourceAngle));
        if (f > 5.0f) {
            f = 5.0f;
        }
        if (f < -5.0f) {
            f = -5.0f;
        }
        if ((f1 = sourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Entity getParent() {
        Level level;
        UUID id = this.getParentId();
        if (id != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8791_(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_20148_());
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean m_6087_() {
        return true;
    }

    public void collideWithNearbyEntities() {
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_((double)0.2f, 0.0, (double)0.2f));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> entity != parent && !EntityMultipartPart.sharesRider(parent, entity) && !(entity instanceof EntityMultipartPart) && entity.m_6094_()).forEach(entity -> entity.m_7334_(parent));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        Entity parent = this.getParent();
        if (this.m_9236_().f_46443_ && this.getParentId() != null) {
            FriendlyByteBuf buf = PacketBufferUtils.create();
            buf.m_130077_(this.getParentId()).writeFloat(0.0f);
            NetworkManager.sendToServer((ResourceLocation)StaticVariables.MULTIPART_INTERACT, (FriendlyByteBuf)buf);
        }
        return parent != null ? parent.m_6096_(player, hand) : InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Entity parent = this.getParent();
        if (this.m_9236_().f_46443_ && this.getParentId() != null && source.m_7639_() instanceof Player) {
            FriendlyByteBuf buf = PacketBufferUtils.create();
            buf.m_130077_(this.getParentId()).writeFloat(damage * this.damageMultiplier);
            NetworkManager.sendToServer((ResourceLocation)StaticVariables.MULTIPART_INTERACT, (FriendlyByteBuf)buf);
        }
        return parent != null && parent.m_6469_(source, damage * this.damageMultiplier);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268546_) || source.m_269533_(DamageTypeTags.f_268745_) || super.m_6673_(source);
    }

    public boolean shouldContinuePersisting() {
        return this.m_9236_() != null || this.m_213877_();
    }

    public void m_20359_(Entity entity) {
        super.m_20359_(entity);
        this.m_20256_(entity.m_20184_());
    }
}

