/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.ai.GhostAICharge;
import com.iafenvoy.iceandfire.entity.ai.GhostPathNavigator;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IHumanoid;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

public class EntityGhost
extends Monster
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHumanoid,
IBlacklistedFromStatues,
IHasCustomizableAttributes {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityGhost.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(EntityGhost.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DAYTIME_MODE = SynchedEntityData.m_135353_(EntityGhost.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAS_FROM_CHEST = SynchedEntityData.m_135353_(EntityGhost.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DAYTIME_COUNTER = SynchedEntityData.m_135353_(EntityGhost.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static Animation ANIMATION_SCARE;
    public static Animation ANIMATION_HIT;
    private int animationTick;
    private Animation currentAnimation;

    public EntityGhost(EntityType<EntityGhost> type, Level worldIn) {
        super(type, worldIn);
        ANIMATION_SCARE = Animation.create((int)30);
        ANIMATION_HIT = Animation.create((int)10);
        this.f_21342_ = new MoveHelper(this);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)IafCommonConfig.INSTANCE.ghost.maxHealth.getValue()).doubleValue()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, ((Double)IafCommonConfig.INSTANCE.ghost.attackDamage.getValue()).doubleValue()).m_22268_(Attributes.f_22284_, 1.0);
    }

    protected ResourceLocation m_7582_() {
        return this.wasFromChest() ? BuiltInLootTables.f_78712_ : this.m_6095_().m_20677_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IafSounds.GHOST_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)IafSounds.GHOST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IafSounds.GHOST_DIE.get();
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)IafCommonConfig.INSTANCE.ghost.maxHealth.getValue()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)IafCommonConfig.INSTANCE.ghost.attackDamage.getValue()).doubleValue());
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() != MobEffects.f_19614_ && potioneffectIn.m_19544_() != MobEffects.f_19615_ && super.m_7301_(potioneffectIn);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268526_) || source.m_276093_(DamageTypes.f_268469_);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GhostPathNavigator(this, worldIn);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean moving) {
        this.f_19804_.m_135381_(CHARGING, (Object)moving);
    }

    public boolean isDaytimeMode() {
        return (Boolean)this.f_19804_.m_135370_(IS_DAYTIME_MODE);
    }

    public void setDaytimeMode(boolean moving) {
        this.f_19804_.m_135381_(IS_DAYTIME_MODE, (Object)moving);
    }

    public boolean wasFromChest() {
        return (Boolean)this.f_19804_.m_135370_(WAS_FROM_CHEST);
    }

    public void setFromChest(boolean moving) {
        this.f_19804_.m_135381_(WAS_FROM_CHEST, (Object)moving);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new GhostAICharge(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f){

            public boolean m_8045_() {
                if (this.f_25513_ != null && this.f_25513_ instanceof Player && ((Player)this.f_25513_).m_7500_()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6){

            public boolean m_8036_() {
                this.f_25730_ = 60;
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, Entity::m_6084_));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, false, entity -> DragonUtils.isAlive(entity) && DragonUtils.isVillager((Entity)entity)));
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_19794_ = true;
        if (!this.m_9236_().f_46443_) {
            boolean day;
            boolean bl = day = this.m_21527_() && !this.wasFromChest();
            if (day) {
                if (!this.isDaytimeMode()) {
                    this.setAnimation(ANIMATION_SCARE);
                }
                this.setDaytimeMode(true);
            } else {
                this.setDaytimeMode(false);
                this.setDaytimeCounter(0);
            }
            if (this.isDaytimeMode()) {
                this.m_20256_(Vec3.f_82478_);
                this.setDaytimeCounter(this.getDaytimeCounter() + 1);
                if (this.getDaytimeCounter() >= 100) {
                    this.m_6842_(true);
                }
            } else {
                this.m_6842_(this.m_21023_(MobEffects.f_19609_));
                this.setDaytimeCounter(0);
            }
        } else if (this.getAnimation() == ANIMATION_SCARE && this.getAnimationTick() == 3 && !this.isHauntedShoppingList() && this.f_19796_.m_188503_(3) == 0) {
            this.m_5496_((SoundEvent)IafSounds.GHOST_JUMPSCARE.get(), this.m_6121_(), this.m_6100_());
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)IafParticles.GHOST_APPEARANCE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
            }
        }
        if (this.getAnimation() == ANIMATION_HIT && this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) < 1.4 && this.getAnimationTick() >= 4 && this.getAnimationTick() < 6) {
            this.m_5496_((SoundEvent)IafSounds.GHOST_ATTACK.get(), this.m_6121_(), this.m_6100_());
            this.m_7327_((Entity)this.m_5448_());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean m_21525_() {
        return this.isDaytimeMode() || super.m_21525_();
    }

    public boolean m_20067_() {
        return this.isDaytimeMode() || super.m_20067_();
    }

    protected boolean m_21527_() {
        if (this.m_9236_().m_46461_() && !this.m_9236_().f_46443_) {
            float f = this.m_9236_().m_45517_(LightLayer.BLOCK, this.m_20183_());
            BlockPos blockpos = this.m_20202_() instanceof Boat ? new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_()).m_7494_() : new BlockPos(this.m_146903_(), this.m_146904_() + 4, this.m_146907_());
            return f > 0.5f && this.m_9236_().m_45527_(blockpos);
        }
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack != null && itemstack.m_41720_() == IafItems.MANUSCRIPT.get() && !this.isHauntedShoppingList()) {
            this.setColor(-1);
            this.m_5496_((SoundEvent)IafSounds.BESTIARY_PAGE.get(), 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7023_(Vec3 vec) {
        if (this.isDaytimeMode()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(vec);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColor(this.f_19796_.m_188503_(3));
        if (this.f_19796_.m_188503_(200) == 0) {
            this.setColor(-1);
        }
        return spawnDataIn;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR, (Object)0);
        this.m_20088_().m_135372_(CHARGING, (Object)false);
        this.m_20088_().m_135372_(IS_DAYTIME_MODE, (Object)false);
        this.m_20088_().m_135372_(WAS_FROM_CHEST, (Object)false);
        this.m_20088_().m_135372_(DAYTIME_COUNTER, (Object)0);
    }

    public int getColor() {
        return Mth.m_14045_((int)((Integer)this.m_20088_().m_135370_(COLOR)), (int)-1, (int)2);
    }

    public void setColor(int color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public int getDaytimeCounter() {
        return (Integer)this.m_20088_().m_135370_(DAYTIME_COUNTER);
    }

    public void setDaytimeCounter(int counter) {
        this.m_20088_().m_135381_(DAYTIME_COUNTER, (Object)counter);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColor(compound.m_128451_("Color"));
        this.setDaytimeMode(compound.m_128471_("DaytimeMode"));
        this.setDaytimeCounter(compound.m_128451_("DaytimeCounter"));
        this.setFromChest(compound.m_128471_("FromChest"));
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Color", this.getColor());
        compound.m_128379_("DaytimeMode", this.isDaytimeMode());
        compound.m_128405_("DaytimeCounter", this.getDaytimeCounter());
        compound.m_128379_("FromChest", this.wasFromChest());
    }

    public boolean isHauntedShoppingList() {
        return this.getColor() == -1;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_SCARE, ANIMATION_HIT};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return false;
    }

    static class MoveHelper
    extends MoveControl {
        final EntityGhost ghost;

        public MoveHelper(EntityGhost ghost) {
            super((Mob)ghost);
            this.ghost = ghost;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double edgeLength;
                Vec3 vec3d = new Vec3(this.m_25000_() - this.ghost.m_20185_(), this.m_25001_() - this.ghost.m_20186_(), this.m_25002_() - this.ghost.m_20189_());
                double d0 = vec3d.m_82553_();
                if (d0 < (edgeLength = this.ghost.m_20191_().m_82309_())) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.ghost.m_20256_(this.ghost.m_20184_().m_82490_(0.5));
                } else {
                    this.ghost.m_20256_(this.ghost.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.5 * 0.05 / d0)));
                    if (this.ghost.m_5448_() == null) {
                        Vec3 vec3d1 = this.ghost.m_20184_();
                        this.ghost.m_146922_(-((float)Mth.m_14136_((double)vec3d1.f_82479_, (double)vec3d1.f_82481_)) * 57.295776f);
                        this.ghost.f_20883_ = this.ghost.m_146908_();
                    } else {
                        double d4 = this.ghost.m_5448_().m_20185_() - this.ghost.m_20185_();
                        double d5 = this.ghost.m_5448_().m_20189_() - this.ghost.m_20189_();
                        this.ghost.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                        this.ghost.f_20883_ = this.ghost.m_146908_();
                    }
                }
            }
        }
    }
}

