/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDreadBeast;
import com.iafenvoy.iceandfire.entity.EntityDreadGhoul;
import com.iafenvoy.iceandfire.entity.EntityDreadLichSkull;
import com.iafenvoy.iceandfire.entity.EntityDreadMob;
import com.iafenvoy.iceandfire.entity.EntityDreadScuttler;
import com.iafenvoy.iceandfire.entity.EntityDreadThrall;
import com.iafenvoy.iceandfire.entity.ai.DreadAITargetNonDread;
import com.iafenvoy.iceandfire.entity.ai.DreadLichAIStrife;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IDreadMob;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityDreadLich
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
RangedAttackMob {
    public static final Animation ANIMATION_SPAWN = Animation.create((int)40);
    public static final Animation ANIMATION_SUMMON = Animation.create((int)15);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityDreadLich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MINION_COUNT = SynchedEntityData.m_135353_(EntityDreadLich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final DreadLichAIStrife aiArrowAttack = new DreadLichAIStrife(this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((PathfinderMob)this, 1.0, false);
    private int animationTick;
    private Animation currentAnimation;
    private int fireCooldown = 0;
    private int minionCooldown = 0;

    public EntityDreadLich(EntityType<? extends EntityDreadMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean canLichSpawnOn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        BlockPos blockpos = pos.m_7495_();
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        if (!worldIn.m_8055_(blockpos).m_60643_((BlockGetter)worldIn, blockpos, typeIn)) {
            return false;
        }
        return randomIn.m_188500_() < (Double)IafCommonConfig.INSTANCE.lich.spawnChance.getValue();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return EntityDreadLich.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{IDreadMob.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (Predicate)((com.google.common.base.Predicate)DragonUtils::canHostilesTarget)));
        this.f_21346_.m_25352_(3, (Goal)new DreadAITargetNonDread((Mob)this, LivingEntity.class, false, (Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity))));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(MINION_COUNT, (Object)0);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            BlockState belowBlock = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            if (belowBlock.m_60734_() != Blocks.f_50016_) {
                for (int i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, belowBlock), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20191_().f_82289_, this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                }
            }
            this.m_20334_(0.0, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
        }
        if (this.m_9236_().f_46443_ && this.getAnimation() == ANIMATION_SUMMON) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.m_9236_().m_7106_((ParticleOptions)IafParticles.DREAD_TORCH.get(), this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.m_9236_().m_7106_((ParticleOptions)IafParticles.DREAD_TORCH.get(), this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        if (this.minionCooldown > 0) {
            --this.minionCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IafItems.LICH_STAFF.get()));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setAnimation(ANIMATION_SPAWN);
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        this.setVariant(this.f_19796_.m_188503_(5));
        this.setCombatTask();
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("MinionCount", this.getMinionCount());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setMinionCount(compound.m_128451_("MinionCount"));
        this.setCombatTask();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getMinionCount() {
        return (Integer)this.f_19804_.m_135370_(MINION_COUNT);
    }

    public void setMinionCount(int minions) {
        this.f_19804_.m_135381_(MINION_COUNT, (Object)minions);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN, ANIMATION_SUMMON};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public Entity getCommander() {
        return null;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        if (!this.m_9236_().f_46443_ && slotIn == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void setCombatTask() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.aiAttackOnCollide);
            this.f_21345_.m_25363_((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.m_21205_();
            if (itemstack.m_41720_() == IafItems.LICH_STAFF.get()) {
                int i = 100;
                this.aiArrowAttack.setAttackCooldown(i);
                this.f_21345_.m_25352_(4, (Goal)this.aiArrowAttack);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        boolean flag = false;
        if (this.getMinionCount() < 5 && this.minionCooldown == 0) {
            this.setAnimation(ANIMATION_SUMMON);
            this.m_5496_((SoundEvent)IafSounds.DREAD_LICH_SUMMON.get(), this.m_6121_(), this.m_6100_());
            Mob minion = this.getRandomNewMinion();
            int x = (int)this.m_20185_() - 5 + this.f_19796_.m_188503_(10);
            int z = (int)this.m_20189_() - 5 + this.f_19796_.m_188503_(10);
            double y = this.getHeightFromXZ(x, z);
            minion.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.m_146908_(), this.m_146909_());
            minion.m_6710_(target);
            Level currentLevel = this.m_9236_();
            if (currentLevel instanceof ServerLevelAccessor) {
                minion.m_6518_((ServerLevelAccessor)currentLevel, currentLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            }
            if (minion instanceof EntityDreadMob) {
                ((EntityDreadMob)minion).setCommanderId(this.m_20148_());
            }
            if (!currentLevel.f_46443_) {
                currentLevel.m_7967_((Entity)minion);
            }
            this.minionCooldown = 100;
            this.setMinionCount(this.getMinionCount() + 1);
            flag = true;
        }
        if (this.fireCooldown == 0 && !flag) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_5496_(SoundEvents.f_12609_, this.m_6121_(), this.m_6100_());
            EntityDreadLichSkull skull = new EntityDreadLichSkull((EntityType<? extends AbstractArrow>)((EntityType)IafEntities.DREAD_LICH_SKULL.get()), this.m_9236_(), (LivingEntity)this, 6.0);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() * 2.0f) - skull.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt((float)(d0 * d0 + d2 * d2));
            skull.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 0.0f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            this.m_9236_().m_7967_((Entity)skull);
            this.fireCooldown = 100;
        }
    }

    private Mob getRandomNewMinion() {
        float chance = this.f_19796_.m_188501_();
        if (chance > 0.5f) {
            return new EntityDreadThrall((EntityType<? extends EntityDreadThrall>)((EntityType)IafEntities.DREAD_THRALL.get()), this.m_9236_());
        }
        if (chance > 0.35f) {
            return new EntityDreadGhoul((EntityType<? extends EntityDreadGhoul>)((EntityType)IafEntities.DREAD_GHOUL.get()), this.m_9236_());
        }
        if (chance > 0.15f) {
            return new EntityDreadBeast((EntityType<? extends EntityDreadBeast>)((EntityType)IafEntities.DREAD_BEAST.get()), this.m_9236_());
        }
        return new EntityDreadScuttler((EntityType<? extends EntityDreadScuttler>)((EntityType)IafEntities.DREAD_SCUTTLER.get()), this.m_9236_());
    }

    private double getHeightFromXZ(int x, int z) {
        BlockPos thisPos = new BlockPos(x, (int)(this.m_20186_() + 7.0), z);
        while (this.m_9236_().m_46859_(thisPos) && thisPos.m_123342_() > 2) {
            thisPos = thisPos.m_7495_();
        }
        return (double)thisPos.m_123342_() + 1.0;
    }

    @Override
    public boolean m_7307_(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.m_7307_(entityIn);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12451_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12453_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12452_;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.m_5496_(SoundEvents.f_12454_, 0.15f, 1.0f);
    }
}

