/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntitySlowPart;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIAttack;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIFindSandTarget;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIGetInSand;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIJump;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAITarget;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIWander;
import com.iafenvoy.iceandfire.entity.ai.DeathwormAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.EntityGroundAIRide;
import com.iafenvoy.iceandfire.entity.ai.IAFLookHelper;
import com.iafenvoy.iceandfire.entity.pathfinding.PathNavigateDeathWormLand;
import com.iafenvoy.iceandfire.entity.pathfinding.PathNavigateDeathWormSand;
import com.iafenvoy.iceandfire.entity.util.BlockLaunchExplosion;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.EntityUtil;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IGroundMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.object.entity.collision.ICustomCollisions;
import com.iafenvoy.uranus.util.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityDeathWorm
extends TamableAnimal
implements ISyncMount,
ICustomCollisions,
IBlacklistedFromStatues,
IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IGroundMount,
IHasCustomizableAttributes,
ICustomMoveController {
    public static final ResourceLocation TAN_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/deathworm_tan");
    public static final ResourceLocation WHITE_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/deathworm_white");
    public static final ResourceLocation RED_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/deathworm_red");
    public static final ResourceLocation TAN_GIANT_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/deathworm_tan_giant");
    public static final ResourceLocation WHITE_GIANT_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/deathworm_white_giant");
    public static final ResourceLocation RED_GIANT_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/deathworm_red_giant");
    public static final Animation ANIMATION_BITE = Animation.create((int)10);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityDeathWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(EntityDeathWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> JUMP_TICKS = SynchedEntityData.m_135353_(EntityDeathWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.m_135353_(EntityDeathWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> WORM_AGE = SynchedEntityData.m_135353_(EntityDeathWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> HOME = SynchedEntityData.m_135353_(EntityDeathWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private final LookControl lookHelper;
    public ChainBuffer tail_buffer;
    public float jumpProgress;
    public float prevJumpProgress;
    public DeathwormAITargetItems<?> targetItemsGoal;
    private int animationTick;
    private boolean willExplode = false;
    private int ticksTillExplosion = 60;
    private Animation currentAnimation;
    private final EntitySlowPart[] segments = new EntitySlowPart[7];
    private boolean isSandNavigator;
    private int growthCounter = 0;
    private Player thrower;

    public EntityDeathWorm(EntityType<EntityDeathWorm> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.OPEN, 2.0f);
        this.m_21441_(BlockPathTypes.WATER, 4.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
        this.lookHelper = new IAFLookHelper((Mob)this);
        this.f_19811_ = true;
        if (worldIn.f_46443_) {
            this.tail_buffer = new ChainBuffer();
        }
        this.m_274367_(1.0f);
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue()).doubleValue()).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, ((Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue()).doubleValue()).m_22268_(Attributes.f_22277_, (double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue()).m_22268_(Attributes.f_22284_, 3.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, new EntityGroundAIRide<EntityDeathWorm>(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new DeathWormAIAttack(this));
        this.f_21345_.m_25352_(3, (Goal)new DeathWormAIJump(this, 12));
        this.f_21345_.m_25352_(4, (Goal)new DeathWormAIFindSandTarget(this, 10));
        this.f_21345_.m_25352_(5, (Goal)new DeathWormAIGetInSand(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new DeathWormAIWander(this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetItemsGoal = new DeathwormAITargetItems(this, false, false);
        this.f_21346_.m_25352_(4, this.targetItemsGoal);
        this.f_21346_.m_25352_(5, new DeathWormAITarget<LivingEntity>(this, LivingEntity.class, false, input -> {
            if (this.m_21824_()) {
                return input instanceof Monster;
            }
            if (input != null) {
                if (input.m_20069_() || !DragonUtils.isAlive(input) || this.m_21830_((LivingEntity)input)) {
                    return false;
                }
                if (input instanceof Player || input instanceof Animal) {
                    return true;
                }
                return (Boolean)IafCommonConfig.INSTANCE.deathworm.attackMonsters.getValue();
            }
            return false;
        }));
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(Math.max(6.0, (Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue()));
        this.m_21051_(Attributes.f_22281_).m_22100_(Math.max(1.0, (Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue()));
        this.m_21051_(Attributes.f_22277_).m_22100_((double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue());
    }

    public LookControl m_21563_() {
        return this.lookHelper;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean getCanSpawnHere() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        this.m_9236_().m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13029_);
        return this.m_9236_().m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13029_) && this.m_9236_().m_46803_(blockpos) > 8;
    }

    public void onUpdateParts() {
        if (this.m_213877_()) {
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] != null && !this.segments[i].m_213877_()) continue;
            this.segments[i] = new EntitySlowPart((Entity)this, -0.8f - (float)i * 0.8f, 0.0f, 0.0f, 0.7f, 0.7f, 1.0f);
            this.segments[i].m_20359_((Entity)this);
            this.segments[i].setParent((Entity)this);
            this.segments[i].updateScale(this.m_6134_());
            this.m_9236_().m_7967_((Entity)this.segments[i]);
        }
        for (EntitySlowPart entity : this.segments) {
            EntityUtil.updatePart(entity, (LivingEntity)this);
        }
    }

    public void updateScale(float scale) {
        for (EntitySlowPart entity : this.segments) {
            if (entity == null || entity.m_213877_()) continue;
            entity.updateScale(scale);
        }
    }

    public int m_213860_() {
        return this.m_6134_() > 3.0f ? 20 : 10;
    }

    private void clearSegments() {
        for (EntitySlowPart entity : this.segments) {
            if (entity == null || entity.m_213877_()) continue;
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setExplosive(boolean explosive, Player thrower) {
        this.willExplode = true;
        this.ticksTillExplosion = 60;
        this.thrower = thrower;
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.m_5496_(this.m_6134_() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_ATTACK.get() : (SoundEvent)IafSounds.DEATHWORM_ATTACK.get(), 1.0f, 1.0f);
        }
        if (this.m_217043_().m_188503_(3) == 0 && this.m_6134_() > 1.0f && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && !((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_())) {
            BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.m_9236_(), (Mob)this, entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_(), this.m_6134_());
            explosion.m_46061_();
            explosion.m_46075_(true);
        }
        return false;
    }

    public void m_6667_(DamageSource cause) {
        this.clearSegments();
        super.m_6667_(cause);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected ResourceLocation m_7582_() {
        return switch (this.getVariant()) {
            case 0 -> {
                if (this.m_6134_() > 3.0f) {
                    yield TAN_GIANT_LOOT;
                }
                yield TAN_LOOT;
            }
            case 1 -> {
                if (this.m_6134_() > 3.0f) {
                    yield RED_GIANT_LOOT;
                }
                yield RED_LOOT;
            }
            case 2 -> {
                if (this.m_6134_() > 3.0f) {
                    yield WHITE_GIANT_LOOT;
                }
                yield WHITE_LOOT;
            }
            default -> null;
        };
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(CONTROL_STATE, (Object)0);
        this.f_19804_.m_135372_(WORM_AGE, (Object)10);
        this.f_19804_.m_135372_(HOME, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(JUMP_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("GrowthCounter", this.growthCounter);
        compound.m_128350_("Scale", this.getDeathwormScale());
        compound.m_128405_("WormAge", this.getWormAge());
        compound.m_128356_("WormHome", this.getWormHome().m_121878_());
        compound.m_128379_("WillExplode", this.willExplode);
        this.clearSegments();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.growthCounter = compound.m_128451_("GrowthCounter");
        this.setDeathWormScale(compound.m_128457_("Scale"));
        this.setWormAge(compound.m_128451_("WormAge"));
        this.setWormHome(BlockPos.m_122022_((long)compound.m_128454_("WormHome")));
        this.willExplode = compound.m_128471_("WillExplode");
        this.setConfigurableAttributes();
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
        if (newState) {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.f_19804_.m_135381_(CONTROL_STATE, (Object)state);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getWormJumping() {
        return (Integer)this.f_19804_.m_135370_(JUMP_TICKS);
    }

    public void setWormJumping(int jump) {
        this.f_19804_.m_135381_(JUMP_TICKS, (Object)jump);
    }

    public BlockPos getWormHome() {
        return (BlockPos)this.f_19804_.m_135370_(HOME);
    }

    public void setWormHome(BlockPos home) {
        if (home instanceof BlockPos) {
            this.f_19804_.m_135381_(HOME, (Object)home);
        }
    }

    public int getWormAge() {
        return Math.max(1, (Integer)this.f_19804_.m_135370_(WORM_AGE));
    }

    public void setWormAge(int age) {
        this.f_19804_.m_135381_(WORM_AGE, (Object)age);
    }

    public float m_6134_() {
        return Math.min(this.getDeathwormScale() * ((float)this.getWormAge() / 5.0f), 7.0f);
    }

    public float getDeathwormScale() {
        float scale = ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
        if (scale == 0.0f) {
            scale = (float)RandomHelper.nextDouble((double)1.0, (double)7.0);
            this.setDeathWormScale(scale);
        }
        return scale;
    }

    public void setDeathWormScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
        this.updateScale(scale * ((float)this.getWormAge() / 5.0f));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.m_217043_().m_188503_(3));
        float size = 0.25f + (float)(Math.random() * (double)0.35f);
        this.setDeathWormScale(this.m_217043_().m_188503_(20) == 0 ? size * 4.0f : size);
        return spawnDataIn;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (this.m_20363_(passenger)) {
            this.m_5618_(passenger.m_146908_());
            float radius = -0.5f * this.m_6134_();
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + (double)this.m_20192_() - (double)0.55f, this.m_20189_() + extraZ);
        }
    }

    public LivingEntity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            return player;
        }
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.getWormAge() > 4 && player.m_20202_() == null && player.m_21205_().m_41720_() == Items.f_42523_ && player.m_21206_().m_41720_() == Items.f_42523_ && !this.m_9236_().f_46443_) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void switchNavigator(boolean inSand) {
        if (inSand) {
            this.f_21342_ = new SandMoveHelper();
            this.f_21344_ = new PathNavigateDeathWormSand(this, this.m_9236_());
            this.isSandNavigator = true;
        } else {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new PathNavigateDeathWormLand(this, this.m_9236_());
            this.isSandNavigator = false;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268659_)) {
            return false;
        }
        if (this.m_20160_() && source.m_7639_() != null && this.m_6688_() != null && source.m_7639_() == this.m_6688_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
    }

    public boolean m_5830_() {
        if (this.isInSand()) {
            return false;
        }
        return super.m_5830_();
    }

    protected void m_20314_(double x, double y, double z) {
        PositionImpl blockpos = new PositionImpl(x, y, z);
        Vec3i vec3i = new Vec3i((int)Math.round(blockpos.m_7096_()), (int)Math.round(blockpos.m_7098_()), (int)Math.round(blockpos.m_7094_()));
        Vec3 vector3d = new Vec3(x - blockpos.m_7096_(), y - blockpos.m_7098_(), z - blockpos.m_7094_());
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.m_122159_(vec3i, direction1);
            if (this.m_9236_().m_8055_((BlockPos)blockpos$mutable).m_60838_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutable) && !this.m_9236_().m_8055_((BlockPos)blockpos$mutable).m_204336_(BlockTags.f_13029_)) continue;
            double d1 = vector3d.m_82507_(direction1.m_122434_());
            double d = d2 = direction1.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.f_19796_.m_188501_() * 0.2f + 0.1f;
        float f1 = direction.m_122421_().m_122540_();
        Vec3 vector3d1 = this.m_20184_().m_82490_(0.75);
        if (direction.m_122434_() == Direction.Axis.X) {
            this.m_20334_(f1 * f, vector3d1.f_82480_, vector3d1.f_82481_);
        } else if (direction.m_122434_() == Direction.Axis.Y) {
            this.m_20334_(vector3d1.f_82479_, f1 * f, vector3d1.f_82481_);
        } else if (direction.m_122434_() == Direction.Axis.Z) {
            this.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_, f1 * f);
        }
    }

    private void updateAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(Math.min(0.2, 0.15 * (double)this.m_6134_()));
        this.m_21051_(Attributes.f_22281_).m_22100_(Math.max(1.0, (Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue() * (double)this.m_6134_()));
        this.m_21051_(Attributes.f_22276_).m_22100_(Math.max(6.0, (Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue() * (double)this.m_6134_()));
        this.m_21051_(Attributes.f_22277_).m_22100_((double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue());
        this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22115_());
    }

    public boolean m_214076_(ServerLevel world, LivingEntity entity) {
        if (this.m_21824_()) {
            this.m_5634_(14.0f);
            return false;
        }
        return true;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevJumpProgress = this.jumpProgress;
        if (this.getWormJumping() > 0 && this.jumpProgress < 5.0f) {
            this.jumpProgress += 1.0f;
        }
        if (this.getWormJumping() == 0 && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 1.0f;
        }
        if (this.isInSand() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
        }
        if (this.getWormJumping() > 0) {
            float f2 = (float)(-((double)((float)this.m_20184_().f_82480_) * 57.2957763671875));
            this.m_146926_(f2);
            if (this.isInSand() || this.m_20096_()) {
                this.setWormJumping(this.getWormJumping() - 1);
            }
        }
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_6710_(null);
        }
        if (!(this.m_5448_() == null || this.m_5448_().m_6084_() && DragonUtils.isAlive(this.m_5448_()))) {
            this.m_6710_(null);
        }
        if (this.willExplode) {
            if (this.ticksTillExplosion == 0) {
                if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_())) {
                    this.m_9236_().m_255391_((Entity)this.thrower, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f * this.m_6134_(), false, Level.ExplosionInteraction.MOB);
                }
                this.thrower = null;
            } else {
                --this.ticksTillExplosion;
            }
        }
        if (this.isInSandStrict()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
        }
        if (this.growthCounter > 1000 && this.getWormAge() < 5) {
            this.growthCounter = 0;
            this.setWormAge(Math.min(5, this.getWormAge() + 1));
            this.clearSegments();
            this.m_5634_(15.0f);
            this.setDeathWormScale(this.getDeathwormScale());
            if (this.m_9236_().f_46443_) {
                int i = 0;
                while ((float)i < 10.0f * this.m_6134_()) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), (double)((float)this.getSurface((int)Math.floor(this.m_20185_()), (int)Math.floor(this.m_20186_()), (int)Math.floor(this.m_20189_())) + 0.5f), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                    ++i;
                }
            }
        }
        if (this.getWormAge() < 5) {
            ++this.growthCounter;
        }
        if (this.m_6688_() != null && this.m_5448_() != null) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
        }
        if (this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) < Math.min(4.0, 4.0 * (double)this.m_6134_()) && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
            this.m_5448_().m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), f);
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.4f, 0.0));
        }
    }

    public int getWormBrightness(boolean sky) {
        Vec3 vec3 = this.m_20299_(1.0f);
        BlockPos eyePos = BlockPos.m_274446_((Position)vec3);
        while (eyePos.m_123342_() < 256 && !this.m_9236_().m_46859_(eyePos)) {
            eyePos = eyePos.m_7494_();
        }
        return this.m_9236_().m_45517_(sky ? LightLayer.SKY : LightLayer.BLOCK, eyePos.m_7494_());
    }

    public int getSurface(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        while (!this.m_9236_().m_46859_(pos)) {
            pos = pos.m_7494_();
        }
        return pos.m_123342_();
    }

    protected SoundEvent m_7515_() {
        return this.m_6134_() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_IDLE.get() : (SoundEvent)IafSounds.DEATHWORM_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.m_6134_() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_HURT.get() : (SoundEvent)IafSounds.DEATHWORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_6134_() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_DIE.get() : (SoundEvent)IafSounds.DEATHWORM_DIE.get();
    }

    public void m_8119_() {
        boolean inSand;
        super.m_8119_();
        this.m_6210_();
        this.onUpdateParts();
        if (this.f_19797_ == 1) {
            this.updateScale(this.m_6134_());
        }
        if (this.attack() && this.m_6688_() != null && this.m_6688_() instanceof Player) {
            LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, this.m_6688_(), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
                this.m_5496_(this.m_6134_() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_ATTACK.get() : (SoundEvent)IafSounds.DEATHWORM_ATTACK.get(), 1.0f, 1.0f);
                if (this.m_217043_().m_188503_(3) == 0 && this.m_6134_() > 1.0f) {
                    float radius = 1.5f * this.m_6134_();
                    float angle = (float)Math.PI / 180 * this.f_20883_;
                    double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * Mth.m_14089_((float)angle);
                    BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.m_9236_(), (Mob)this, this.m_20185_() + extraX, this.m_20186_() - (double)this.m_20192_(), this.m_20189_() + extraZ, this.m_6134_() * 0.75f);
                    explosion.m_46061_();
                    explosion.m_46075_(true);
                }
            }
            if (target != null) {
                target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            }
        }
        if (this.isInSand()) {
            BlockPos pos = new BlockPos(this.m_146903_(), this.getSurface(this.m_146903_(), this.m_146904_(), this.m_146907_()), this.m_146907_()).m_7495_();
            BlockState state = this.m_9236_().m_8055_(pos);
            if (state.m_60804_((BlockGetter)this.m_9236_(), pos) && this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), (double)((float)this.getSurface((int)Math.floor(this.m_20185_()), (int)Math.floor(this.m_20186_()), (int)Math.floor(this.m_20189_())) + 0.5f), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
            }
            if (this.f_19797_ % 10 == 0) {
                this.m_5496_(SoundEvents.f_12331_, 1.0f, 0.5f);
            }
        }
        if (this.up() && this.m_20096_()) {
            this.m_6135_();
        }
        boolean bl = inSand = this.isInSand() || this.m_6688_() == null;
        if (inSand && !this.isSandNavigator) {
            this.switchNavigator(true);
        }
        if (!inSand && this.isSandNavigator) {
            this.switchNavigator(false);
        }
        if (this.m_9236_().f_46443_) {
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (LivingEntity)this);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean up() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 2 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(1, dismount);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
    }

    public boolean isSandBelow() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)(this.m_20186_() + 1.0));
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState BlockState2 = this.m_9236_().m_8055_(blockpos);
        return BlockState2.m_204336_(BlockTags.f_13029_);
    }

    public boolean isInSand() {
        return this.m_6688_() == null && this.isInSandStrict();
    }

    public boolean isInSandStrict() {
        return this.m_9236_().m_8055_(this.m_20183_()).m_204336_(BlockTags.f_13029_);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public Entity[] getWormParts() {
        return this.segments;
    }

    public int m_8085_() {
        return 10;
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean canPassThrough(BlockPos pos, BlockState state, VoxelShape shape) {
        return this.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13029_);
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRidingPlayer(Player player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().m_20148_().equals(player.m_20148_());
    }

    @Override
    public Player getRidingPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    @Override
    public double getRideSpeedModifier() {
        return this.isInSand() ? 1.5 : 1.0;
    }

    public double processRiderY(double y) {
        return this.isInSand() ? y + (double)0.2f : y;
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public class SandMoveHelper
    extends MoveControl {
        private final EntityDeathWorm worm;

        public SandMoveHelper() {
            super((Mob)EntityDeathWorm.this);
            this.worm = EntityDeathWorm.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double d1 = this.f_24976_ - this.worm.m_20186_();
                double d2 = this.f_24977_ - this.worm.m_20189_();
                Vec3 Vector3d = new Vec3(this.f_24975_ - this.worm.m_20185_(), this.f_24976_ - this.worm.m_20186_(), this.f_24977_ - this.worm.m_20189_());
                double d0 = Vector3d.m_82553_();
                if (d0 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    this.f_24978_ = 1.0;
                    this.worm.m_20256_(this.worm.m_20184_().m_82549_(Vector3d.m_82490_(this.f_24978_ * 0.05 / d0)));
                    Vec3 Vector3d1 = this.worm.m_20184_();
                    this.worm.m_146922_(-((float)Mth.m_14136_((double)Vector3d1.f_82479_, (double)Vector3d1.f_82481_)) * 57.295776f);
                }
            }
        }
    }
}

