/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.entity.util.IHearsSiren;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SirenData
extends NeedUpdateData {
    public EntitySiren charmedBy;
    public int charmTime;
    public boolean isCharmed;
    private UUID charmedByUUID;
    private int charmedById;
    private boolean isInitialized;

    public void tickCharmed(LivingEntity holder) {
        if (!(holder instanceof Player || holder instanceof AbstractVillager || holder instanceof IHearsSiren)) {
            return;
        }
        if (!this.isInitialized) {
            this.initialize(holder.m_9236_());
        }
        if (this.charmedBy == null) {
            return;
        }
        if (this.charmedBy.isActuallySinging()) {
            Player player;
            if (EntitySiren.isWearingEarplugs(holder) || this.charmTime > (Integer)IafCommonConfig.INSTANCE.siren.maxSingTime.getValue()) {
                this.charmedBy.singCooldown = (Integer)IafCommonConfig.INSTANCE.siren.timeBetweenSongs.getValue();
                this.clearCharm();
                return;
            }
            if (!this.charmedBy.m_6084_() || holder.m_20270_((Entity)this.charmedBy) > 64.0f || holder instanceof Player && ((player = (Player)holder).m_7500_() || player.m_5833_())) {
                this.clearCharm();
                return;
            }
            if (holder.m_20270_((Entity)this.charmedBy) < 5.0f) {
                this.charmedBy.singCooldown = (Integer)IafCommonConfig.INSTANCE.siren.timeBetweenSongs.getValue();
                this.charmedBy.setSinging(false);
                this.charmedBy.m_6710_(holder);
                this.charmedBy.m_21561_(true);
                this.charmedBy.triggerOtherSirens(holder);
                this.clearCharm();
                return;
            }
            this.isCharmed = true;
            ++this.charmTime;
            if (holder.m_217043_().m_188503_(7) == 0) {
                for (int i = 0; i < 5; ++i) {
                    holder.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, holder.m_20185_() + (holder.m_217043_().m_188500_() - 0.5) * 3.0, holder.m_20186_() + (holder.m_217043_().m_188500_() - 0.5) * 3.0, holder.m_20189_() + (holder.m_217043_().m_188500_() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                }
            }
            if (holder.f_19862_) {
                holder.m_6862_(true);
            }
            double motionXAdd = (Math.signum(this.charmedBy.m_20185_() - holder.m_20185_()) * 0.5 - holder.m_20184_().f_82479_) * 0.100000000372529;
            double motionYAdd = (Math.signum(this.charmedBy.m_20186_() - holder.m_20186_() + 1.0) * 0.5 - holder.m_20184_().f_82480_) * 0.100000000372529;
            double motionZAdd = (Math.signum(this.charmedBy.m_20189_() - holder.m_20189_()) * 0.5 - holder.m_20184_().f_82481_) * 0.100000000372529;
            holder.m_20256_(holder.m_20184_().m_82520_(motionXAdd, motionYAdd, motionZAdd));
            if (holder.m_20159_()) {
                holder.m_8127_();
            }
            if (!(holder instanceof Player)) {
                double x = this.charmedBy.m_20185_() - holder.m_20185_();
                double y = this.charmedBy.m_20186_() - 1.0 - holder.m_20186_();
                double z = this.charmedBy.m_20189_() - holder.m_20189_();
                double radius = Math.sqrt(x * x + z * z);
                float xRot = (float)(-(Mth.m_14136_((double)y, (double)radius) * 57.29577951308232));
                float yRot = (float)(Mth.m_14136_((double)z, (double)x) * 57.29577951308232) - 90.0f;
                holder.m_146926_(this.updateRotation(holder.m_146909_(), xRot));
                holder.m_146922_(this.updateRotation(holder.m_146908_(), yRot));
            }
        }
    }

    public void setCharmed(Entity entity) {
        if (!(entity instanceof EntitySiren)) {
            return;
        }
        EntitySiren siren = (EntitySiren)entity;
        this.charmedBy = siren;
        this.isCharmed = true;
        this.triggerUpdate();
    }

    public void clearCharm() {
        this.charmTime = 0;
        this.isCharmed = false;
        this.charmedBy = null;
        this.triggerUpdate();
    }

    public void serialize(CompoundTag tag) {
        CompoundTag sirenData = new CompoundTag();
        if (this.charmedBy != null) {
            sirenData.m_128365_("charmedByUUID", (Tag)NbtUtils.m_129226_((UUID)this.charmedBy.m_20148_()));
            sirenData.m_128405_("charmedById", this.charmedBy.m_19879_());
        } else {
            sirenData.m_128405_("charmedById", -1);
        }
        sirenData.m_128405_("charmTime", this.charmTime);
        sirenData.m_128379_("isCharmed", this.isCharmed);
        tag.m_128365_("sirenData", (Tag)sirenData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag sirenData = tag.m_128469_("sirenData");
        Tag uuidTag = sirenData.m_128423_("charmedByUUID");
        if (uuidTag != null) {
            this.charmedByUUID = NbtUtils.m_129233_((Tag)uuidTag);
        }
        this.charmedById = sirenData.m_128451_("charmedById");
        this.charmTime = sirenData.m_128451_("charmTime");
        this.isCharmed = sirenData.m_128471_("isCharmed");
        this.isInitialized = false;
    }

    private float updateRotation(float angle, float targetAngle) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > 30.0f) {
            f = 30.0f;
        }
        if (f < -30.0f) {
            f = -30.0f;
        }
        return angle + f;
    }

    private void initialize(Level level) {
        Entity entity;
        this.charmedBy = null;
        if (this.charmedByUUID != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity2 = serverLevel.m_8791_(this.charmedByUUID);
            if (entity2 instanceof EntitySiren) {
                EntitySiren siren = (EntitySiren)entity2;
                this.triggerUpdate();
                this.charmedByUUID = null;
                this.charmedBy = siren;
            }
        } else if (this.charmedById != -1 && (entity = level.m_6815_(this.charmedById)) instanceof EntitySiren) {
            EntitySiren siren;
            this.charmedBy = siren = (EntitySiren)entity;
        }
        this.isInitialized = true;
    }
}

