/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class MiscData
extends NeedUpdateData {
    public int loveTicks;
    public int lungeTicks;
    public boolean hasDismounted;
    public List<LivingEntity> targetedByScepter;
    private List<Integer> targetedByScepterIds;
    private boolean isInitialized;

    public void tickMisc(LivingEntity entity) {
        if (!this.isInitialized) {
            this.initialize(entity.m_9236_());
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks == 0) {
                this.triggerUpdate();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21573_().m_26569_();
                }
                return;
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6598_(null);
                mob.m_6703_(null);
                mob.m_6710_(null);
                mob.m_21561_(false);
                mob.m_21573_().m_26573_();
            }
            this.createLoveParticles(entity);
        }
    }

    public List<LivingEntity> getTargetedByScepter() {
        return Objects.requireNonNullElse(this.targetedByScepter, Collections.emptyList());
    }

    public void addScepterTarget(LivingEntity target) {
        if (this.targetedByScepter == null) {
            this.targetedByScepter = new ArrayList<LivingEntity>();
        } else if (this.targetedByScepter.contains(target)) {
            return;
        }
        this.targetedByScepter.add(target);
        this.triggerUpdate();
    }

    public void removeScepterTarget(LivingEntity target) {
        if (this.targetedByScepter == null) {
            return;
        }
        this.targetedByScepter.remove(target);
        this.triggerUpdate();
    }

    public void checkScepterTarget() {
        if (this.targetedByScepter == null) {
            return;
        }
        this.targetedByScepter.removeIf(living -> living.m_213877_() || living.m_21124_(MobEffects.f_19615_) == null || living.m_21124_(MobEffects.f_19615_).m_19557_() <= 0);
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
        this.triggerUpdate();
    }

    public void setLungeTicks(int lungeTicks) {
        this.lungeTicks = lungeTicks;
        this.triggerUpdate();
    }

    public void setDismounted(boolean hasDismounted) {
        this.hasDismounted = hasDismounted;
        this.triggerUpdate();
    }

    public void serialize(CompoundTag tag) {
        CompoundTag miscData = new CompoundTag();
        miscData.m_128405_("loveTicks", this.loveTicks);
        miscData.m_128405_("lungeTicks", this.lungeTicks);
        miscData.m_128379_("hasDismounted", this.hasDismounted);
        if (this.targetedByScepter != null) {
            int[] ids = new int[this.targetedByScepter.size()];
            for (int i = 0; i < this.targetedByScepter.size(); ++i) {
                ids[i] = this.targetedByScepter.get(i).m_19879_();
            }
            tag.m_128385_("targetedByScepterIds", ids);
        }
        tag.m_128365_("miscData", (Tag)miscData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag miscData = tag.m_128469_("miscData");
        this.loveTicks = miscData.m_128451_("loveTicks");
        this.lungeTicks = miscData.m_128451_("lungeTicks");
        this.hasDismounted = miscData.m_128471_("hasDismounted");
        int[] loadedChainedToIds = miscData.m_128465_("targetedByScepterIds");
        this.isInitialized = false;
        if (loadedChainedToIds.length > 0) {
            this.targetedByScepterIds = new ArrayList<Integer>();
            for (int loadedChainedToId : loadedChainedToIds) {
                this.targetedByScepterIds.add(loadedChainedToId);
            }
        }
    }

    private void createLoveParticles(LivingEntity entity) {
        if (entity.m_217043_().m_188503_(7) == 0) {
            for (int i = 0; i < 5; ++i) {
                entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * 3.0, entity.m_20186_() + (entity.m_217043_().m_188500_() - 0.5) * 3.0, entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void initialize(Level level) {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        if (this.targetedByScepterIds != null) {
            for (int id : this.targetedByScepterIds) {
                Entity entity;
                if (id == -1 || !((entity = level.m_6815_(id)) instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                entities.add(livingEntity);
            }
        }
        this.targetedByScepter = !entities.isEmpty() ? entities : null;
        this.targetedByScepterIds = null;
        this.isInitialized = true;
    }
}

