/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class FrozenData
extends NeedUpdateData {
    public int frozenTicks;
    public boolean isFrozen;

    public void tickFrozen(LivingEntity entity) {
        Player player;
        if (!this.isFrozen) {
            return;
        }
        if (entity instanceof EntityIceDragon) {
            this.clearFrozen(entity);
            return;
        }
        if (entity.m_6060_()) {
            this.clearFrozen(entity);
            entity.m_20095_();
            return;
        }
        if (entity.m_21224_()) {
            this.clearFrozen(entity);
            return;
        }
        if (this.frozenTicks > 0) {
            --this.frozenTicks;
        } else {
            this.clearFrozen(entity);
        }
        if (!(!this.isFrozen || entity instanceof Player && (player = (Player)entity).m_7500_())) {
            entity.m_20256_(entity.m_20184_().m_82542_(0.25, 1.0, 0.25));
            if (!(entity instanceof EnderDragon) && !entity.m_20096_()) {
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, -0.2, 0.0));
            }
        }
    }

    public void setFrozen(LivingEntity target, int duration) {
        if (!this.isFrozen) {
            target.m_5496_(SoundEvents.f_11986_, 1.0f, 1.0f);
        }
        this.frozenTicks = duration;
        this.isFrozen = true;
        this.triggerUpdate();
    }

    private void clearFrozen(LivingEntity entity) {
        for (int i = 0; i < 15; ++i) {
            entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)IafBlocks.DRAGON_ICE.get()).m_49966_()), entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + entity.m_217043_().m_188500_() * (double)entity.m_20206_(), entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_(), 0.0, 0.0, 0.0);
        }
        entity.m_5496_(SoundEvents.f_11983_, 3.0f, 1.0f);
        this.isFrozen = false;
        this.frozenTicks = 0;
        this.triggerUpdate();
    }

    public void serialize(CompoundTag tag) {
        CompoundTag frozenData = new CompoundTag();
        frozenData.m_128405_("frozenTicks", this.frozenTicks);
        frozenData.m_128379_("isFrozen", this.isFrozen);
        tag.m_128365_("frozenData", (Tag)frozenData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag frozenData = tag.m_128469_("frozenData");
        this.frozenTicks = frozenData.m_128451_("frozenTicks");
        this.isFrozen = frozenData.m_128471_("isFrozen");
    }
}

