/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.item.armor.ItemTrollArmor;
import com.iafenvoy.iceandfire.item.tool.ItemTrollWeapon;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import com.iafenvoy.uranus.object.item.CustomArmorMaterial;
import com.iafenvoy.uranus.util.RandomHelper;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.ApiStatus;

public class TrollType {
    private static final List<TrollType> TYPES = new ArrayList<TrollType>();
    private static final Map<String, TrollType> BY_NAME = new HashMap<String, TrollType>();
    public static final TrollType FOREST = new TrollType("forest", IafItems.TROLL_FOREST_ARMOR_MATERIAL, biome -> biome.m_203656_(IafBiomeTags.FOREST_TROLL), ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/troll_forest"), BuiltinWeapon.TRUNK, BuiltinWeapon.COLUMN_FOREST, BuiltinWeapon.AXE, BuiltinWeapon.HAMMER);
    public static final TrollType FROST = new TrollType("frost", IafItems.TROLL_FROST_ARMOR_MATERIAL, biome -> biome.m_203656_(IafBiomeTags.SNOWY_TROLL), ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/troll_frost"), BuiltinWeapon.COLUMN_FROST, BuiltinWeapon.TRUNK_FROST, BuiltinWeapon.AXE, BuiltinWeapon.HAMMER);
    public static final TrollType MOUNTAIN = new TrollType("mountain", IafItems.TROLL_MOUNTAIN_ARMOR_MATERIAL, biome -> biome.m_203656_(IafBiomeTags.MOUNTAIN_TROLL), ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/troll_mountain"), BuiltinWeapon.COLUMN, BuiltinWeapon.AXE, BuiltinWeapon.HAMMER);
    public RegistrySupplier<Item> leather;
    public RegistrySupplier<Item> helmet;
    public RegistrySupplier<Item> chestplate;
    public RegistrySupplier<Item> leggings;
    public RegistrySupplier<Item> boots;
    private final String name;
    private final CustomArmorMaterial material;
    private final Predicate<Holder<Biome>> biomePredicate;
    private final ResourceLocation lootTable;
    private final List<BuiltinWeapon> weapons;

    public TrollType(String name, CustomArmorMaterial material, Predicate<Holder<Biome>> biomePredicate, ResourceLocation lootTable, BuiltinWeapon ... weapons) {
        this.name = name;
        this.weapons = List.of(weapons);
        this.material = material;
        this.biomePredicate = biomePredicate;
        this.lootTable = lootTable;
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public static TrollType getBiomeType(Holder<Biome> biome) {
        List<TrollType> types = TYPES.stream().filter(x -> x.allowSpawn(biome)).toList();
        return (TrollType)RandomHelper.randomOne(types.isEmpty() ? TYPES : types);
    }

    public static BuiltinWeapon getWeaponForType(TrollType troll) {
        return troll.weapons.get(ThreadLocalRandom.current().nextInt(troll.weapons.size()));
    }

    public static void initArmors() {
        for (TrollType troll : TYPES) {
            troll.leather = IafItems.register("troll_leather_%s".formatted(troll.name.toLowerCase(Locale.ROOT)), () -> new Item(new Item.Properties()));
            troll.helmet = IafItems.register(ItemTrollArmor.getName(troll, EquipmentSlot.HEAD), () -> new ItemTrollArmor(troll, ArmorItem.Type.HELMET));
            troll.chestplate = IafItems.register(ItemTrollArmor.getName(troll, EquipmentSlot.CHEST), () -> new ItemTrollArmor(troll, ArmorItem.Type.CHESTPLATE));
            troll.leggings = IafItems.register(ItemTrollArmor.getName(troll, EquipmentSlot.LEGS), () -> new ItemTrollArmor(troll, ArmorItem.Type.LEGGINGS));
            troll.boots = IafItems.register(ItemTrollArmor.getName(troll, EquipmentSlot.FEET), () -> new ItemTrollArmor(troll, ArmorItem.Type.BOOTS));
        }
    }

    public static List<TrollType> values() {
        return ImmutableList.copyOf(TYPES);
    }

    public static TrollType getByName(String name) {
        return BY_NAME.getOrDefault(name, FOREST);
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public CustomArmorMaterial getMaterial() {
        return this.material;
    }

    public ResourceLocation getTexture() {
        return ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/troll/troll_" + this.name + ".png"));
    }

    public ResourceLocation getStatueTexture() {
        return ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/troll/troll_" + this.name + "_stone.png"));
    }

    public ResourceLocation getEyesTexture() {
        return ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/troll/troll_" + this.name + "_eyes.png"));
    }

    public boolean allowSpawn(Holder<Biome> biome) {
        return this.biomePredicate.test(biome);
    }

    public static enum BuiltinWeapon implements ITrollWeapon
    {
        AXE,
        COLUMN,
        COLUMN_FOREST,
        COLUMN_FROST,
        HAMMER,
        TRUNK,
        TRUNK_FROST;

        private final RegistrySupplier<Item> item = IafItems.register("troll_weapon_" + this.name().toLowerCase(Locale.ROOT), () -> new ItemTrollWeapon(this));

        private BuiltinWeapon() {
            ITrollWeapon.addWeapons(this);
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public ResourceLocation getTexture() {
            return ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/troll/weapon/weapon_" + this.name().toLowerCase(Locale.ROOT) + ".png"));
        }

        @Override
        public Item getItem() {
            return (Item)this.item.get();
        }
    }

    public static interface ITrollWeapon {
        @ApiStatus.Internal
        public static final List<ITrollWeapon> WEAPONS = new ArrayList<ITrollWeapon>();
        @ApiStatus.Internal
        public static final Map<String, ITrollWeapon> BY_NAME = new HashMap<String, ITrollWeapon>();

        public static void addWeapons(ITrollWeapon ... weapons) {
            for (ITrollWeapon weapon : weapons) {
                WEAPONS.add(weapon);
                BY_NAME.put(weapon.getName(), weapon);
            }
        }

        public static List<ITrollWeapon> values() {
            return ImmutableList.copyOf(WEAPONS);
        }

        public static ITrollWeapon getByName(String name) {
            return BY_NAME.getOrDefault(name, BuiltinWeapon.AXE);
        }

        public String getName();

        public ResourceLocation getTexture();

        public Item getItem();
    }
}

